/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.zip.Checksum;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.io.fs.ChecksumWriter;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.PhysicalFlushableChecksumChannel;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.fs.StoreFileChannel;
import org.neo4j.io.memory.HeapScopedBuffer;
import org.neo4j.io.memory.ScopedBuffer;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;

@TestDirectoryExtension
class PhysicalFlushableChecksumChannelTest {
    @Inject
    private DefaultFileSystemAbstraction fileSystem;
    @Inject
    private TestDirectory directory;

    PhysicalFlushableChecksumChannelTest() {
    }

    @Test
    void calculateChecksum() throws IOException {
        int channelChecksum;
        Path firstFile = this.directory.homePath().resolve("file1");
        StoreFileChannel storeChannel = this.fileSystem.write(firstFile);
        try (PhysicalFlushableChecksumChannel channel = new PhysicalFlushableChecksumChannel((StoreChannel)storeChannel, (ScopedBuffer)new HeapScopedBuffer(100, (MemoryTracker)EmptyMemoryTracker.INSTANCE));){
            channel.beginChecksum();
            channel.put((byte)10);
            channelChecksum = channel.putChecksum();
        }
        int fileSize = (int)this.fileSystem.getFileSize(firstFile);
        Assertions.assertEquals((int)5, (int)fileSize);
        byte[] writtenBytes = new byte[fileSize];
        try (InputStream in = Files.newInputStream(firstFile, new OpenOption[0]);){
            in.read(writtenBytes);
        }
        ByteBuffer buffer = ByteBuffer.wrap(writtenBytes);
        Checksum checksum = (Checksum)ChecksumWriter.CHECKSUM_FACTORY.get();
        checksum.update(10);
        Assertions.assertEquals((long)checksum.getValue(), (long)channelChecksum);
        Assertions.assertEquals((int)10, (int)buffer.get());
        Assertions.assertEquals((long)checksum.getValue(), (long)buffer.getInt());
    }

    @Test
    void beginCehcksumShouldResetCalculations() throws IOException {
        int channelChecksum;
        Path firstFile = this.directory.homePath().resolve("file1");
        StoreFileChannel storeChannel = this.fileSystem.write(firstFile);
        try (PhysicalFlushableChecksumChannel channel = new PhysicalFlushableChecksumChannel((StoreChannel)storeChannel, (ScopedBuffer)new HeapScopedBuffer(100, (MemoryTracker)EmptyMemoryTracker.INSTANCE));){
            channel.put((byte)5);
            channel.beginChecksum();
            channel.put((byte)10);
            channelChecksum = channel.putChecksum();
        }
        int fileSize = (int)this.fileSystem.getFileSize(firstFile);
        Assertions.assertEquals((int)6, (int)fileSize);
        byte[] writtenBytes = new byte[fileSize];
        try (InputStream in = Files.newInputStream(firstFile, new OpenOption[0]);){
            in.read(writtenBytes);
        }
        ByteBuffer buffer = ByteBuffer.wrap(writtenBytes);
        Checksum checksum = (Checksum)ChecksumWriter.CHECKSUM_FACTORY.get();
        checksum.update(10);
        Assertions.assertEquals((long)checksum.getValue(), (long)channelChecksum);
        Assertions.assertEquals((int)5, (int)buffer.get());
        Assertions.assertEquals((int)10, (int)buffer.get());
        Assertions.assertEquals((long)checksum.getValue(), (long)buffer.getInt());
    }
}

