/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.pruning;

import java.io.IOException;
import java.nio.file.Path;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.transaction.log.LogFileInformation;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFile;
import org.neo4j.kernel.impl.transaction.log.pruning.Threshold;
import org.neo4j.kernel.impl.transaction.log.pruning.ThresholdBasedPruneStrategy;

class ThresholdBasedPruneStrategyTest {
    private final FileSystemAbstraction fileSystem = (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class);
    private final LogFile logFile = (LogFile)Mockito.mock(TransactionLogFile.class);
    private final Threshold threshold = (Threshold)Mockito.mock(Threshold.class);

    ThresholdBasedPruneStrategyTest() {
    }

    @Test
    void shouldNotDeleteAnythingIfThresholdDoesNotAllow() throws IOException {
        Path fileName0 = Path.of("logical.log.v0", new String[0]);
        Path fileName1 = Path.of("logical.log.v1", new String[0]);
        Path fileName2 = Path.of("logical.log.v2", new String[0]);
        Path fileName3 = Path.of("logical.log.v3", new String[0]);
        Path fileName4 = Path.of("logical.log.v4", new String[0]);
        Path fileName5 = Path.of("logical.log.v5", new String[0]);
        Path fileName6 = Path.of("logical.log.v6", new String[0]);
        Mockito.when((Object)this.logFile.getLogFileForVersion(6L)).thenReturn((Object)fileName6);
        Mockito.when((Object)this.logFile.getLogFileForVersion(5L)).thenReturn((Object)fileName5);
        Mockito.when((Object)this.logFile.getLogFileForVersion(4L)).thenReturn((Object)fileName4);
        Mockito.when((Object)this.logFile.getLogFileForVersion(3L)).thenReturn((Object)fileName3);
        Mockito.when((Object)this.logFile.getLogFileForVersion(2L)).thenReturn((Object)fileName2);
        Mockito.when((Object)this.logFile.getLogFileForVersion(1L)).thenReturn((Object)fileName1);
        Mockito.when((Object)this.logFile.getLogFileForVersion(0L)).thenReturn((Object)fileName0);
        Mockito.when((Object)this.logFile.getLowestLogVersion()).thenReturn((Object)0L);
        Mockito.when((Object)this.fileSystem.fileExists(fileName6)).thenReturn((Object)true);
        Mockito.when((Object)this.fileSystem.fileExists(fileName5)).thenReturn((Object)true);
        Mockito.when((Object)this.fileSystem.fileExists(fileName4)).thenReturn((Object)true);
        Mockito.when((Object)this.fileSystem.fileExists(fileName3)).thenReturn((Object)true);
        Mockito.when((Object)this.fileSystem.fileExists(fileName2)).thenReturn((Object)true);
        Mockito.when((Object)this.fileSystem.fileExists(fileName1)).thenReturn((Object)true);
        Mockito.when((Object)this.fileSystem.fileExists(fileName0)).thenReturn((Object)true);
        Mockito.when((Object)this.fileSystem.getFileSize((Path)ArgumentMatchers.any(Path.class))).thenReturn((Object)65L);
        Mockito.when((Object)this.threshold.reached((Path)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), (LogFileInformation)ArgumentMatchers.any())).thenReturn((Object)false);
        ThresholdBasedPruneStrategy strategy = new ThresholdBasedPruneStrategy(this.logFile, this.threshold);
        strategy.findLogVersionsToDelete(7L).forEachOrdered(IOUtils.uncheckedLongConsumer(v -> this.fileSystem.deleteFile(this.logFile.getLogFileForVersion(v))));
        ((Threshold)Mockito.verify((Object)this.threshold)).init();
        ((FileSystemAbstraction)Mockito.verify((Object)this.fileSystem, (VerificationMode)Mockito.never())).deleteFile((Path)ArgumentMatchers.any(Path.class));
    }

    @Test
    void shouldDeleteJustWhatTheThresholdSays() throws IOException {
        Mockito.when((Object)this.threshold.reached((Path)ArgumentMatchers.any(), ArgumentMatchers.eq((long)6L), (LogFileInformation)ArgumentMatchers.any())).thenReturn((Object)false);
        Mockito.when((Object)this.threshold.reached((Path)ArgumentMatchers.any(), ArgumentMatchers.eq((long)5L), (LogFileInformation)ArgumentMatchers.any())).thenReturn((Object)false);
        Mockito.when((Object)this.threshold.reached((Path)ArgumentMatchers.any(), ArgumentMatchers.eq((long)4L), (LogFileInformation)ArgumentMatchers.any())).thenReturn((Object)false);
        Mockito.when((Object)this.threshold.reached((Path)ArgumentMatchers.any(), ArgumentMatchers.eq((long)3L), (LogFileInformation)ArgumentMatchers.any())).thenReturn((Object)true);
        Path fileName1 = Path.of("logical.log.v1", new String[0]);
        Path fileName2 = Path.of("logical.log.v2", new String[0]);
        Path fileName3 = Path.of("logical.log.v3", new String[0]);
        Path fileName4 = Path.of("logical.log.v4", new String[0]);
        Path fileName5 = Path.of("logical.log.v5", new String[0]);
        Path fileName6 = Path.of("logical.log.v6", new String[0]);
        Mockito.when((Object)this.logFile.getLogFileForVersion(6L)).thenReturn((Object)fileName6);
        Mockito.when((Object)this.logFile.getLogFileForVersion(5L)).thenReturn((Object)fileName5);
        Mockito.when((Object)this.logFile.getLogFileForVersion(4L)).thenReturn((Object)fileName4);
        Mockito.when((Object)this.logFile.getLogFileForVersion(3L)).thenReturn((Object)fileName3);
        Mockito.when((Object)this.logFile.getLogFileForVersion(2L)).thenReturn((Object)fileName2);
        Mockito.when((Object)this.logFile.getLogFileForVersion(1L)).thenReturn((Object)fileName1);
        Mockito.when((Object)this.logFile.getLowestLogVersion()).thenReturn((Object)1L);
        Mockito.when((Object)this.fileSystem.getFileSize((Path)ArgumentMatchers.any(Path.class))).thenReturn((Object)65L);
        ThresholdBasedPruneStrategy strategy = new ThresholdBasedPruneStrategy(this.logFile, this.threshold);
        strategy.findLogVersionsToDelete(7L).forEachOrdered(IOUtils.uncheckedLongConsumer(v -> this.fileSystem.deleteFile(this.logFile.getLogFileForVersion(v))));
        ((Threshold)Mockito.verify((Object)this.threshold)).init();
        ((FileSystemAbstraction)Mockito.verify((Object)this.fileSystem)).deleteFile(fileName1);
        ((FileSystemAbstraction)Mockito.verify((Object)this.fileSystem)).deleteFile(fileName2);
        ((FileSystemAbstraction)Mockito.verify((Object)this.fileSystem)).deleteFile(fileName3);
        ((FileSystemAbstraction)Mockito.verify((Object)this.fileSystem, (VerificationMode)Mockito.never())).deleteFile(fileName4);
        ((FileSystemAbstraction)Mockito.verify((Object)this.fileSystem, (VerificationMode)Mockito.never())).deleteFile(fileName5);
        ((FileSystemAbstraction)Mockito.verify((Object)this.fileSystem, (VerificationMode)Mockito.never())).deleteFile(fileName6);
    }

    @Test
    void minimalAvailableVersionHigherThanRequested() {
        Mockito.when((Object)this.logFile.getLowestLogVersion()).thenReturn((Object)10L);
        Mockito.when((Object)this.threshold.reached((Path)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), (LogFileInformation)ArgumentMatchers.any())).thenReturn((Object)true);
        ThresholdBasedPruneStrategy strategy = new ThresholdBasedPruneStrategy(this.logFile, this.threshold);
        Assertions.assertFalse((boolean)strategy.findLogVersionsToDelete(5L).findAny().isPresent());
    }

    @Test
    void rangeWithMissingFilesCanBeProduced() {
        Mockito.when((Object)this.logFile.getLowestLogVersion()).thenReturn((Object)10L);
        Mockito.when((Object)this.threshold.reached((Path)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), (LogFileInformation)ArgumentMatchers.any())).thenReturn((Object)true);
        Mockito.when((Object)this.fileSystem.fileExists((Path)ArgumentMatchers.any(Path.class))).thenReturn((Object)false);
        ThresholdBasedPruneStrategy strategy = new ThresholdBasedPruneStrategy(this.logFile, this.threshold);
        Assertions.assertArrayEquals((long[])new long[]{10L, 11L, 12L, 13L}, (long[])strategy.findLogVersionsToDelete(15L).toArray());
    }

    @Test
    void mustHaveToStringOfThreshold() {
        Threshold threshold = new Threshold(){

            public void init() {
            }

            public boolean reached(Path file, long version, LogFileInformation source) {
                return false;
            }

            public String toString() {
                return "Super-duper threshold";
            }
        };
        ThresholdBasedPruneStrategy strategy = new ThresholdBasedPruneStrategy(this.logFile, threshold);
        Assertions.assertEquals((Object)"Super-duper threshold", (Object)strategy.toString());
    }
}

