/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import java.util.Collection;
import java.util.HashMap;
import java.util.function.IntPredicate;
import org.assertj.core.api.Assertions;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.impl.block.factory.primitive.IntPredicates;
import org.eclipse.collections.impl.factory.primitive.IntLists;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.neo4j.collection.PrimitiveArrays;
import org.neo4j.configuration.Config;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.kernel.api.PopulationProgress;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.api.index.PropertyScanConsumer;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.api.index.TokenScanConsumer;
import org.neo4j.kernel.impl.scheduler.JobSchedulerFactory;
import org.neo4j.kernel.impl.transaction.state.storeview.NodeStoreScan;
import org.neo4j.kernel.impl.transaction.state.storeview.TestPropertyScanConsumer;
import org.neo4j.kernel.impl.transaction.state.storeview.TestTokenScanConsumer;
import org.neo4j.lock.LockService;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.StubStorageCursors;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@ExtendWith(value={RandomExtension.class})
class NodeStoreScanTest {
    private static final String KEY_NAME = "name";
    private static final String KEY_AGE = "age";
    @Inject
    private RandomRule random;
    private final LockService locks = (LockService)Mockito.mock(LockService.class, (Answer)Mockito.RETURNS_MOCKS);
    private final StubStorageCursors cursors = new StubStorageCursors();
    private final int[] allPossibleLabelIds = new int[]{1, 2, 3, 4};
    private int nameKeyId;
    private int ageKeyId;
    private final JobScheduler jobScheduler = JobSchedulerFactory.createInitialisedScheduler();

    NodeStoreScanTest() {
    }

    @AfterEach
    void tearDown() throws Exception {
        this.jobScheduler.close();
    }

    @BeforeEach
    void setUp() throws KernelException {
        this.nameKeyId = this.cursors.propertyKeyTokenHolder().getOrCreateId(KEY_NAME);
        this.ageKeyId = this.cursors.propertyKeyTokenHolder().getOrCreateId(KEY_AGE);
    }

    @Test
    void shouldScanOverRelevantNodesAllLabelsAndAllProperties() {
        this.shouldScanOverRelevantNodes(this.allPossibleLabelIds, (IntPredicate)IntPredicates.alwaysTrue());
    }

    @Test
    void shouldScanOverRelevantNodesAllLabelsAndSomeProperties() {
        this.shouldScanOverRelevantNodes(this.allPossibleLabelIds, key -> key == this.nameKeyId);
    }

    @Test
    void shouldScanOverRelevantNodesSomeLabelsAndAllProperties() {
        this.shouldScanOverRelevantNodes(this.randomLabels(), (IntPredicate)IntPredicates.alwaysTrue());
    }

    @Test
    void shouldScanOverRelevantNodesSomeLabelsAndSomeProperties() {
        this.shouldScanOverRelevantNodes(this.randomLabels(), key -> key == this.ageKeyId);
    }

    @Test
    void shouldSeeZeroProgressBeforeRunStarted() {
        NodeStoreScan scan = new NodeStoreScan(Config.defaults(), (StorageReader)this.cursors, this.locks, (TokenScanConsumer)Mockito.mock(TokenScanConsumer.class), (PropertyScanConsumer)Mockito.mock(PropertyScanConsumer.class), this.allPossibleLabelIds, k -> true, false, this.jobScheduler, PageCacheTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        PopulationProgress progressBeforeStarted = scan.getProgress();
        Assertions.assertThat((long)progressBeforeStarted.getCompleted()).isZero();
    }

    private void shouldScanOverRelevantNodes(int[] labelFilter, IntPredicate propertyKeyFilter) {
        long total = 100L;
        LongHashSet expectedPropertyUpdatesNodes = new LongHashSet();
        LongHashSet expectedTokenUpdatesNodes = new LongHashSet();
        for (long id = 0L; id < total; ++id) {
            StubStorageCursors.NodeData node = this.cursors.withNode(id);
            int[] labels = this.randomLabels();
            node.labels(PrimitiveArrays.intsToLongs((int[])labels));
            HashMap<String, Value> properties = new HashMap<String, Value>();
            boolean passesPropertyFilter = false;
            if (this.random.nextBoolean()) {
                properties.put(KEY_NAME, Values.of((Object)("Node_" + id)));
                passesPropertyFilter |= propertyKeyFilter.test(this.nameKeyId);
            }
            if (this.random.nextBoolean()) {
                properties.put(KEY_AGE, Values.of((Object)id));
                passesPropertyFilter |= propertyKeyFilter.test(this.ageKeyId);
            }
            node.properties(properties);
            if (passesPropertyFilter && PrimitiveArrays.intersect((long[])PrimitiveArrays.intsToLongs((int[])labels), (long[])PrimitiveArrays.intsToLongs((int[])labelFilter)).length > 0) {
                expectedPropertyUpdatesNodes.add(id);
            }
            if (labels.length <= 0) continue;
            expectedTokenUpdatesNodes.add(id);
        }
        TestTokenScanConsumer tokenConsumer = new TestTokenScanConsumer();
        TestPropertyScanConsumer propertyConsumer = new TestPropertyScanConsumer();
        NodeStoreScan scan = new NodeStoreScan(Config.defaults(), (StorageReader)this.cursors, this.locks, (TokenScanConsumer)tokenConsumer, (PropertyScanConsumer)propertyConsumer, labelFilter, propertyKeyFilter, false, this.jobScheduler, PageCacheTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        Assertions.assertThat((long)scan.getProgress().getCompleted()).isZero();
        scan.run(StoreScan.NO_EXTERNAL_UPDATES);
        Assertions.assertThat((Object)LongSets.mutable.of(tokenConsumer.batches.stream().flatMap(Collection::stream).mapToLong(record -> record.getEntityId()).toArray())).isEqualTo((Object)expectedTokenUpdatesNodes);
        Assertions.assertThat((Object)LongSets.mutable.of(propertyConsumer.batches.stream().flatMap(Collection::stream).mapToLong(record -> record.getEntityId()).toArray())).isEqualTo((Object)expectedPropertyUpdatesNodes);
    }

    private int[] randomLabels() {
        MutableIntList list = IntLists.mutable.empty();
        for (int i = this.random.nextInt(this.allPossibleLabelIds.length); i < this.allPossibleLabelIds.length; i += this.random.nextInt(1, this.allPossibleLabelIds.length - 1)) {
            list.add(this.allPossibleLabelIds[i]);
        }
        return list.toArray();
    }
}

