/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.trackable;

import org.github.jamm.MemoryMeter;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.collection.PrimitiveLongResourceIterator;
import org.neo4j.collection.trackable.HeapTrackingLongArrayList;
import org.neo4j.memory.LocalMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.rule.RandomRule;

@ExtendWith(value={RandomExtension.class})
class HeapTrackingLongArrayListTrackingTest {
    @Inject
    private RandomRule rnd;
    private final MemoryMeter meter = new MemoryMeter();
    private final MemoryTracker memoryTracker = new LocalMemoryTracker();
    private final HeapTrackingLongArrayList list = HeapTrackingLongArrayList.newLongArrayList((int)16, (MemoryTracker)this.memoryTracker);

    HeapTrackingLongArrayListTrackingTest() {
    }

    @AfterEach
    void tearDown() {
        this.list.close();
        Assertions.assertEquals((long)0L, (long)this.memoryTracker.estimatedHeapMemory(), (String)"Leaking memory");
    }

    @Test
    void addAndIterateElements() {
        long iterations = this.rnd.nextLong(10L, 1000L);
        int i = 0;
        while ((long)i < iterations) {
            this.list.add((long)i);
            ++i;
        }
        long actualSize = this.meter.measureDeep((Object)this.list) - this.meter.measureDeep((Object)this.memoryTracker);
        Assertions.assertEquals((long)actualSize, (long)this.memoryTracker.estimatedHeapMemory());
        PrimitiveLongResourceIterator iterator = this.list.iterator();
        int i2 = 0;
        while ((long)i2 < iterations) {
            Assertions.assertTrue((boolean)iterator.hasNext());
            Assertions.assertEquals((long)i2, (long)iterator.next());
            ++i2;
        }
        Assertions.assertFalse((boolean)iterator.hasNext());
    }
}

