/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.util.function.IntPredicate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.common.EntityType;
import org.neo4j.common.Subject;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.PopulationProgress;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.internal.schema.SchemaState;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.MinimalIndexAccessor;
import org.neo4j.kernel.api.schema.index.TestIndexDescriptorFactory;
import org.neo4j.kernel.impl.api.index.FailedIndexProxy;
import org.neo4j.kernel.impl.api.index.FlippableIndexProxy;
import org.neo4j.kernel.impl.api.index.IndexPopulationFailure;
import org.neo4j.kernel.impl.api.index.IndexProxyStrategy;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.MultipleIndexPopulator;
import org.neo4j.kernel.impl.api.index.OnlineIndexProxy;
import org.neo4j.kernel.impl.api.index.PropertyScanConsumer;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.api.index.TokenScanConsumer;
import org.neo4j.kernel.impl.api.index.ValueIndexProxyStrategy;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.kernel.impl.scheduler.JobSchedulerFactory;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.test.InMemoryTokens;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

class IndexPopulationTest {
    private final IndexStatisticsStore indexStatisticsStore = (IndexStatisticsStore)Mockito.mock(IndexStatisticsStore.class);
    private final InMemoryTokens tokens = new InMemoryTokens();

    IndexPopulationTest() {
    }

    @Test
    void mustFlipToFailedIfFailureToApplyLastBatchWhileFlipping() throws Exception {
        NullLogProvider logProvider = NullLogProvider.getInstance();
        IndexStoreView.Adaptor storeView = IndexPopulationTest.emptyIndexStoreViewThatProcessUpdates();
        IndexPopulator.Adapter populator = IndexPopulationTest.emptyPopulatorWithThrowingUpdater();
        FailedIndexProxy failedProxy = this.failedIndexProxy((MinimalIndexAccessor)populator);
        OnlineIndexProxy onlineProxy = this.onlineIndexProxy();
        FlippableIndexProxy flipper = new FlippableIndexProxy();
        flipper.setFlipTarget(() -> onlineProxy);
        MultipleIndexPopulator multipleIndexPopulator = new MultipleIndexPopulator((IndexStoreView)storeView, (LogProvider)logProvider, EntityType.NODE, (SchemaState)Mockito.mock(SchemaState.class), JobSchedulerFactory.createInitialisedScheduler(), (TokenNameLookup)this.tokens, PageCacheTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE, "", Subject.AUTH_DISABLED, Config.defaults());
        MultipleIndexPopulator.IndexPopulation indexPopulation = multipleIndexPopulator.addPopulator((IndexPopulator)populator, this.dummyIndex(), flipper, t -> failedProxy);
        multipleIndexPopulator.queueConcurrentUpdate(IndexPopulationTest.someUpdate());
        multipleIndexPopulator.createStoreScan(PageCacheTracer.NULL).run(StoreScan.NO_EXTERNAL_UPDATES);
        indexPopulation.flip(false, CursorContext.NULL);
        Assertions.assertSame((Object)InternalIndexState.FAILED, (Object)flipper.getState(), (String)"flipper should have flipped to failing proxy");
    }

    private OnlineIndexProxy onlineIndexProxy() {
        return new OnlineIndexProxy(this.dummyIndex(), IndexAccessor.EMPTY, false);
    }

    private FailedIndexProxy failedIndexProxy(MinimalIndexAccessor minimalIndexAccessor) {
        return new FailedIndexProxy(this.dummyIndex(), minimalIndexAccessor, IndexPopulationFailure.failure((String)"failure"), (LogProvider)NullLogProvider.getInstance());
    }

    private static IndexPopulator.Adapter emptyPopulatorWithThrowingUpdater() {
        return new IndexPopulator.Adapter(){

            public IndexUpdater newPopulatingUpdater(NodePropertyAccessor accessor, CursorContext cursorContext) {
                return new IndexUpdater(){

                    public void process(IndexEntryUpdate<?> update) throws IndexEntryConflictException {
                        throw new IndexEntryConflictException(0L, 1L, new Value[]{Values.numberValue((Number)0)});
                    }

                    public void close() {
                    }
                };
            }
        };
    }

    private static IndexStoreView.Adaptor emptyIndexStoreViewThatProcessUpdates() {
        return new IndexStoreView.Adaptor(){

            public StoreScan visitNodes(int[] labelIds, IntPredicate propertyKeyIdFilter, PropertyScanConsumer propertyScanConsumer, TokenScanConsumer labelScanConsumer, boolean forceStoreScan, boolean parallelWrite, PageCacheTracer cacheTracer, MemoryTracker memoryTracker) {
                return new StoreScan(){

                    public void run(StoreScan.ExternalUpdatesCheck externalUpdatesCheck) {
                    }

                    public void stop() {
                    }

                    public PopulationProgress getProgress() {
                        return null;
                    }
                };
            }
        };
    }

    private IndexProxyStrategy dummyIndex() {
        return new ValueIndexProxyStrategy(TestIndexDescriptorFactory.forLabel(0, 0), this.indexStatisticsStore, (TokenNameLookup)this.tokens);
    }

    private static IndexEntryUpdate<LabelSchemaDescriptor> someUpdate() {
        return IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)SchemaDescriptor.forLabel((int)0, (int[])new int[]{0}), (Value[])new Value[]{Values.numberValue((Number)0)});
    }
}

