/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.collections.api.iterator.LongIterator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.collection.PrimitiveLongResourceCollections;
import org.neo4j.collection.PrimitiveLongResourceIterator;
import org.neo4j.kernel.impl.index.schema.CompositeTokenScanValueIterator;

@Execution(value=ExecutionMode.CONCURRENT)
class CompositeTokenScanValueIteratorTest {
    CompositeTokenScanValueIteratorTest() {
    }

    @Test
    void mustHandleEmptyListOfIterators() {
        List iterators = Collections.emptyList();
        CompositeTokenScanValueIterator iterator = new CompositeTokenScanValueIterator(iterators, false);
        Assertions.assertFalse((boolean)iterator.hasNext());
        Assertions.assertThrows(NoSuchElementException.class, () -> ((CompositeTokenScanValueIterator)iterator).next());
    }

    @Test
    void mustHandleEmptyIterator() {
        List<PrimitiveLongResourceIterator> iterators = Collections.singletonList(PrimitiveLongResourceCollections.emptyIterator());
        CompositeTokenScanValueIterator iterator = new CompositeTokenScanValueIterator(iterators, false);
        Assertions.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    void mustHandleMultipleEmptyIterators() {
        List<PrimitiveLongResourceIterator> iterators = CompositeTokenScanValueIteratorTest.asMutableList(PrimitiveLongResourceCollections.emptyIterator(), PrimitiveLongResourceCollections.emptyIterator(), PrimitiveLongResourceCollections.emptyIterator());
        CompositeTokenScanValueIterator iterator = new CompositeTokenScanValueIterator(iterators, false);
        Assertions.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    void mustReportAllFromSingleIterator() {
        long[] expected = new long[]{0L, 1L, Long.MAX_VALUE};
        List<PrimitiveLongResourceIterator> iterators = Collections.singletonList(PrimitiveLongResourceCollections.iterator(null, (long[])expected));
        CompositeTokenScanValueIterator iterator = new CompositeTokenScanValueIterator(iterators, false);
        Assertions.assertArrayEquals((long[])expected, (long[])PrimitiveLongCollections.asArray((LongIterator)iterator));
    }

    @Test
    void mustReportAllFromNonOverlappingMultipleIterators() {
        AtomicInteger closeCounter = new AtomicInteger();
        long[] firstIter = new long[]{0L, 2L, Long.MAX_VALUE};
        long[] secondIter = new long[]{1L, 3L};
        long[] expected = new long[]{0L, 1L, 2L, 3L, Long.MAX_VALUE};
        PrimitiveLongResourceIterator[] primitiveLongResourceIteratorArray = new PrimitiveLongResourceIterator[2];
        primitiveLongResourceIteratorArray[0] = PrimitiveLongResourceCollections.iterator(closeCounter::incrementAndGet, (long[])firstIter);
        primitiveLongResourceIteratorArray[1] = PrimitiveLongResourceCollections.iterator(closeCounter::incrementAndGet, (long[])secondIter);
        List<PrimitiveLongResourceIterator> iterators = CompositeTokenScanValueIteratorTest.asMutableList(primitiveLongResourceIteratorArray);
        CompositeTokenScanValueIterator iterator = new CompositeTokenScanValueIterator(iterators, false);
        Assertions.assertArrayEquals((long[])expected, (long[])PrimitiveLongCollections.asArray((LongIterator)iterator));
        iterator.close();
        Assertions.assertEquals((int)2, (int)closeCounter.get(), (String)"expected close count");
    }

    @Test
    void mustReportUniqueValuesFromOverlappingIterators() {
        AtomicInteger closeCounter = new AtomicInteger();
        long[] firstIter = new long[]{0L, 2L, Long.MAX_VALUE};
        long[] secondIter = new long[]{1L, 3L};
        long[] thirdIter = new long[]{0L, 3L};
        long[] expected = new long[]{0L, 1L, 2L, 3L, Long.MAX_VALUE};
        PrimitiveLongResourceIterator[] primitiveLongResourceIteratorArray = new PrimitiveLongResourceIterator[3];
        primitiveLongResourceIteratorArray[0] = PrimitiveLongResourceCollections.iterator(closeCounter::incrementAndGet, (long[])firstIter);
        primitiveLongResourceIteratorArray[1] = PrimitiveLongResourceCollections.iterator(closeCounter::incrementAndGet, (long[])secondIter);
        primitiveLongResourceIteratorArray[2] = PrimitiveLongResourceCollections.iterator(closeCounter::incrementAndGet, (long[])thirdIter);
        List<PrimitiveLongResourceIterator> iterators = CompositeTokenScanValueIteratorTest.asMutableList(primitiveLongResourceIteratorArray);
        CompositeTokenScanValueIterator iterator = new CompositeTokenScanValueIterator(iterators, false);
        Assertions.assertArrayEquals((long[])expected, (long[])PrimitiveLongCollections.asArray((LongIterator)iterator));
        iterator.close();
        Assertions.assertEquals((int)3, (int)closeCounter.get(), (String)"expected close count");
    }

    @Test
    void mustReportUniqueValuesFromOverlappingIteratorsWithOneEmpty() {
        AtomicInteger closeCounter = new AtomicInteger();
        long[] firstIter = new long[]{0L, 2L, Long.MAX_VALUE};
        long[] secondIter = new long[]{1L, 3L};
        long[] thirdIter = new long[]{0L, 3L};
        long[] fourthIter = new long[]{};
        long[] expected = new long[]{0L, 1L, 2L, 3L, Long.MAX_VALUE};
        PrimitiveLongResourceIterator[] primitiveLongResourceIteratorArray = new PrimitiveLongResourceIterator[4];
        primitiveLongResourceIteratorArray[0] = PrimitiveLongResourceCollections.iterator(closeCounter::incrementAndGet, (long[])firstIter);
        primitiveLongResourceIteratorArray[1] = PrimitiveLongResourceCollections.iterator(closeCounter::incrementAndGet, (long[])secondIter);
        primitiveLongResourceIteratorArray[2] = PrimitiveLongResourceCollections.iterator(closeCounter::incrementAndGet, (long[])thirdIter);
        primitiveLongResourceIteratorArray[3] = PrimitiveLongResourceCollections.iterator(closeCounter::incrementAndGet, (long[])fourthIter);
        List<PrimitiveLongResourceIterator> iterators = CompositeTokenScanValueIteratorTest.asMutableList(primitiveLongResourceIteratorArray);
        CompositeTokenScanValueIterator iterator = new CompositeTokenScanValueIterator(iterators, false);
        Assertions.assertArrayEquals((long[])expected, (long[])PrimitiveLongCollections.asArray((LongIterator)iterator));
        iterator.close();
        Assertions.assertEquals((int)4, (int)closeCounter.get(), (String)"expected close count");
    }

    @Test
    void mustOnlyReportValuesReportedByAll() {
        AtomicInteger closeCounter = new AtomicInteger();
        long[] firstIter = new long[]{0L, Long.MAX_VALUE};
        long[] secondIter = new long[]{0L, 1L, Long.MAX_VALUE};
        long[] thirdIter = new long[]{0L, 1L, 2L, Long.MAX_VALUE};
        long[] expected = new long[]{0L, Long.MAX_VALUE};
        PrimitiveLongResourceIterator[] primitiveLongResourceIteratorArray = new PrimitiveLongResourceIterator[3];
        primitiveLongResourceIteratorArray[0] = PrimitiveLongResourceCollections.iterator(closeCounter::incrementAndGet, (long[])firstIter);
        primitiveLongResourceIteratorArray[1] = PrimitiveLongResourceCollections.iterator(closeCounter::incrementAndGet, (long[])secondIter);
        primitiveLongResourceIteratorArray[2] = PrimitiveLongResourceCollections.iterator(closeCounter::incrementAndGet, (long[])thirdIter);
        List<PrimitiveLongResourceIterator> iterators = CompositeTokenScanValueIteratorTest.asMutableList(primitiveLongResourceIteratorArray);
        CompositeTokenScanValueIterator iterator = new CompositeTokenScanValueIterator(iterators, true);
        Assertions.assertArrayEquals((long[])expected, (long[])PrimitiveLongCollections.asArray((LongIterator)iterator));
        iterator.close();
        Assertions.assertEquals((int)3, (int)closeCounter.get(), (String)"expected close count");
    }

    @Test
    void mustOnlyReportValuesReportedByAllWithOneEmpty() {
        AtomicInteger closeCounter = new AtomicInteger();
        long[] firstIter = new long[]{0L, Long.MAX_VALUE};
        long[] secondIter = new long[]{0L, 1L, Long.MAX_VALUE};
        long[] thirdIter = new long[]{0L, 1L, 2L, Long.MAX_VALUE};
        long[] fourthIter = new long[]{};
        long[] expected = new long[]{};
        PrimitiveLongResourceIterator[] primitiveLongResourceIteratorArray = new PrimitiveLongResourceIterator[4];
        primitiveLongResourceIteratorArray[0] = PrimitiveLongResourceCollections.iterator(closeCounter::incrementAndGet, (long[])firstIter);
        primitiveLongResourceIteratorArray[1] = PrimitiveLongResourceCollections.iterator(closeCounter::incrementAndGet, (long[])secondIter);
        primitiveLongResourceIteratorArray[2] = PrimitiveLongResourceCollections.iterator(closeCounter::incrementAndGet, (long[])thirdIter);
        primitiveLongResourceIteratorArray[3] = PrimitiveLongResourceCollections.iterator(closeCounter::incrementAndGet, (long[])fourthIter);
        List<PrimitiveLongResourceIterator> iterators = CompositeTokenScanValueIteratorTest.asMutableList(primitiveLongResourceIteratorArray);
        CompositeTokenScanValueIterator iterator = new CompositeTokenScanValueIterator(iterators, true);
        Assertions.assertArrayEquals((long[])expected, (long[])PrimitiveLongCollections.asArray((LongIterator)iterator));
        iterator.close();
        Assertions.assertEquals((int)4, (int)closeCounter.get(), (String)"expected close count");
    }

    @SafeVarargs
    private static <T> List<T> asMutableList(T ... objects) {
        return new ArrayList<T>(Arrays.asList(objects));
    }
}

