/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.ArrayList;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.ValueIndexReader;
import org.neo4j.kernel.api.schema.index.TestIndexDescriptorFactory;
import org.neo4j.kernel.impl.index.schema.DeferredConflictCheckingIndexUpdater;
import org.neo4j.kernel.impl.index.schema.NodeIdsIndexReaderQueryAnswer;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.UpdateMode;
import org.neo4j.storageengine.api.ValueIndexEntryUpdate;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

class DeferredConflictCheckingIndexUpdaterTest {
    private static final int labelId = 1;
    private final int[] propertyKeyIds = new int[]{2, 3};
    private final IndexDescriptor descriptor = TestIndexDescriptorFactory.forLabel(1, this.propertyKeyIds);

    DeferredConflictCheckingIndexUpdaterTest() {
    }

    @Test
    void shouldQueryAboutAddedAndChangedValueTuples() throws Exception {
        IndexUpdater actual = (IndexUpdater)Mockito.mock(IndexUpdater.class);
        ValueIndexReader reader = (ValueIndexReader)Mockito.mock(ValueIndexReader.class);
        ((ValueIndexReader)Mockito.doAnswer((Answer)new NodeIdsIndexReaderQueryAnswer(this.descriptor, new long[]{0L})).when((Object)reader)).query((QueryContext)ArgumentMatchers.any(), (IndexProgressor.EntityValueClient)ArgumentMatchers.any(), (IndexQueryConstraints)ArgumentMatchers.any(), new PropertyIndexQuery[]{(PropertyIndexQuery)ArgumentMatchers.any(), (PropertyIndexQuery)ArgumentMatchers.any()});
        long nodeId = 0L;
        ArrayList<ValueIndexEntryUpdate> updates = new ArrayList<ValueIndexEntryUpdate>();
        updates.add(IndexEntryUpdate.add((long)nodeId++, (SchemaDescriptorSupplier)this.descriptor, (Value[])DeferredConflictCheckingIndexUpdaterTest.tuple(10, 11)));
        updates.add(IndexEntryUpdate.change((long)nodeId++, (SchemaDescriptorSupplier)this.descriptor, (Value[])DeferredConflictCheckingIndexUpdaterTest.tuple("abc", "def"), (Value[])DeferredConflictCheckingIndexUpdaterTest.tuple("ghi", "klm")));
        updates.add(IndexEntryUpdate.remove((long)nodeId++, (SchemaDescriptorSupplier)this.descriptor, (Value[])DeferredConflictCheckingIndexUpdaterTest.tuple(1001L, 1002L)));
        updates.add(IndexEntryUpdate.change((long)nodeId++, (SchemaDescriptorSupplier)this.descriptor, (Value[])DeferredConflictCheckingIndexUpdaterTest.tuple((byte)2, (byte)3), (Value[])DeferredConflictCheckingIndexUpdaterTest.tuple((byte)4, (byte)5)));
        updates.add(IndexEntryUpdate.add((long)nodeId, (SchemaDescriptorSupplier)this.descriptor, (Value[])DeferredConflictCheckingIndexUpdaterTest.tuple(5, "5")));
        try (DeferredConflictCheckingIndexUpdater updater = new DeferredConflictCheckingIndexUpdater(actual, () -> reader, this.descriptor, CursorContext.NULL);){
            for (ValueIndexEntryUpdate update : updates) {
                updater.process((IndexEntryUpdate)update);
                ((IndexUpdater)Mockito.verify((Object)actual)).process((IndexEntryUpdate)update);
            }
        }
        for (ValueIndexEntryUpdate update : updates) {
            if (update.updateMode() != UpdateMode.ADDED && update.updateMode() != UpdateMode.CHANGED) continue;
            Value[] tuple = update.values();
            PropertyIndexQuery[] query = new PropertyIndexQuery[tuple.length];
            for (int i = 0; i < tuple.length; ++i) {
                query[i] = PropertyIndexQuery.exact((int)this.propertyKeyIds[i], (Object)tuple[i]);
            }
            ((ValueIndexReader)Mockito.verify((Object)reader)).query((QueryContext)ArgumentMatchers.any(), (IndexProgressor.EntityValueClient)ArgumentMatchers.any(), (IndexQueryConstraints)ArgumentMatchers.any(), new PropertyIndexQuery[]{(PropertyIndexQuery)ArgumentMatchers.eq((Object)query[0]), (PropertyIndexQuery)ArgumentMatchers.eq((Object)query[1])});
        }
        ((ValueIndexReader)Mockito.verify((Object)reader)).close();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{reader});
    }

    @Test
    void shouldThrowOnIndexEntryConflict() throws Exception {
        IndexUpdater actual = (IndexUpdater)Mockito.mock(IndexUpdater.class);
        ValueIndexReader reader = (ValueIndexReader)Mockito.mock(ValueIndexReader.class);
        ((ValueIndexReader)Mockito.doAnswer((Answer)new NodeIdsIndexReaderQueryAnswer(this.descriptor, new long[]{101L, 202L})).when((Object)reader)).query((QueryContext)ArgumentMatchers.any(), (IndexProgressor.EntityValueClient)ArgumentMatchers.any(), (IndexQueryConstraints)ArgumentMatchers.any(), (PropertyIndexQuery[])ArgumentMatchers.any());
        DeferredConflictCheckingIndexUpdater updater = new DeferredConflictCheckingIndexUpdater(actual, () -> reader, this.descriptor, CursorContext.NULL);
        updater.process((IndexEntryUpdate)IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)this.descriptor, (Value[])DeferredConflictCheckingIndexUpdaterTest.tuple(10, 11)));
        IndexEntryConflictException e = (IndexEntryConflictException)org.junit.jupiter.api.Assertions.assertThrows(IndexEntryConflictException.class, () -> ((DeferredConflictCheckingIndexUpdater)updater).close());
        Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"101"});
        Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"202"});
    }

    private static Value[] tuple(Object ... values) {
        Value[] result = new Value[values.length];
        for (int i = 0; i < values.length; ++i) {
            result[i] = Values.of((Object)values[i]);
        }
        return result;
    }
}

