/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.function.Supplier;
import org.apache.commons.lang3.tuple.Pair;
import org.junit.jupiter.api.Assertions;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.Seeker;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.ValueCreatorUtil;
import org.neo4j.storageengine.api.ValueIndexEntryUpdate;
import org.neo4j.values.storable.ValueGroup;

public class NativeValueIndexUtility<KEY extends NativeIndexKey<KEY>, VALUE extends NativeIndexValue> {
    private final ValueCreatorUtil<KEY, VALUE> valueCreatorUtil;
    private final Layout<KEY, VALUE> layout;

    public NativeValueIndexUtility(ValueCreatorUtil<KEY, VALUE> valueCreatorUtil, Layout<KEY, VALUE> layout) {
        this.valueCreatorUtil = valueCreatorUtil;
        this.layout = layout;
    }

    private void copyValue(VALUE value, VALUE intoValue) {
        this.valueCreatorUtil.copyValue(value, intoValue);
    }

    void verifyUpdates(ValueIndexEntryUpdate<IndexDescriptor>[] updates, Supplier<GBPTree<KEY, VALUE>> treeProvider) throws IOException {
        Pair<KEY, VALUE>[] expectedHits = this.convertToHits(updates, this.layout);
        ArrayList<Pair<KEY, VALUE>> actualHits = new ArrayList<Pair<KEY, VALUE>>();
        try (GBPTree<KEY, VALUE> tree = treeProvider.get();
             Seeker<KEY, VALUE> scan = this.scan(tree);){
            while (scan.next()) {
                actualHits.add(this.deepCopy(scan));
            }
        }
        Comparator hitComparator = (h1, h2) -> {
            int keyCompare = this.layout.compare((Object)((NativeIndexKey)h1.getKey()), (Object)((NativeIndexKey)h2.getKey()));
            if (keyCompare == 0) {
                return this.valueCreatorUtil.compareIndexedPropertyValue((NativeIndexKey)h1.getKey(), (NativeIndexKey)h2.getKey());
            }
            return keyCompare;
        };
        this.assertSameHits(expectedHits, actualHits.toArray(new Pair[0]), hitComparator);
    }

    private Seeker<KEY, VALUE> scan(GBPTree<KEY, VALUE> tree) throws IOException {
        NativeIndexKey lowest = (NativeIndexKey)this.layout.newKey();
        lowest.initialize(Long.MIN_VALUE);
        lowest.initValueAsLowest(0, ValueGroup.UNKNOWN);
        NativeIndexKey highest = (NativeIndexKey)this.layout.newKey();
        highest.initialize(Long.MAX_VALUE);
        highest.initValueAsHighest(0, ValueGroup.UNKNOWN);
        return tree.seek((Object)lowest, (Object)highest, CursorContext.NULL);
    }

    private void assertSameHits(Pair<KEY, VALUE>[] expectedHits, Pair<KEY, VALUE>[] actualHits, Comparator<Pair<KEY, VALUE>> comparator) {
        Arrays.sort(expectedHits, comparator);
        Arrays.sort(actualHits, comparator);
        Assertions.assertEquals((int)expectedHits.length, (int)actualHits.length, (String)String.format("Array length differ%nExpected:%d, Actual:%d", expectedHits.length, actualHits.length));
        for (int i = 0; i < expectedHits.length; ++i) {
            Pair<KEY, VALUE> expected = expectedHits[i];
            Pair<KEY, VALUE> actual = actualHits[i];
            Assertions.assertEquals((int)0, (int)comparator.compare(expected, actual), (String)("Hits differ on item number " + i + ". Expected " + expected + " but was " + actual));
        }
    }

    private Pair<KEY, VALUE> deepCopy(Seeker<KEY, VALUE> from) {
        NativeIndexKey intoKey = (NativeIndexKey)this.layout.newKey();
        NativeIndexValue intoValue = (NativeIndexValue)this.layout.newValue();
        this.layout.copyKey((Object)((NativeIndexKey)from.key()), (Object)intoKey);
        this.copyValue((NativeIndexValue)from.value(), intoValue);
        return Pair.of((Object)intoKey, (Object)intoValue);
    }

    private Pair<KEY, VALUE>[] convertToHits(ValueIndexEntryUpdate<IndexDescriptor>[] updates, Layout<KEY, VALUE> layout) {
        ArrayList<Pair> hits = new ArrayList<Pair>(updates.length);
        for (ValueIndexEntryUpdate<IndexDescriptor> u : updates) {
            NativeIndexKey key = (NativeIndexKey)layout.newKey();
            key.initialize(u.getEntityId());
            for (int i = 0; i < u.values().length; ++i) {
                key.initFromValue(i, u.values()[i], NativeIndexKey.Inclusion.NEUTRAL);
            }
            NativeIndexValue value = (NativeIndexValue)layout.newValue();
            value.from(u.values());
            hits.add(Pair.of((Object)key, (Object)value));
        }
        return hits.toArray(new Pair[0]);
    }
}

