/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.internal.helpers.collection.PrefetchingIterator;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.storageengine.api.ValueIndexEntryUpdate;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.values.storable.RandomValues;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueType;
import org.neo4j.values.storable.Values;

class ValueCreatorUtil<KEY extends NativeIndexKey<KEY>, VALUE extends NativeIndexValue> {
    static final double FRACTION_DUPLICATE_UNIQUE = 0.0;
    static final double FRACTION_DUPLICATE_NON_UNIQUE = 0.1;
    private static final double FRACTION_EXTREME_VALUE = 0.25;
    private static final Comparator<ValueIndexEntryUpdate<IndexDescriptor>> UPDATE_COMPARATOR = (u1, u2) -> Values.COMPARATOR.compare(u1.values()[0], u2.values()[0]);
    private static final int N_VALUES = 10;
    final IndexDescriptor indexDescriptor;
    private final ValueType[] supportedTypes;
    private final double fractionDuplicates;

    ValueCreatorUtil(IndexDescriptor indexDescriptor, ValueType[] supportedTypes, double fractionDuplicates) {
        this.indexDescriptor = indexDescriptor;
        this.supportedTypes = supportedTypes;
        this.fractionDuplicates = fractionDuplicates;
    }

    int compareIndexedPropertyValue(KEY key1, KEY key2) {
        return Values.COMPARATOR.compare(key1.asValues()[0], key2.asValues()[0]);
    }

    ValueType[] supportedTypes() {
        return this.supportedTypes;
    }

    private double fractionDuplicates() {
        return this.fractionDuplicates;
    }

    static PropertyIndexQuery rangeQuery(Value from, boolean fromInclusive, Value to, boolean toInclusive) {
        return PropertyIndexQuery.range((int)0, (Value)from, (boolean)fromInclusive, (Value)to, (boolean)toInclusive);
    }

    ValueIndexEntryUpdate<IndexDescriptor>[] someUpdates(RandomRule randomRule) {
        return this.someUpdates(randomRule, this.supportedTypes(), this.fractionDuplicates());
    }

    ValueIndexEntryUpdate<IndexDescriptor>[] someUpdates(RandomRule random, ValueType[] types, boolean allowDuplicates) {
        double fractionDuplicates = allowDuplicates ? 0.1 : 0.0;
        return this.someUpdates(random, types, fractionDuplicates);
    }

    private ValueIndexEntryUpdate<IndexDescriptor>[] someUpdates(RandomRule random, ValueType[] types, double fractionDuplicates) {
        RandomValueGenerator valueGenerator = new RandomValueGenerator(random.randomValues(), types, fractionDuplicates);
        RandomUpdateGenerator randomUpdateGenerator = new RandomUpdateGenerator((Iterator<Value>)((Object)valueGenerator));
        ValueIndexEntryUpdate[] result = new ValueIndexEntryUpdate[10];
        for (int i = 0; i < 10; ++i) {
            result[i] = (ValueIndexEntryUpdate)randomUpdateGenerator.next();
        }
        return result;
    }

    ValueIndexEntryUpdate<IndexDescriptor>[] someUpdatesWithDuplicateValues(RandomRule randomRule) {
        RandomValueGenerator valueIterator = new RandomValueGenerator(randomRule.randomValues(), this.supportedTypes(), this.fractionDuplicates());
        Object[] someValues = new Value[10];
        for (int i = 0; i < 10; ++i) {
            someValues[i] = (Value)valueIterator.next();
        }
        return this.generateAddUpdatesFor((Value[])ArrayUtils.addAll((Object[])someValues, (Object[])someValues));
    }

    Iterator<ValueIndexEntryUpdate<IndexDescriptor>> randomUpdateGenerator(RandomRule randomRule) {
        return this.randomUpdateGenerator(randomRule, this.supportedTypes());
    }

    Iterator<ValueIndexEntryUpdate<IndexDescriptor>> randomUpdateGenerator(RandomRule random, ValueType[] types) {
        RandomValueGenerator valueIterator = new RandomValueGenerator(random.randomValues(), types, this.fractionDuplicates());
        return new RandomUpdateGenerator((Iterator<Value>)((Object)valueIterator));
    }

    ValueIndexEntryUpdate<IndexDescriptor>[] generateAddUpdatesFor(Value[] values) {
        ValueIndexEntryUpdate[] indexEntryUpdates = new ValueIndexEntryUpdate[values.length];
        for (int i = 0; i < indexEntryUpdates.length; ++i) {
            indexEntryUpdates[i] = this.add(i, values[i]);
        }
        return indexEntryUpdates;
    }

    static Value[] extractValuesFromUpdates(ValueIndexEntryUpdate<IndexDescriptor>[] updates) {
        Value[] values = new Value[updates.length];
        for (int i = 0; i < updates.length; ++i) {
            if (updates[i].values().length > 1) {
                throw new UnsupportedOperationException("This method does not support composite entries");
            }
            values[i] = updates[i].values()[0];
        }
        return values;
    }

    protected ValueIndexEntryUpdate<IndexDescriptor> add(long nodeId, Value value) {
        return ValueIndexEntryUpdate.add((long)nodeId, (SchemaDescriptorSupplier)this.indexDescriptor, (Value[])new Value[]{value});
    }

    static int countUniqueValues(ValueIndexEntryUpdate<IndexDescriptor>[] updates) {
        return Stream.of(updates).map(update -> update.values()[0]).collect(Collectors.toSet()).size();
    }

    static int countUniqueValues(Value[] updates) {
        TreeSet<Value> set = new TreeSet<Value>((Comparator<Value>)Values.COMPARATOR);
        set.addAll(Arrays.asList(updates));
        return set.size();
    }

    static void sort(ValueIndexEntryUpdate<IndexDescriptor>[] updates) {
        Arrays.sort(updates, UPDATE_COMPARATOR);
    }

    void copyValue(VALUE value, VALUE intoValue) {
    }

    private class RandomUpdateGenerator
    extends PrefetchingIterator<ValueIndexEntryUpdate<IndexDescriptor>> {
        private final Iterator<Value> valueIterator;
        private long currentEntityId;

        RandomUpdateGenerator(Iterator<Value> valueIterator) {
            this.valueIterator = valueIterator;
        }

        protected ValueIndexEntryUpdate<IndexDescriptor> fetchNextOrNull() {
            Value value = this.valueIterator.next();
            return ValueCreatorUtil.this.add(this.currentEntityId++, value);
        }
    }

    private static class RandomValueGenerator
    extends PrefetchingIterator<Value> {
        private final Set<Value> uniqueCompareValues;
        private final List<Value> uniqueValues;
        private final ValueType[] types;
        private final double fractionDuplicates;
        private final RandomValues randomValues;

        RandomValueGenerator(RandomValues randomValues, ValueType[] types, double fractionDuplicates) {
            this.types = types;
            this.fractionDuplicates = fractionDuplicates;
            this.randomValues = randomValues;
            this.uniqueCompareValues = new HashSet<Value>();
            this.uniqueValues = new ArrayList<Value>();
        }

        protected Value fetchNextOrNull() {
            Value value = this.fractionDuplicates > 0.0 && !this.uniqueValues.isEmpty() && (double)this.randomValues.nextFloat() < this.fractionDuplicates ? (Value)this.randomValues.among(this.uniqueValues) : this.newUniqueValue(this.randomValues, this.uniqueCompareValues, this.uniqueValues);
            return value;
        }

        private Value newUniqueValue(RandomValues random, Set<Value> uniqueCompareValues, List<Value> uniqueValues) {
            Value value;
            int attempts = 0;
            int maxAttempts = 10;
            do {
                ValueType type = (ValueType)this.randomValues.among((Object[])this.types);
                boolean useExtremeValue = ++attempts == 1 && this.randomValues.nextDouble() < 0.25;
                value = useExtremeValue ? (Value)this.randomValues.among((Object[])type.extremeValues()) : random.nextValueOfType(type);
            } while (attempts < maxAttempts && !uniqueCompareValues.add(value));
            uniqueValues.add(value);
            return value;
        }
    }
}

