/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.kernel.impl.api.LeaseClient;
import org.neo4j.kernel.impl.api.LeaseService;
import org.neo4j.kernel.impl.locking.LockAcquisitionTimeoutException;
import org.neo4j.kernel.impl.locking.LockCompatibilityTestSupport;
import org.neo4j.kernel.impl.locking.LockingCompatibilityTestSuite;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.lock.LockTracer;
import org.neo4j.lock.ResourceType;
import org.neo4j.lock.ResourceTypes;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.time.Clocks;
import org.neo4j.time.FakeClock;
import org.neo4j.time.SystemNanoClock;

abstract class AcquisitionTimeoutCompatibility
extends LockCompatibilityTestSupport {
    private FakeClock clock;
    private Locks lockManager;
    private Locks.Client client;
    private Locks.Client client2;

    AcquisitionTimeoutCompatibility(LockingCompatibilityTestSuite suite) {
        super(suite);
    }

    @BeforeEach
    void setUp() {
        Config customConfig = Config.defaults((Setting)GraphDatabaseSettings.lock_acquisition_timeout, (Object)Duration.ofMillis(100L));
        this.clock = Clocks.fakeClock((long)100000L, (TimeUnit)TimeUnit.MINUTES);
        this.lockManager = this.suite.createLockManager(customConfig, (SystemNanoClock)this.clock);
        this.client = this.lockManager.newClient();
        this.client2 = this.lockManager.newClient();
        this.client.initialize((LeaseClient)LeaseService.NoLeaseClient.INSTANCE, 1L, (MemoryTracker)EmptyMemoryTracker.INSTANCE, customConfig);
        this.client2.initialize((LeaseClient)LeaseService.NoLeaseClient.INSTANCE, 2L, (MemoryTracker)EmptyMemoryTracker.INSTANCE, customConfig);
    }

    @AfterEach
    void tearDown() {
        this.client2.close();
        this.client.close();
        this.lockManager.close();
    }

    @Test
    void terminateSharedLockAcquisition() throws InterruptedException {
        this.client.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        Future sharedLockAcquisition = this.threadB.submit(() -> {
            this.client2.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
            return true;
        });
        this.threadB.untilWaiting();
        this.clock.forward(101L, TimeUnit.MILLISECONDS);
        AcquisitionTimeoutCompatibility.verifyAcquisitionFailure(sharedLockAcquisition);
    }

    @Test
    void terminateExclusiveLockAcquisitionForExclusivelyLockedResource() throws InterruptedException {
        this.client.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        Future exclusiveLockAcquisition = this.threadB.submit(() -> {
            this.client2.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
            return true;
        });
        this.threadB.untilWaiting();
        this.clock.forward(101L, TimeUnit.MILLISECONDS);
        AcquisitionTimeoutCompatibility.verifyAcquisitionFailure(exclusiveLockAcquisition);
    }

    @Test
    void terminateExclusiveLockAcquisitionForSharedLockedResource() throws InterruptedException {
        this.client.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        Future exclusiveLockAcquisition = this.threadB.submit(() -> {
            this.client2.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
            return true;
        });
        this.threadB.untilWaiting();
        this.clock.forward(101L, TimeUnit.MILLISECONDS);
        AcquisitionTimeoutCompatibility.verifyAcquisitionFailure(exclusiveLockAcquisition);
    }

    @Test
    void terminateExclusiveLockAcquisitionForSharedLockedResourceWithSharedLockHeld() throws InterruptedException {
        this.client.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.client2.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        Future exclusiveLockAcquisition = this.threadB.submit(() -> {
            this.client2.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
            return true;
        });
        this.threadB.untilWaiting();
        this.clock.forward(101L, TimeUnit.MILLISECONDS);
        AcquisitionTimeoutCompatibility.verifyAcquisitionFailure(exclusiveLockAcquisition);
    }

    private static void verifyAcquisitionFailure(Future<Boolean> lockAcquisition) {
        ExecutionException exception = (ExecutionException)org.junit.jupiter.api.Assertions.assertThrows(ExecutionException.class, lockAcquisition::get);
        Assertions.assertThat((Throwable)ExceptionUtils.getRootCause((Throwable)exception)).isInstanceOf(LockAcquisitionTimeoutException.class);
    }
}

