/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.time.Clock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Phaser;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.LockSupport;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.collection.Dependencies;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.helpers.DatabaseReadOnlyChecker;
import org.neo4j.dbms.database.DbmsRuntimeRepository;
import org.neo4j.graphdb.DatabaseShutdownException;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.security.AuthorizationExpiredException;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.id.IdController;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.security.AbstractSecurityLog;
import org.neo4j.internal.kernel.api.security.CommunitySecurityLog;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.schema.SchemaState;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.EmptyVersionContextSupplier;
import org.neo4j.io.pagecache.context.VersionContextSupplier;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.KernelTransactionHandle;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.api.security.AnonymousContext;
import org.neo4j.kernel.availability.AvailabilityGuard;
import org.neo4j.kernel.availability.CompositeDatabaseAvailabilityGuard;
import org.neo4j.kernel.availability.DatabaseAvailabilityGuard;
import org.neo4j.kernel.database.DatabaseTracers;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.database.TestDatabaseIdRepository;
import org.neo4j.kernel.impl.api.ExternalIdReuseConditionProvider;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.KernelTransactions;
import org.neo4j.kernel.impl.api.LeaseService;
import org.neo4j.kernel.impl.api.MaximumTransactionLimitExceededException;
import org.neo4j.kernel.impl.api.TestKernelTransactionHandle;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.kernel.impl.api.state.ConstraintIndexCreator;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.constraints.StandardConstraintSemantics;
import org.neo4j.kernel.impl.factory.AccessCapabilityFactory;
import org.neo4j.kernel.impl.factory.CanWrite;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.query.TransactionExecutionMonitor;
import org.neo4j.kernel.impl.transaction.TransactionMonitor;
import org.neo4j.kernel.impl.util.collection.CollectionsFactorySupplier;
import org.neo4j.kernel.internal.event.DatabaseTransactionEventListeners;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.monitoring.tracing.Tracers;
import org.neo4j.lock.LockTracer;
import org.neo4j.lock.ResourceLocker;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLog;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.memory.MemoryGroup;
import org.neo4j.memory.MemoryPools;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.monitoring.Monitors;
import org.neo4j.resources.CpuClock;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.CommandCreationContext;
import org.neo4j.storageengine.api.StorageCommand;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.TransactionId;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;
import org.neo4j.storageengine.api.txstate.TxStateVisitor;
import org.neo4j.test.Race;
import org.neo4j.test.rule.OtherThreadRule;
import org.neo4j.time.Clocks;
import org.neo4j.time.SystemNanoClock;
import org.neo4j.token.TokenHolders;
import org.neo4j.token.api.TokenHolder;
import org.neo4j.util.concurrent.Futures;

class KernelTransactionsTest {
    private static final NamedDatabaseId DEFAULT_DATABASE_ID = new TestDatabaseIdRepository().defaultDatabase();
    private static final SystemNanoClock clock = Clocks.nanoClock();
    private final OtherThreadRule t2 = new OtherThreadRule();
    private final ExecutorService executorService = Executors.newCachedThreadPool();
    private DatabaseAvailabilityGuard databaseAvailabilityGuard;

    KernelTransactionsTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.databaseAvailabilityGuard = new DatabaseAvailabilityGuard(DEFAULT_DATABASE_ID, (Clock)clock, (Log)NullLog.getInstance(), 0L, (CompositeDatabaseAvailabilityGuard)Mockito.mock(CompositeDatabaseAvailabilityGuard.class));
        this.databaseAvailabilityGuard.init();
        this.t2.init("T2-" + this.getClass().getName());
    }

    @AfterEach
    void tearDown() {
        this.executorService.shutdownNow();
        this.t2.close();
    }

    @Test
    void shouldNotAllocateSystemTransactionId() throws Throwable {
        KernelTransactions transactions = this.newTestKernelTransactions();
        KernelTransaction firstTxn = KernelTransactionsTest.getKernelTransaction(transactions);
        Assertions.assertThat((long)firstTxn.getUserTransactionId()).isNotEqualTo(0L);
    }

    @Test
    void shouldListActiveTransactions() throws Throwable {
        KernelTransactions transactions = this.newTestKernelTransactions();
        KernelTransaction first = KernelTransactionsTest.getKernelTransaction(transactions);
        KernelTransaction second = KernelTransactionsTest.getKernelTransaction(transactions);
        KernelTransaction third = KernelTransactionsTest.getKernelTransaction(transactions);
        first.close();
        Assertions.assertThat((Iterable)transactions.activeTransactions()).isEqualTo((Object)Iterators.asSet((Object[])new KernelTransactionHandle[]{KernelTransactionsTest.newHandle(second), KernelTransactionsTest.newHandle(third)}));
    }

    @Test
    void shouldDisposeTransactionsWhenAsked() throws Throwable {
        KernelTransactions transactions = this.newKernelTransactions();
        transactions.disposeAll();
        KernelTransaction first = KernelTransactionsTest.getKernelTransaction(transactions);
        KernelTransaction second = KernelTransactionsTest.getKernelTransaction(transactions);
        KernelTransaction leftOpen = KernelTransactionsTest.getKernelTransaction(transactions);
        first.close();
        second.close();
        transactions.disposeAll();
        KernelTransaction postDispose = KernelTransactionsTest.getKernelTransaction(transactions);
        Assertions.assertThat((Object)postDispose).isNotEqualTo((Object)first);
        Assertions.assertThat((Object)postDispose).isNotEqualTo((Object)second);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)leftOpen.getReasonIfTerminated());
    }

    @Test
    void shouldReuseClosedTransactionObjects() throws Throwable {
        KernelTransactions transactions = this.newKernelTransactions();
        KernelTransaction a = KernelTransactionsTest.getKernelTransaction(transactions);
        a.close();
        KernelTransaction b = KernelTransactionsTest.getKernelTransaction(transactions);
        org.junit.jupiter.api.Assertions.assertSame((Object)a, (Object)b);
    }

    @Test
    void shouldTellWhenTransactionsFromSnapshotHaveBeenClosed() throws Throwable {
        KernelTransactions transactions = this.newKernelTransactions();
        KernelTransaction a = KernelTransactionsTest.getKernelTransaction(transactions);
        KernelTransaction b = KernelTransactionsTest.getKernelTransaction(transactions);
        KernelTransaction c = KernelTransactionsTest.getKernelTransaction(transactions);
        IdController.ConditionSnapshot snapshot = transactions.get();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)snapshot.conditionMet());
        a.close();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)snapshot.conditionMet());
        c.close();
        KernelTransaction d = KernelTransactionsTest.getKernelTransaction(transactions);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)snapshot.conditionMet());
        b.close();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)snapshot.conditionMet());
    }

    @Test
    void shouldTellWhenTransactionsFromSnapshotHaveBeenTerminated() throws Throwable {
        KernelTransactions transactions = this.newKernelTransactions();
        KernelTransaction a = KernelTransactionsTest.getKernelTransaction(transactions);
        KernelTransaction b = KernelTransactionsTest.getKernelTransaction(transactions);
        KernelTransaction c = KernelTransactionsTest.getKernelTransaction(transactions);
        IdController.ConditionSnapshot snapshot = transactions.get();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)snapshot.conditionMet());
        a.markForTermination((Status)Status.Transaction.Terminated);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)snapshot.conditionMet());
        c.markForTermination((Status)Status.Transaction.Terminated);
        KernelTransaction d = KernelTransactionsTest.getKernelTransaction(transactions);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)snapshot.conditionMet());
        b.markForTermination((Status)Status.Transaction.Terminated);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)snapshot.conditionMet());
    }

    @Test
    void shouldBeAbleToSnapshotDuringHeavyLoad() throws Throwable {
        KernelTransactions transactions = this.newKernelTransactions();
        Race race = new Race();
        int threads = 50;
        AtomicBoolean end = new AtomicBoolean();
        AtomicReferenceArray snapshots = new AtomicReferenceArray(50);
        int i = 0;
        while (i < 50) {
            int threadIndex = i++;
            race.addContestant(() -> {
                ThreadLocalRandom random = ThreadLocalRandom.current();
                while (!end.get()) {
                    try {
                        KernelTransaction ignored = KernelTransactionsTest.getKernelTransaction(transactions);
                        try {
                            LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(random.nextInt(3)));
                            if (snapshots.get(threadIndex) != null) continue;
                            snapshots.set(threadIndex, transactions.get());
                            LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(random.nextInt(3)));
                        }
                        finally {
                            if (ignored == null) continue;
                            ignored.close();
                        }
                    }
                    catch (TransactionFailureException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        race.addContestant(() -> {
            ThreadLocalRandom random = ThreadLocalRandom.current();
            int snapshotsLeft = 1000;
            while (snapshotsLeft > 0) {
                int threadIndex = random.nextInt(50);
                IdController.ConditionSnapshot snapshot = (IdController.ConditionSnapshot)snapshots.get(threadIndex);
                if (snapshot == null || !snapshot.conditionMet()) continue;
                --snapshotsLeft;
                snapshots.set(threadIndex, null);
            }
            end.set(true);
        });
        race.go();
    }

    @Test
    void transactionCloseRemovesTxFromActiveTransactions() throws Throwable {
        KernelTransactions kernelTransactions = this.newTestKernelTransactions();
        KernelTransaction tx1 = KernelTransactionsTest.getKernelTransaction(kernelTransactions);
        KernelTransaction tx2 = KernelTransactionsTest.getKernelTransaction(kernelTransactions);
        KernelTransaction tx3 = KernelTransactionsTest.getKernelTransaction(kernelTransactions);
        tx1.close();
        tx3.close();
        org.junit.jupiter.api.Assertions.assertEquals((Object)Iterators.asSet((Object[])new KernelTransactionHandle[]{KernelTransactionsTest.newHandle(tx2)}), (Object)kernelTransactions.activeTransactions());
    }

    @Test
    void disposeAllMarksAllTransactionsForTermination() throws Throwable {
        KernelTransactions kernelTransactions = this.newKernelTransactions();
        KernelTransaction tx1 = KernelTransactionsTest.getKernelTransaction(kernelTransactions);
        KernelTransaction tx2 = KernelTransactionsTest.getKernelTransaction(kernelTransactions);
        KernelTransaction tx3 = KernelTransactionsTest.getKernelTransaction(kernelTransactions);
        kernelTransactions.disposeAll();
        org.junit.jupiter.api.Assertions.assertEquals((Object)Status.Database.DatabaseUnavailable, tx1.getReasonIfTerminated().get());
        org.junit.jupiter.api.Assertions.assertEquals((Object)Status.Database.DatabaseUnavailable, tx2.getReasonIfTerminated().get());
        org.junit.jupiter.api.Assertions.assertEquals((Object)Status.Database.DatabaseUnavailable, tx3.getReasonIfTerminated().get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void transactionClosesUnderlyingStoreReaderWhenDisposed() throws Throwable {
        StorageReader storeStatement1 = (StorageReader)Mockito.mock(StorageReader.class);
        StorageReader storeStatement2 = (StorageReader)Mockito.mock(StorageReader.class);
        StorageReader storeStatement3 = (StorageReader)Mockito.mock(StorageReader.class);
        KernelTransactions kernelTransactions = this.newKernelTransactions((TransactionCommitProcess)Mockito.mock(TransactionCommitProcess.class), storeStatement1, storeStatement2, storeStatement3);
        KernelTransactionsTest.startAndCloseTransaction(kernelTransactions);
        this.executorService.submit(() -> KernelTransactionsTest.startAndCloseTransaction(kernelTransactions)).get();
        ExecutorService executorService2 = Executors.newSingleThreadExecutor();
        try {
            executorService2.submit(() -> KernelTransactionsTest.startAndCloseTransaction(kernelTransactions)).get();
        }
        finally {
            executorService2.shutdown();
        }
        kernelTransactions.disposeAll();
        ((StorageReader)Mockito.verify((Object)storeStatement1)).close();
        ((StorageReader)Mockito.verify((Object)storeStatement2)).close();
        ((StorageReader)Mockito.verify((Object)storeStatement3)).close();
    }

    @Test
    void threadThatBlocksNewTxsCantStartNewTxs() throws Throwable {
        KernelTransactions kernelTransactions = this.newKernelTransactions();
        kernelTransactions.blockNewTransactions();
        Exception e = (Exception)org.junit.jupiter.api.Assertions.assertThrows(Exception.class, () -> kernelTransactions.newInstance(KernelTransaction.Type.IMPLICIT, (LoginContext)AnonymousContext.write(), ClientConnectionInfo.EMBEDDED_CONNECTION, 0L));
        Assertions.assertThat((Throwable)e).isInstanceOf(IllegalStateException.class);
    }

    @Test
    @Timeout(value=10L)
    void blockNewTransactions() throws Throwable {
        KernelTransactions kernelTransactions = this.newKernelTransactions();
        kernelTransactions.blockNewTransactions();
        Future txOpener = this.t2.execute(() -> kernelTransactions.newInstance(KernelTransaction.Type.EXPLICIT, (LoginContext)AnonymousContext.write(), ClientConnectionInfo.EMBEDDED_CONNECTION, 0L));
        this.t2.get().waitUntilWaiting(location -> location.isAt(KernelTransactions.class, "newInstance"));
        KernelTransactionsTest.assertNotDone(txOpener);
        kernelTransactions.unblockNewTransactions();
        org.junit.jupiter.api.Assertions.assertNotNull(txOpener.get());
    }

    @Test
    @Timeout(value=10L)
    void unblockNewTransactionsFromWrongThreadThrows() throws Throwable {
        KernelTransactions kernelTransactions = this.newKernelTransactions();
        kernelTransactions.blockNewTransactions();
        Future txOpener = this.t2.execute(() -> kernelTransactions.newInstance(KernelTransaction.Type.EXPLICIT, (LoginContext)AnonymousContext.write(), ClientConnectionInfo.EMBEDDED_CONNECTION, 0L));
        this.t2.get().waitUntilWaiting(location -> location.isAt(KernelTransactions.class, "newInstance"));
        KernelTransactionsTest.assertNotDone(txOpener);
        Future<?> wrongUnblocker = this.unblockTxsInSeparateThread(kernelTransactions);
        ExecutionException e = (ExecutionException)org.junit.jupiter.api.Assertions.assertThrows(ExecutionException.class, wrongUnblocker::get);
        Assertions.assertThat((Throwable)e.getCause()).isInstanceOf(IllegalStateException.class);
        KernelTransactionsTest.assertNotDone(txOpener);
        kernelTransactions.unblockNewTransactions();
        org.junit.jupiter.api.Assertions.assertNotNull(txOpener.get());
    }

    @Test
    void shouldNotLeakTransactionOnSecurityContextFreezeFailure() throws Throwable {
        KernelTransactions kernelTransactions = this.newKernelTransactions();
        LoginContext loginContext = (LoginContext)Mockito.mock(LoginContext.class);
        Mockito.when((Object)loginContext.authorize((LoginContext.IdLookup)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (AbstractSecurityLog)ArgumentMatchers.any())).thenThrow(new Throwable[]{new AuthorizationExpiredException("Freeze failed.")});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> kernelTransactions.newInstance(KernelTransaction.Type.EXPLICIT, loginContext, ClientConnectionInfo.EMBEDDED_CONNECTION, 0L)).isInstanceOf(AuthorizationExpiredException.class)).hasMessage("Freeze failed.");
        ((IterableAssert)Assertions.assertThat((Iterable)kernelTransactions.activeTransactions()).as("We should not have any transaction", new Object[0])).isEmpty();
    }

    @Test
    void exceptionWhenStartingNewTransactionOnShutdownInstance() throws Throwable {
        KernelTransactions kernelTransactions = this.newKernelTransactions();
        this.databaseAvailabilityGuard.shutdown();
        org.junit.jupiter.api.Assertions.assertThrows(DatabaseShutdownException.class, () -> kernelTransactions.newInstance(KernelTransaction.Type.EXPLICIT, LoginContext.AUTH_DISABLED, ClientConnectionInfo.EMBEDDED_CONNECTION, 0L));
    }

    @Test
    void exceptionWhenStartingNewTransactionOnStoppedKernelTransactions() throws Throwable {
        KernelTransactions kernelTransactions = this.newKernelTransactions();
        this.t2.execute(() -> {
            KernelTransactionsTest.stopKernelTransactions(kernelTransactions);
            return null;
        }).get();
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> kernelTransactions.newInstance(KernelTransaction.Type.EXPLICIT, LoginContext.AUTH_DISABLED, ClientConnectionInfo.EMBEDDED_CONNECTION, 0L));
    }

    @Test
    void startNewTransactionOnRestartedKErnelTransactions() throws Throwable {
        KernelTransactions kernelTransactions = this.newKernelTransactions();
        kernelTransactions.stop();
        kernelTransactions.start();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)kernelTransactions.newInstance(KernelTransaction.Type.EXPLICIT, LoginContext.AUTH_DISABLED, ClientConnectionInfo.EMBEDDED_CONNECTION, 0L), (String)"New transaction created by restarted kernel transactions component.");
    }

    @Test
    void incrementalUserTransactionId() throws Throwable {
        KernelTransactions kernelTransactions = this.newKernelTransactions();
        try (KernelTransaction kernelTransaction = kernelTransactions.newInstance(KernelTransaction.Type.EXPLICIT, (LoginContext)AnonymousContext.access(), ClientConnectionInfo.EMBEDDED_CONNECTION, 0L);){
            org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)((KernelTransactionHandle)kernelTransactions.activeTransactions().iterator().next()).getUserTransactionId());
        }
        kernelTransaction = kernelTransactions.newInstance(KernelTransaction.Type.EXPLICIT, (LoginContext)AnonymousContext.access(), ClientConnectionInfo.EMBEDDED_CONNECTION, 0L);
        try {
            org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)((KernelTransactionHandle)kernelTransactions.activeTransactions().iterator().next()).getUserTransactionId());
        }
        finally {
            if (kernelTransaction != null) {
                kernelTransaction.close();
            }
        }
        kernelTransaction = kernelTransactions.newInstance(KernelTransaction.Type.EXPLICIT, (LoginContext)AnonymousContext.access(), ClientConnectionInfo.EMBEDDED_CONNECTION, 0L);
        try {
            org.junit.jupiter.api.Assertions.assertEquals((long)3L, (long)((KernelTransactionHandle)kernelTransactions.activeTransactions().iterator().next()).getUserTransactionId());
        }
        finally {
            if (kernelTransaction != null) {
                kernelTransaction.close();
            }
        }
    }

    @Test
    void doNotAllowToCreateMoreThenMaxActiveTransactions() throws Throwable {
        Config config = Config.defaults((Setting)GraphDatabaseSettings.max_concurrent_transactions, (Object)2);
        KernelTransactions kernelTransactions = this.newKernelTransactions(config);
        KernelTransaction ignore = kernelTransactions.newInstance(KernelTransaction.Type.EXPLICIT, (LoginContext)AnonymousContext.access(), ClientConnectionInfo.EMBEDDED_CONNECTION, 0L);
        KernelTransaction ignore2 = kernelTransactions.newInstance(KernelTransaction.Type.EXPLICIT, (LoginContext)AnonymousContext.access(), ClientConnectionInfo.EMBEDDED_CONNECTION, 0L);
        org.junit.jupiter.api.Assertions.assertThrows(MaximumTransactionLimitExceededException.class, () -> kernelTransactions.newInstance(KernelTransaction.Type.EXPLICIT, (LoginContext)AnonymousContext.access(), ClientConnectionInfo.EMBEDDED_CONNECTION, 0L));
    }

    @Test
    void allowToBeginTransactionsWhenSlotsAvailableAgain() throws Throwable {
        Config config = Config.defaults((Setting)GraphDatabaseSettings.max_concurrent_transactions, (Object)2);
        KernelTransactions kernelTransactions = this.newKernelTransactions(config);
        KernelTransaction ignore = kernelTransactions.newInstance(KernelTransaction.Type.EXPLICIT, (LoginContext)AnonymousContext.access(), ClientConnectionInfo.EMBEDDED_CONNECTION, 0L);
        KernelTransaction ignore2 = kernelTransactions.newInstance(KernelTransaction.Type.EXPLICIT, (LoginContext)AnonymousContext.access(), ClientConnectionInfo.EMBEDDED_CONNECTION, 0L);
        org.junit.jupiter.api.Assertions.assertThrows(MaximumTransactionLimitExceededException.class, () -> kernelTransactions.newInstance(KernelTransaction.Type.EXPLICIT, (LoginContext)AnonymousContext.access(), ClientConnectionInfo.EMBEDDED_CONNECTION, 0L));
        ignore.close();
        kernelTransactions.newInstance(KernelTransaction.Type.EXPLICIT, (LoginContext)AnonymousContext.access(), ClientConnectionInfo.EMBEDDED_CONNECTION, 0L);
    }

    @Test
    void allowToBeginTransactionsWhenConfigChanges() throws Throwable {
        Config config = Config.defaults((Setting)GraphDatabaseSettings.max_concurrent_transactions, (Object)2);
        KernelTransactions kernelTransactions = this.newKernelTransactions(config);
        KernelTransaction ignore = kernelTransactions.newInstance(KernelTransaction.Type.EXPLICIT, (LoginContext)AnonymousContext.access(), ClientConnectionInfo.EMBEDDED_CONNECTION, 0L);
        KernelTransaction ignore2 = kernelTransactions.newInstance(KernelTransaction.Type.EXPLICIT, (LoginContext)AnonymousContext.access(), ClientConnectionInfo.EMBEDDED_CONNECTION, 0L);
        org.junit.jupiter.api.Assertions.assertThrows(MaximumTransactionLimitExceededException.class, () -> kernelTransactions.newInstance(KernelTransaction.Type.EXPLICIT, (LoginContext)AnonymousContext.access(), ClientConnectionInfo.EMBEDDED_CONNECTION, 0L));
        config.setDynamic(GraphDatabaseSettings.max_concurrent_transactions, (Object)3, this.getClass().getSimpleName());
        kernelTransactions.newInstance(KernelTransaction.Type.EXPLICIT, (LoginContext)AnonymousContext.access(), ClientConnectionInfo.EMBEDDED_CONNECTION, 0L);
    }

    @Test
    void reuseSameTransactionInOneThread() throws Throwable {
        KernelTransactions kernelTransactions = this.newKernelTransactions();
        for (int i = 0; i < 100; ++i) {
            try (KernelTransaction kernelTransaction = kernelTransactions.newInstance(KernelTransaction.Type.EXPLICIT, (LoginContext)AnonymousContext.access(), ClientConnectionInfo.EMBEDDED_CONNECTION, 0L);){
                org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)kernelTransactions.getNumberOfActiveTransactions());
                continue;
            }
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)kernelTransactions.getNumberOfActiveTransactions());
    }

    @Test
    void trackNumberOfActiveTransactionFromMultipleThreads() throws Throwable {
        KernelTransactions kernelTransactions = this.newKernelTransactions();
        int expectedTransactions = 100;
        Phaser phaser = new Phaser(expectedTransactions);
        ArrayList transactionFutures = new ArrayList();
        for (int i = 0; i < expectedTransactions; ++i) {
            Future<?> transactionFuture = this.executorService.submit(() -> {
                try (KernelTransaction ignored = kernelTransactions.newInstance(KernelTransaction.Type.EXPLICIT, (LoginContext)AnonymousContext.access(), ClientConnectionInfo.EMBEDDED_CONNECTION, 0L);){
                    phaser.arriveAndAwaitAdvance();
                    org.junit.jupiter.api.Assertions.assertEquals((int)expectedTransactions, (int)kernelTransactions.getNumberOfActiveTransactions());
                    phaser.arriveAndAwaitAdvance();
                }
                catch (TransactionFailureException e) {
                    throw new RuntimeException(e);
                }
                phaser.arriveAndDeregister();
            });
            transactionFutures.add(transactionFuture);
        }
        Futures.combine(transactionFutures).get();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)kernelTransactions.getNumberOfActiveTransactions());
    }

    private static void stopKernelTransactions(KernelTransactions kernelTransactions) {
        try {
            kernelTransactions.stop();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private static void startAndCloseTransaction(KernelTransactions kernelTransactions) {
        try {
            kernelTransactions.newInstance(KernelTransaction.Type.EXPLICIT, LoginContext.AUTH_DISABLED, ClientConnectionInfo.EMBEDDED_CONNECTION, 0L).close();
        }
        catch (TransactionFailureException e) {
            throw new RuntimeException(e);
        }
    }

    private KernelTransactions newKernelTransactions() throws Throwable {
        return this.newKernelTransactions((TransactionCommitProcess)Mockito.mock(TransactionCommitProcess.class));
    }

    private KernelTransactions newKernelTransactions(Config config) throws Throwable {
        return this.newKernelTransactions((TransactionCommitProcess)Mockito.mock(TransactionCommitProcess.class), config);
    }

    private KernelTransactions newTestKernelTransactions() throws Throwable {
        return this.newKernelTransactions(true, (TransactionCommitProcess)Mockito.mock(TransactionCommitProcess.class), (StorageReader)Mockito.mock(StorageReader.class), Config.defaults(), new StorageReader[0]);
    }

    private KernelTransactions newKernelTransactions(TransactionCommitProcess commitProcess, Config config) throws Throwable {
        return this.newKernelTransactions(false, commitProcess, (StorageReader)Mockito.mock(StorageReader.class), config, new StorageReader[0]);
    }

    private KernelTransactions newKernelTransactions(TransactionCommitProcess commitProcess) throws Throwable {
        return this.newKernelTransactions(false, commitProcess, (StorageReader)Mockito.mock(StorageReader.class), Config.defaults(), new StorageReader[0]);
    }

    private KernelTransactions newKernelTransactions(TransactionCommitProcess commitProcess, StorageReader firstReader, StorageReader ... otherReaders) throws Throwable {
        return this.newKernelTransactions(false, commitProcess, firstReader, Config.defaults(), otherReaders);
    }

    private KernelTransactions newKernelTransactions(boolean testKernelTransactions, TransactionCommitProcess commitProcess, StorageReader firstReader, Config config, StorageReader ... otherReaders) throws Throwable {
        Locks locks = (Locks)Mockito.mock(Locks.class);
        Locks.Client client = (Locks.Client)Mockito.mock(Locks.Client.class);
        Mockito.when((Object)locks.newClient()).thenReturn((Object)client);
        StorageEngine storageEngine = (StorageEngine)Mockito.mock(StorageEngine.class);
        Mockito.when((Object)storageEngine.newReader()).thenReturn((Object)firstReader, (Object[])otherReaders);
        Mockito.when((Object)storageEngine.newCommandCreationContext((MemoryTracker)ArgumentMatchers.any())).thenReturn((Object)((CommandCreationContext)Mockito.mock(CommandCreationContext.class)));
        ((StorageEngine)Mockito.doAnswer(invocation -> {
            Collection argument = (Collection)invocation.getArgument(0);
            argument.add((StorageCommand)Mockito.mock(StorageCommand.class));
            return null;
        }).when((Object)storageEngine)).createCommands(ArgumentMatchers.anyCollection(), (ReadableTransactionState)ArgumentMatchers.any(ReadableTransactionState.class), (StorageReader)ArgumentMatchers.any(StorageReader.class), (CommandCreationContext)ArgumentMatchers.any(CommandCreationContext.class), (ResourceLocker)ArgumentMatchers.any(ResourceLocker.class), (LockTracer)ArgumentMatchers.any(LockTracer.class), ArgumentMatchers.anyLong(), (TxStateVisitor.Decorator)ArgumentMatchers.any(TxStateVisitor.Decorator.class), (CursorContext)ArgumentMatchers.any(CursorContext.class), (MemoryTracker)ArgumentMatchers.any(MemoryTracker.class));
        return this.newKernelTransactions(locks, storageEngine, commitProcess, testKernelTransactions, config);
    }

    private KernelTransactions newKernelTransactions(Locks locks, StorageEngine storageEngine, TransactionCommitProcess commitProcess, boolean testKernelTransactions, Config config) {
        LifeSupport life = new LifeSupport();
        life.start();
        TransactionIdStore transactionIdStore = (TransactionIdStore)Mockito.mock(TransactionIdStore.class);
        Mockito.when((Object)transactionIdStore.getLastCommittedTransaction()).thenReturn((Object)new TransactionId(0L, 0, 0L));
        Tracers tracers = new Tracers("null", (Log)NullLog.getInstance(), new Monitors(), (JobScheduler)Mockito.mock(JobScheduler.class), clock, config);
        DatabaseTracers databaseTracers = new DatabaseTracers(tracers);
        TestKernelTransactions transactions = testKernelTransactions ? KernelTransactionsTest.createTestTransactions(storageEngine, commitProcess, transactionIdStore, databaseTracers, locks, clock, (AvailabilityGuard)this.databaseAvailabilityGuard) : KernelTransactionsTest.createTransactions(storageEngine, commitProcess, transactionIdStore, databaseTracers, locks, clock, (AvailabilityGuard)this.databaseAvailabilityGuard, config);
        transactions.start();
        return transactions;
    }

    private static KernelTransactions createTransactions(StorageEngine storageEngine, TransactionCommitProcess commitProcess, TransactionIdStore transactionIdStore, DatabaseTracers tracers, Locks locks, SystemNanoClock clock, AvailabilityGuard databaseAvailabilityGuard, Config config) {
        return new KernelTransactions(config, locks, null, commitProcess, (DatabaseTransactionEventListeners)Mockito.mock(DatabaseTransactionEventListeners.class), (TransactionMonitor)Mockito.mock(TransactionMonitor.class), databaseAvailabilityGuard, storageEngine, (GlobalProcedures)Mockito.mock(GlobalProcedures.class), transactionIdStore, (DbmsRuntimeRepository)Mockito.mock(DbmsRuntimeRepository.class), () -> KernelVersion.LATEST, clock, new AtomicReference<CpuClock>(CpuClock.NOT_AVAILABLE), any -> CanWrite.INSTANCE, EmptyVersionContextSupplier.EMPTY, CollectionsFactorySupplier.ON_HEAP, (ConstraintSemantics)Mockito.mock(ConstraintSemantics.class), (SchemaState)Mockito.mock(SchemaState.class), KernelTransactionsTest.mockedTokenHolders(), DEFAULT_DATABASE_ID, (IndexingService)Mockito.mock(IndexingService.class), (IndexStatisticsStore)Mockito.mock(IndexStatisticsStore.class), KernelTransactionsTest.createDependencies(), tracers, LeaseService.NO_LEASES, new MemoryPools().pool(MemoryGroup.TRANSACTION, 0L, null), DatabaseReadOnlyChecker.writable(), TransactionExecutionMonitor.NO_OP, ExternalIdReuseConditionProvider.NONE, (LogProvider)NullLogProvider.getInstance());
    }

    private static TestKernelTransactions createTestTransactions(StorageEngine storageEngine, TransactionCommitProcess commitProcess, TransactionIdStore transactionIdStore, DatabaseTracers tracers, Locks locks, SystemNanoClock clock, AvailabilityGuard databaseAvailabilityGuard) {
        Dependencies dependencies = KernelTransactionsTest.createDependencies();
        return new TestKernelTransactions(locks, null, commitProcess, (DatabaseTransactionEventListeners)Mockito.mock(DatabaseTransactionEventListeners.class), (TransactionMonitor)Mockito.mock(TransactionMonitor.class), databaseAvailabilityGuard, tracers, storageEngine, (GlobalProcedures)Mockito.mock(GlobalProcedures.class), transactionIdStore, clock, any -> CanWrite.INSTANCE, EmptyVersionContextSupplier.EMPTY, KernelTransactionsTest.mockedTokenHolders(), dependencies);
    }

    private static Dependencies createDependencies() {
        Dependencies dependencies = new Dependencies();
        dependencies.satisfyDependency((Object)((GraphDatabaseFacade)Mockito.mock(GraphDatabaseFacade.class)));
        dependencies.satisfyDependency((Object)CommunitySecurityLog.NULL_LOG);
        return dependencies;
    }

    private Future<?> unblockTxsInSeparateThread(KernelTransactions kernelTransactions) {
        return this.executorService.submit(() -> ((KernelTransactions)kernelTransactions).unblockNewTransactions());
    }

    private static void assertNotDone(Future<?> future) {
        org.junit.jupiter.api.Assertions.assertFalse((boolean)future.isDone());
    }

    private static KernelTransactionHandle newHandle(KernelTransaction tx) {
        return new TestKernelTransactionHandle(tx);
    }

    private static KernelTransaction getKernelTransaction(KernelTransactions transactions) {
        return transactions.newInstance(KernelTransaction.Type.IMPLICIT, (LoginContext)AnonymousContext.access(), ClientConnectionInfo.EMBEDDED_CONNECTION, 0L);
    }

    private static TokenHolders mockedTokenHolders() {
        return new TokenHolders((TokenHolder)Mockito.mock(TokenHolder.class), (TokenHolder)Mockito.mock(TokenHolder.class), (TokenHolder)Mockito.mock(TokenHolder.class));
    }

    private static class TestKernelTransactions
    extends KernelTransactions {
        TestKernelTransactions(Locks locks, ConstraintIndexCreator constraintIndexCreator, TransactionCommitProcess transactionCommitProcess, DatabaseTransactionEventListeners eventListeners, TransactionMonitor transactionMonitor, AvailabilityGuard databaseAvailabilityGuard, DatabaseTracers tracers, StorageEngine storageEngine, GlobalProcedures globalProcedures, TransactionIdStore transactionIdStore, SystemNanoClock clock, AccessCapabilityFactory accessCapabilityFactory, VersionContextSupplier versionContextSupplier, TokenHolders tokenHolders, Dependencies databaseDependencies) {
            super(Config.defaults(), locks, constraintIndexCreator, transactionCommitProcess, eventListeners, transactionMonitor, databaseAvailabilityGuard, storageEngine, globalProcedures, transactionIdStore, (DbmsRuntimeRepository)Mockito.mock(DbmsRuntimeRepository.class), () -> KernelVersion.LATEST, clock, new AtomicReference<CpuClock>(CpuClock.NOT_AVAILABLE), accessCapabilityFactory, versionContextSupplier, CollectionsFactorySupplier.ON_HEAP, (ConstraintSemantics)new StandardConstraintSemantics(), (SchemaState)Mockito.mock(SchemaState.class), tokenHolders, DEFAULT_DATABASE_ID, (IndexingService)Mockito.mock(IndexingService.class), (IndexStatisticsStore)Mockito.mock(IndexStatisticsStore.class), databaseDependencies, tracers, LeaseService.NO_LEASES, new MemoryPools().pool(MemoryGroup.TRANSACTION, 0L, null), DatabaseReadOnlyChecker.writable(), TransactionExecutionMonitor.NO_OP, ExternalIdReuseConditionProvider.NONE, (LogProvider)NullLogProvider.getInstance());
        }

        KernelTransactionHandle createHandle(KernelTransactionImplementation tx) {
            return new TestKernelTransactionHandle((KernelTransaction)tx);
        }
    }
}

