/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.schema.SchemaTestUtil;
import org.neo4j.kernel.impl.api.index.IndexProxyStrategy;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.OnlineIndexProxy;
import org.neo4j.kernel.impl.api.index.ValueIndexProxyStrategy;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;

class OnlineIndexProxyTest {
    private final long indexId = 1L;
    private final IndexDescriptor descriptor = IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)1, (int[])new int[]{2})).withName("index").materialise(1L);
    private final IndexAccessor accessor = (IndexAccessor)Mockito.mock(IndexAccessor.class);
    private final IndexStoreView storeView = (IndexStoreView)Mockito.mock(IndexStoreView.class);
    private final IndexStatisticsStore indexStatisticsStore = (IndexStatisticsStore)Mockito.mock(IndexStatisticsStore.class);
    private final IndexProxyStrategy indexProxyStrategy = new ValueIndexProxyStrategy(this.descriptor, this.indexStatisticsStore, SchemaTestUtil.SIMPLE_NAME_LOOKUP);

    OnlineIndexProxyTest() {
    }

    @Test
    void shouldRemoveIndexCountsWhenTheIndexItselfIsDropped() {
        OnlineIndexProxy index = new OnlineIndexProxy(this.indexProxyStrategy, this.accessor, false);
        index.drop();
        ((IndexAccessor)Mockito.verify((Object)this.accessor)).drop();
        ((IndexStatisticsStore)Mockito.verify((Object)this.indexStatisticsStore)).removeIndex(1L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.accessor, this.storeView});
    }
}

