/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.Callable;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurveConfiguration;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.memory.ByteBufferFactory;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.schema.SchemaTestUtil;
import org.neo4j.kernel.impl.api.index.PhaseTracker;
import org.neo4j.kernel.impl.index.schema.BlockBasedIndexPopulator;
import org.neo4j.kernel.impl.index.schema.DatabaseIndexContext;
import org.neo4j.kernel.impl.index.schema.GenericBlockBasedIndexPopulator;
import org.neo4j.kernel.impl.index.schema.GenericKey;
import org.neo4j.kernel.impl.index.schema.GenericLayout;
import org.neo4j.kernel.impl.index.schema.IndexEntryTestUtil;
import org.neo4j.kernel.impl.index.schema.IndexFiles;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.NativeIndexReader;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.config.IndexSpecificSpaceFillingCurveSettings;
import org.neo4j.kernel.impl.index.schema.config.SpaceFillingCurveSettingsFactory;
import org.neo4j.kernel.impl.scheduler.JobSchedulerFactory;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobHandle;
import org.neo4j.scheduler.JobMonitoringParams;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.ValueIndexEntryUpdate;
import org.neo4j.storageengine.api.schema.SimpleEntityValueClient;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.pagecache.PageCacheExtension;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@PageCacheExtension
class GenericBlockBasedIndexPopulatorTest {
    private static final IndexDescriptor INDEX_DESCRIPTOR = IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)1, (int[])new int[]{1})).withName("index").materialise(1L);
    private static final IndexDescriptor UNIQUE_INDEX_DESCRIPTOR = IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)1, (int[])new int[]{1})).withName("constrain").materialise(1L);
    private final TokenNameLookup tokenNameLookup = SchemaTestUtil.SIMPLE_NAME_LOOKUP;
    @Inject
    private FileSystemAbstraction fs;
    @Inject
    private TestDirectory directory;
    @Inject
    private PageCache pageCache;
    private IndexFiles indexFiles;
    private DatabaseIndexContext databaseIndexContext;
    private JobScheduler jobScheduler;
    private IndexPopulator.PopulationWorkScheduler populationWorkScheduler;

    GenericBlockBasedIndexPopulatorTest() {
    }

    @BeforeEach
    void setup() {
        IndexProviderDescriptor providerDescriptor = new IndexProviderDescriptor("test", "v1");
        IndexDirectoryStructure directoryStructure = IndexDirectoryStructure.directoriesByProvider((Path)this.directory.homePath()).forProvider(providerDescriptor);
        this.indexFiles = new IndexFiles.Directory(this.fs, directoryStructure, INDEX_DESCRIPTOR.getId());
        this.databaseIndexContext = DatabaseIndexContext.builder((PageCache)this.pageCache, (FileSystemAbstraction)this.fs, (String)"neo4j").build();
        this.jobScheduler = JobSchedulerFactory.createInitialisedScheduler();
        this.populationWorkScheduler = new IndexPopulator.PopulationWorkScheduler(){

            public <T> JobHandle<T> schedule(IndexPopulator.JobDescriptionSupplier descriptionSupplier, Callable<T> job) {
                return GenericBlockBasedIndexPopulatorTest.this.jobScheduler.schedule(Group.INDEX_POPULATION_WORK, new JobMonitoringParams(null, null, null), job);
            }
        };
    }

    @AfterEach
    void tearDown() throws Exception {
        this.jobScheduler.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldSeeExternalUpdateBothBeforeAndAfterScanCompleted() throws IndexEntryConflictException, IOException {
        GenericBlockBasedIndexPopulator populator = this.instantiatePopulator(INDEX_DESCRIPTOR);
        try {
            TextValue hakuna = Values.stringValue((String)"hakuna");
            TextValue matata = Values.stringValue((String)"matata");
            int hakunaId = 1;
            int matataId = 2;
            GenericBlockBasedIndexPopulatorTest.externalUpdate((BlockBasedIndexPopulator<GenericKey, NativeIndexValue>)populator, hakuna, hakunaId);
            populator.scanCompleted(PhaseTracker.nullInstance, this.populationWorkScheduler, CursorContext.NULL);
            GenericBlockBasedIndexPopulatorTest.externalUpdate((BlockBasedIndexPopulator<GenericKey, NativeIndexValue>)populator, matata, matataId);
            GenericBlockBasedIndexPopulatorTest.assertMatch((BlockBasedIndexPopulator<GenericKey, NativeIndexValue>)populator, (Value)hakuna, hakunaId);
            GenericBlockBasedIndexPopulatorTest.assertMatch((BlockBasedIndexPopulator<GenericKey, NativeIndexValue>)populator, (Value)matata, matataId);
        }
        finally {
            populator.close(true, CursorContext.NULL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldThrowOnDuplicatedValuesFromScan() throws IOException {
        GenericBlockBasedIndexPopulator populator = this.instantiatePopulator(UNIQUE_INDEX_DESCRIPTOR);
        try {
            Value duplicate = Values.of((Object)"duplicate");
            ValueIndexEntryUpdate firstScanUpdate = ValueIndexEntryUpdate.add((long)1L, (SchemaDescriptorSupplier)INDEX_DESCRIPTOR, (Value[])new Value[]{duplicate});
            ValueIndexEntryUpdate secondScanUpdate = ValueIndexEntryUpdate.add((long)2L, (SchemaDescriptorSupplier)INDEX_DESCRIPTOR, (Value[])new Value[]{duplicate});
            Assertions.assertThrows(IndexEntryConflictException.class, () -> this.lambda$shouldThrowOnDuplicatedValuesFromScan$0((BlockBasedIndexPopulator)populator, firstScanUpdate, secondScanUpdate));
        }
        finally {
            populator.close(true, CursorContext.NULL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldThrowOnDuplicatedValuesFromExternalUpdates() throws IOException {
        GenericBlockBasedIndexPopulator populator = this.instantiatePopulator(UNIQUE_INDEX_DESCRIPTOR);
        try {
            Value duplicate = Values.of((Object)"duplicate");
            ValueIndexEntryUpdate firstExternalUpdate = ValueIndexEntryUpdate.add((long)1L, (SchemaDescriptorSupplier)INDEX_DESCRIPTOR, (Value[])new Value[]{duplicate});
            ValueIndexEntryUpdate secondExternalUpdate = ValueIndexEntryUpdate.add((long)2L, (SchemaDescriptorSupplier)INDEX_DESCRIPTOR, (Value[])new Value[]{duplicate});
            Assertions.assertThrows(IndexEntryConflictException.class, () -> this.lambda$shouldThrowOnDuplicatedValuesFromExternalUpdates$1((BlockBasedIndexPopulator)populator, firstExternalUpdate, secondExternalUpdate));
        }
        finally {
            populator.close(true, CursorContext.NULL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldThrowOnDuplicatedValuesFromScanAndExternalUpdates() throws IOException {
        GenericBlockBasedIndexPopulator populator = this.instantiatePopulator(UNIQUE_INDEX_DESCRIPTOR);
        try {
            Value duplicate = Values.of((Object)"duplicate");
            ValueIndexEntryUpdate externalUpdate = ValueIndexEntryUpdate.add((long)1L, (SchemaDescriptorSupplier)INDEX_DESCRIPTOR, (Value[])new Value[]{duplicate});
            ValueIndexEntryUpdate scanUpdate = ValueIndexEntryUpdate.add((long)2L, (SchemaDescriptorSupplier)INDEX_DESCRIPTOR, (Value[])new Value[]{duplicate});
            Assertions.assertThrows(IndexEntryConflictException.class, () -> this.lambda$shouldThrowOnDuplicatedValuesFromScanAndExternalUpdates$2((BlockBasedIndexPopulator)populator, externalUpdate, scanUpdate));
        }
        finally {
            populator.close(true, CursorContext.NULL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldNotThrowOnDuplicationsLaterFixedByExternalUpdates() throws IndexEntryConflictException, IOException {
        GenericBlockBasedIndexPopulator populator = this.instantiatePopulator(UNIQUE_INDEX_DESCRIPTOR);
        try {
            Value duplicate = Values.of((Object)"duplicate");
            Value unique = Values.of((Object)"unique");
            ValueIndexEntryUpdate firstScanUpdate = ValueIndexEntryUpdate.add((long)1L, (SchemaDescriptorSupplier)INDEX_DESCRIPTOR, (Value[])new Value[]{duplicate});
            ValueIndexEntryUpdate secondScanUpdate = ValueIndexEntryUpdate.add((long)2L, (SchemaDescriptorSupplier)INDEX_DESCRIPTOR, (Value[])new Value[]{duplicate});
            ValueIndexEntryUpdate externalUpdate = ValueIndexEntryUpdate.change((long)1L, (SchemaDescriptorSupplier)INDEX_DESCRIPTOR, (Value)duplicate, (Value)unique);
            populator.add(Collections.singleton(firstScanUpdate), CursorContext.NULL);
            try (IndexUpdater updater = populator.newPopulatingUpdater(CursorContext.NULL);){
                updater.process((IndexEntryUpdate)externalUpdate);
            }
            populator.add(Collections.singleton(secondScanUpdate), CursorContext.NULL);
            populator.scanCompleted(PhaseTracker.nullInstance, this.populationWorkScheduler, CursorContext.NULL);
            GenericBlockBasedIndexPopulatorTest.assertHasEntry((BlockBasedIndexPopulator<GenericKey, NativeIndexValue>)populator, unique, 1);
            GenericBlockBasedIndexPopulatorTest.assertHasEntry((BlockBasedIndexPopulator<GenericKey, NativeIndexValue>)populator, duplicate, 2);
        }
        finally {
            populator.close(true, CursorContext.NULL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldHandleEntriesOfMaxSize() throws IndexEntryConflictException, IOException {
        GenericBlockBasedIndexPopulator populator = this.instantiatePopulator(INDEX_DESCRIPTOR);
        try {
            int maxKeyValueSize = populator.tree.keyValueSizeCap();
            ValueIndexEntryUpdate update = IndexEntryUpdate.add((long)1L, (SchemaDescriptorSupplier)INDEX_DESCRIPTOR, (Value[])new Value[]{IndexEntryTestUtil.generateStringValueResultingInIndexEntrySize(populator.layout, maxKeyValueSize)});
            Set<ValueIndexEntryUpdate> updates = Collections.singleton(update);
            populator.add(updates, CursorContext.NULL);
            populator.scanCompleted(PhaseTracker.nullInstance, this.populationWorkScheduler, CursorContext.NULL);
            GenericBlockBasedIndexPopulatorTest.assertHasEntry((BlockBasedIndexPopulator<GenericKey, NativeIndexValue>)populator, update.values()[0], 1);
        }
        finally {
            populator.close(true, CursorContext.NULL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldThrowForEntriesLargerThanMaxSize() throws IOException {
        GenericBlockBasedIndexPopulator populator = this.instantiatePopulator(INDEX_DESCRIPTOR);
        try {
            int maxKeyValueSize = populator.tree.keyValueSizeCap();
            ValueIndexEntryUpdate update = IndexEntryUpdate.add((long)1L, (SchemaDescriptorSupplier)INDEX_DESCRIPTOR, (Value[])new Value[]{IndexEntryTestUtil.generateStringValueResultingInIndexEntrySize(populator.layout, maxKeyValueSize + 1)});
            IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> this.lambda$shouldThrowForEntriesLargerThanMaxSize$3(update, (BlockBasedIndexPopulator)populator));
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"Property value is too large to index, please see index documentation for limitations. Index: Index( id=1, name='index', type='GENERAL BTREE', schema=(:Label1 {property1}), indexProvider='Undecided-0' ), entity id: 1, property size: 8176, value: [String(\"AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA...."));
        }
        finally {
            populator.close(true, CursorContext.NULL);
        }
    }

    private static void assertHasEntry(BlockBasedIndexPopulator<GenericKey, NativeIndexValue> populator, Value entry, int expectedId) {
        try (NativeIndexReader reader = populator.newReader();){
            SimpleEntityValueClient valueClient = new SimpleEntityValueClient();
            PropertyIndexQuery.ExactPredicate exact = PropertyIndexQuery.exact((int)INDEX_DESCRIPTOR.schema().getPropertyId(), (Object)entry);
            reader.query(QueryContext.NULL_CONTEXT, (IndexProgressor.EntityValueClient)valueClient, IndexQueryConstraints.unconstrained(), new PropertyIndexQuery[]{exact});
            Assertions.assertTrue((boolean)valueClient.next());
            long id = valueClient.reference;
            Assertions.assertEquals((long)expectedId, (long)id);
        }
    }

    private static void externalUpdate(BlockBasedIndexPopulator<GenericKey, NativeIndexValue> populator, TextValue matata, int matataId) throws IndexEntryConflictException {
        try (IndexUpdater indexUpdater = populator.newPopulatingUpdater(CursorContext.NULL);){
            indexUpdater.process((IndexEntryUpdate)IndexEntryUpdate.add((long)matataId, (SchemaDescriptorSupplier)INDEX_DESCRIPTOR, (Value[])new Value[]{matata}));
        }
    }

    private static void assertMatch(BlockBasedIndexPopulator<GenericKey, NativeIndexValue> populator, Value value, long id) {
        try (NativeIndexReader reader = populator.newReader();){
            SimpleEntityValueClient cursor = new SimpleEntityValueClient();
            reader.query(QueryContext.NULL_CONTEXT, (IndexProgressor.EntityValueClient)cursor, IndexQueryConstraints.unorderedValues(), new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)INDEX_DESCRIPTOR.schema().getPropertyId(), (Object)value)});
            Assertions.assertTrue((boolean)cursor.next());
            Assertions.assertEquals((long)id, (long)cursor.reference);
            Assertions.assertEquals((Object)value, (Object)cursor.values[0]);
            Assertions.assertFalse((boolean)cursor.next());
        }
    }

    private GenericBlockBasedIndexPopulator instantiatePopulator(IndexDescriptor indexDescriptor) throws IOException {
        Config config = Config.defaults();
        IndexSpecificSpaceFillingCurveSettings spatialSettings = IndexSpecificSpaceFillingCurveSettings.fromConfig((Config)config);
        GenericLayout layout = new GenericLayout(1, spatialSettings);
        SpaceFillingCurveConfiguration configuration = SpaceFillingCurveSettingsFactory.getConfiguredSpaceFillingCurveConfiguration((Config)config);
        GenericBlockBasedIndexPopulator populator = new GenericBlockBasedIndexPopulator(this.databaseIndexContext, this.indexFiles, (IndexLayout)layout, indexDescriptor, spatialSettings, configuration, false, ByteBufferFactory.heapBufferFactory((int)((int)ByteUnit.kibiBytes((long)40L))), config, (MemoryTracker)EmptyMemoryTracker.INSTANCE, this.tokenNameLookup);
        populator.create();
        return populator;
    }

    private /* synthetic */ void lambda$shouldThrowForEntriesLargerThanMaxSize$3(ValueIndexEntryUpdate update, BlockBasedIndexPopulator populator) throws Throwable {
        Set<ValueIndexEntryUpdate> updates = Collections.singleton(update);
        populator.add(updates, CursorContext.NULL);
        populator.scanCompleted(PhaseTracker.nullInstance, this.populationWorkScheduler, CursorContext.NULL);
    }

    private /* synthetic */ void lambda$shouldThrowOnDuplicatedValuesFromScanAndExternalUpdates$2(BlockBasedIndexPopulator populator, ValueIndexEntryUpdate externalUpdate, ValueIndexEntryUpdate scanUpdate) throws Throwable {
        try (IndexUpdater updater = populator.newPopulatingUpdater(CursorContext.NULL);){
            updater.process((IndexEntryUpdate)externalUpdate);
        }
        populator.add(Collections.singleton(scanUpdate), CursorContext.NULL);
        populator.scanCompleted(PhaseTracker.nullInstance, this.populationWorkScheduler, CursorContext.NULL);
    }

    private /* synthetic */ void lambda$shouldThrowOnDuplicatedValuesFromExternalUpdates$1(BlockBasedIndexPopulator populator, ValueIndexEntryUpdate firstExternalUpdate, ValueIndexEntryUpdate secondExternalUpdate) throws Throwable {
        try (IndexUpdater updater = populator.newPopulatingUpdater(CursorContext.NULL);){
            updater.process((IndexEntryUpdate)firstExternalUpdate);
            updater.process((IndexEntryUpdate)secondExternalUpdate);
        }
        populator.scanCompleted(PhaseTracker.nullInstance, this.populationWorkScheduler, CursorContext.NULL);
    }

    private /* synthetic */ void lambda$shouldThrowOnDuplicatedValuesFromScan$0(BlockBasedIndexPopulator populator, ValueIndexEntryUpdate firstScanUpdate, ValueIndexEntryUpdate secondScanUpdate) throws Throwable {
        populator.add(Collections.singleton(firstScanUpdate), CursorContext.NULL);
        populator.add(Collections.singleton(secondScanUpdate), CursorContext.NULL);
        populator.scanCompleted(PhaseTracker.nullInstance, this.populationWorkScheduler, CursorContext.NULL);
    }
}

