/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.Serializable;
import java.util.HashMap;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.Config;
import org.neo4j.graphdb.schema.IndexSettingUtil;
import org.neo4j.internal.schema.IndexConfig;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.impl.index.schema.DatabaseIndexContext;
import org.neo4j.kernel.impl.index.schema.GenericNativeIndexProvider;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.DoubleArray;
import org.neo4j.values.storable.Values;

class GenericNativeIndexProviderTest {
    GenericNativeIndexProviderTest() {
    }

    @Test
    void mustCompleteIndexDescriptorConfigurationsWithSpatialConfig() {
        DatabaseIndexContext context = DatabaseIndexContext.builder(null, null, (String)"neo4j").build();
        GenericNativeIndexProvider provider = new GenericNativeIndexProvider(context, IndexDirectoryStructure.NONE, null, Config.defaults());
        LabelSchemaDescriptor incompleteSchema = SchemaDescriptor.forLabel((int)1, (int[])new int[]{1});
        IndexDescriptor incompleteDescriptor = IndexPrototype.forSchema((SchemaDescriptor)incompleteSchema, (IndexProviderDescriptor)IndexProviderDescriptor.UNDECIDED).withName("index").materialise(1L);
        IndexDescriptor completedDescriptor = provider.completeConfiguration(incompleteDescriptor);
        IndexConfig sinfulIndexConfig = incompleteDescriptor.getIndexConfig();
        IndexConfig completedIndexConfig = completedDescriptor.getIndexConfig();
        Assertions.assertEquals((int)0, (int)sinfulIndexConfig.entries().count((Predicate & Serializable)p -> true), (String)"expected sinful index config to have no entries");
        for (CoordinateReferenceSystem crs : CoordinateReferenceSystem.all()) {
            Assertions.assertNotNull((Object)completedIndexConfig.get(IndexSettingUtil.spatialMinSettingForCrs((CoordinateReferenceSystem)crs).getSettingName()));
            Assertions.assertNotNull((Object)completedIndexConfig.get(IndexSettingUtil.spatialMaxSettingForCrs((CoordinateReferenceSystem)crs).getSettingName()));
        }
    }

    @Test
    void completeConfigurationMustNotOverrideExistingSettings() {
        DatabaseIndexContext context = DatabaseIndexContext.builder(null, null, (String)"neo4j").build();
        GenericNativeIndexProvider provider = new GenericNativeIndexProvider(context, IndexDirectoryStructure.NONE, null, Config.defaults());
        HashMap<String, DoubleArray> existingSettings = new HashMap<String, DoubleArray>();
        CoordinateReferenceSystem existingCrs = CoordinateReferenceSystem.Cartesian;
        DoubleArray min = Values.doubleArray((double[])new double[]{0.0, 0.0});
        DoubleArray max = Values.doubleArray((double[])new double[]{1.0, 1.0});
        existingSettings.put(IndexSettingUtil.spatialMinSettingForCrs((CoordinateReferenceSystem)existingCrs).getSettingName(), min);
        existingSettings.put(IndexSettingUtil.spatialMaxSettingForCrs((CoordinateReferenceSystem)existingCrs).getSettingName(), max);
        IndexConfig existingIndexConfig = IndexConfig.with(existingSettings);
        LabelSchemaDescriptor incompleteSchema = SchemaDescriptor.forLabel((int)1, (int[])new int[]{1});
        IndexDescriptor incompleteDescriptor = IndexPrototype.forSchema((SchemaDescriptor)incompleteSchema, (IndexProviderDescriptor)IndexProviderDescriptor.UNDECIDED).withName("index").materialise(1L).withIndexConfig(existingIndexConfig);
        IndexDescriptor completedDescriptor = provider.completeConfiguration(incompleteDescriptor);
        IndexConfig completedIndexConfig = completedDescriptor.getIndexConfig();
        for (CoordinateReferenceSystem crs : CoordinateReferenceSystem.all()) {
            if (crs.equals((Object)existingCrs)) {
                Assertions.assertEquals((Object)min, (Object)completedIndexConfig.get(IndexSettingUtil.spatialMinSettingForCrs((CoordinateReferenceSystem)crs).getSettingName()));
                Assertions.assertEquals((Object)max, (Object)completedIndexConfig.get(IndexSettingUtil.spatialMaxSettingForCrs((CoordinateReferenceSystem)crs).getSettingName()));
                continue;
            }
            Assertions.assertNotNull((Object)completedIndexConfig.get(IndexSettingUtil.spatialMinSettingForCrs((CoordinateReferenceSystem)crs).getSettingName()));
            Assertions.assertNotNull((Object)completedIndexConfig.get(IndexSettingUtil.spatialMaxSettingForCrs((CoordinateReferenceSystem)crs).getSettingName()));
        }
    }
}

