/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.index.IndexSample;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.schema.index.TestIndexDescriptorFactory;
import org.neo4j.kernel.impl.api.index.PhaseTracker;
import org.neo4j.kernel.impl.index.schema.DatabaseIndexContext;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.IndexLayoutFactory;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexPopulator;
import org.neo4j.kernel.impl.index.schema.NativeIndexPopulatorTestCases;
import org.neo4j.kernel.impl.index.schema.NativeIndexPopulatorTests;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.ValueCreatorUtil;
import org.neo4j.storageengine.api.ValueIndexEntryUpdate;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueType;

abstract class NativeNonUniqueIndexPopulatorTest<KEY extends NativeIndexKey<KEY>, VALUE extends NativeIndexValue>
extends NativeIndexPopulatorTests<KEY, VALUE> {
    private final NativeIndexPopulatorTestCases.PopulatorFactory<KEY, VALUE> populatorFactory;
    private final ValueType[] typesOfGroup;
    private final IndexLayoutFactory<KEY, VALUE> indexLayoutFactory;
    private static final IndexDescriptor nonUniqueDescriptor = TestIndexDescriptorFactory.forLabel(42, 666);

    NativeNonUniqueIndexPopulatorTest(NativeIndexPopulatorTestCases.PopulatorFactory<KEY, VALUE> populatorFactory, ValueType[] typesOfGroup, IndexLayoutFactory<KEY, VALUE> indexLayoutFactory) {
        this.populatorFactory = populatorFactory;
        this.typesOfGroup = typesOfGroup;
        this.indexLayoutFactory = indexLayoutFactory;
    }

    NativeIndexPopulator<KEY, VALUE> createPopulator(PageCache pageCache) throws IOException {
        DatabaseIndexContext context = DatabaseIndexContext.builder((PageCache)pageCache, (FileSystemAbstraction)this.fs, (String)"neo4j").build();
        return this.populatorFactory.create(context, this.indexFiles, (IndexLayout)this.layout, this.indexDescriptor, this.tokenNameLookup);
    }

    @Override
    ValueCreatorUtil<KEY, VALUE> createValueCreatorUtil() {
        return new ValueCreatorUtil(nonUniqueDescriptor, this.typesOfGroup, 0.1);
    }

    @Override
    IndexLayout<KEY, VALUE> createLayout() {
        return this.indexLayoutFactory.create();
    }

    @Override
    IndexDescriptor indexDescriptor() {
        return nonUniqueDescriptor;
    }

    @Test
    void addShouldApplyDuplicateValues() throws Exception {
        this.populator.create();
        ValueIndexEntryUpdate<IndexDescriptor>[] updates = this.valueCreatorUtil.someUpdatesWithDuplicateValues(this.random);
        this.populator.add(Arrays.asList(updates), CursorContext.NULL);
        this.populator.scanCompleted(PhaseTracker.nullInstance, this.populationWorkScheduler, CursorContext.NULL);
        this.populator.close(true, CursorContext.NULL);
        this.valueUtil.verifyUpdates(updates, this::getTree);
    }

    @Test
    void updaterShouldApplyDuplicateValues() throws Exception {
        this.populator.create();
        ValueIndexEntryUpdate<IndexDescriptor>[] updates = this.valueCreatorUtil.someUpdatesWithDuplicateValues(this.random);
        try (IndexUpdater updater = this.populator.newPopulatingUpdater(null_property_accessor, CursorContext.NULL);){
            for (ValueIndexEntryUpdate<IndexDescriptor> update : updates) {
                updater.process(update);
            }
        }
        this.populator.scanCompleted(PhaseTracker.nullInstance, this.populationWorkScheduler, CursorContext.NULL);
        this.populator.close(true, CursorContext.NULL);
        this.valueUtil.verifyUpdates(updates, this::getTree);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldSampleUpdatesIfConfiguredForOnlineSampling() throws Exception {
        try {
            Value[] updates;
            this.populator.create();
            ValueIndexEntryUpdate<IndexDescriptor>[] scanUpdates = this.valueCreatorUtil.someUpdates(this.random);
            this.populator.add(Arrays.asList(scanUpdates), CursorContext.NULL);
            Iterator<ValueIndexEntryUpdate<IndexDescriptor>> generator = this.valueCreatorUtil.randomUpdateGenerator(this.random);
            updates = new Value[]{generator.next().values()[0], generator.next().values()[0], updates[1], generator.next().values()[0], updates[3]};
            try (IndexUpdater updater = this.populator.newPopulatingUpdater(null_property_accessor, CursorContext.NULL);){
                long nodeId = 1000L;
                for (Value value : updates) {
                    ValueIndexEntryUpdate<IndexDescriptor> update = this.valueCreatorUtil.add(nodeId++, value);
                    updater.process(update);
                }
            }
            this.populator.scanCompleted(PhaseTracker.nullInstance, this.populationWorkScheduler, CursorContext.NULL);
            IndexSample sample = this.populator.sample(CursorContext.NULL);
            Assertions.assertEquals((long)scanUpdates.length, (long)sample.sampleSize());
            Assertions.assertEquals((long)ValueCreatorUtil.countUniqueValues(scanUpdates), (long)sample.uniqueValues());
            Assertions.assertEquals((long)scanUpdates.length, (long)sample.indexSize());
            Assertions.assertEquals((long)updates.length, (long)sample.updates());
        }
        finally {
            this.populator.close(true, CursorContext.NULL);
        }
    }
}

