/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.util.Random;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.GBPTreeBuilder;
import org.neo4j.index.internal.gbptree.GBPTreeVisitor;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.index.schema.TokenIndex;
import org.neo4j.kernel.impl.index.schema.TokenIndexUpdater;
import org.neo4j.kernel.impl.index.schema.TokenScanKey;
import org.neo4j.kernel.impl.index.schema.TokenScanLayout;
import org.neo4j.kernel.impl.index.schema.TokenScanValue;
import org.neo4j.kernel.impl.index.schema.TokenScanValueIterator;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.TokenIndexEntryUpdate;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.extension.pagecache.PageCacheExtension;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.test.rule.TestDirectory;

@ExtendWith(value={RandomExtension.class})
@PageCacheExtension
class TokenIndexUpdaterTest {
    private static final int LABEL_COUNT = 5;
    private static final int NODE_COUNT = 10000;
    @Inject
    private RandomRule random;
    @Inject
    private PageCache pageCache;
    @Inject
    private TestDirectory directory;
    private GBPTree<TokenScanKey, TokenScanValue> tree;

    TokenIndexUpdaterTest() {
    }

    @BeforeEach
    void openTree() {
        this.tree = new GBPTreeBuilder(this.pageCache, this.directory.file("file"), (Layout)new TokenScanLayout()).build();
    }

    @AfterEach
    void closeTree() throws IOException {
        this.tree.close();
    }

    @Test
    void shouldAddAndRemoveLabels() throws Exception {
        long[] expected = new long[10000];
        try (TokenIndexUpdater writer = new TokenIndexUpdater(Integer.max(5, 100), TokenIndex.EMPTY);){
            writer.initialize(this.tree.writer(CursorContext.NULL));
            for (int i = 0; i < 30000; ++i) {
                TokenIndexEntryUpdate<?> update = this.randomUpdate(expected);
                writer.process(update);
            }
        }
        for (int i = 0; i < 5; ++i) {
            long[] expectedNodeIds = TokenIndexUpdaterTest.nodesWithLabel(expected, i);
            long[] actualNodeIds = PrimitiveLongCollections.asArray((LongIterator)new TokenScanValueIterator(this.tree.seek((Object)new TokenScanKey(i, 0L), (Object)new TokenScanKey(i, Long.MAX_VALUE), CursorContext.NULL), -1L));
            Assertions.assertArrayEquals((long[])expectedNodeIds, (long[])actualNodeIds, (String)("For label " + i));
        }
    }

    @Test
    void shouldNotAcceptUnsortedLabels() {
        IllegalArgumentException exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> {
            try (TokenIndexUpdater writer = new TokenIndexUpdater(1, TokenIndex.EMPTY);){
                writer.initialize(this.tree.writer(CursorContext.NULL));
                writer.process((IndexEntryUpdate)TokenIndexEntryUpdate.change((long)0L, null, (long[])PrimitiveLongCollections.EMPTY_LONG_ARRAY, (long[])new long[]{2L, 1L}));
            }
        });
        Assertions.assertTrue((boolean)exception.getMessage().contains("unsorted"));
    }

    @Test
    void shouldRemoveEmptyTreeEntries() throws Exception {
        long baseNodeId;
        int numberOfTreeEntries = 3;
        int numberOfNodesInEach = 5;
        int labelId = 1;
        long[] labels = new long[]{labelId};
        try (TokenIndexUpdater writer = new TokenIndexUpdater(Integer.max(5, 100), TokenIndex.EMPTY);){
            writer.initialize(this.tree.writer(CursorContext.NULL));
            for (int i = 0; i < numberOfTreeEntries; ++i) {
                baseNodeId = i * 64;
                for (int j = 0; j < numberOfNodesInEach; ++j) {
                    writer.process((IndexEntryUpdate)TokenIndexEntryUpdate.change((long)(baseNodeId + (long)j), null, (long[])PrimitiveLongCollections.EMPTY_LONG_ARRAY, (long[])labels));
                }
            }
        }
        this.assertTreeHasKeysRepresentingIdRanges(TokenIndexUpdaterTest.setOfRange(0L, numberOfTreeEntries));
        int treeEntryToRemoveFrom = 1;
        try (TokenIndexUpdater writer = new TokenIndexUpdater(Integer.max(5, 100), TokenIndex.EMPTY);){
            writer.initialize(this.tree.writer(CursorContext.NULL));
            baseNodeId = treeEntryToRemoveFrom * 64;
            for (int i = 0; i < numberOfNodesInEach; ++i) {
                writer.process((IndexEntryUpdate)TokenIndexEntryUpdate.change((long)(baseNodeId + (long)i), null, (long[])labels, (long[])PrimitiveLongCollections.EMPTY_LONG_ARRAY));
            }
        }
        MutableLongSet expected = TokenIndexUpdaterTest.setOfRange(0L, numberOfTreeEntries);
        expected.remove((long)treeEntryToRemoveFrom);
        this.assertTreeHasKeysRepresentingIdRanges(expected);
    }

    private TokenIndexEntryUpdate<?> randomUpdate(long[] expected) {
        int nodeId = this.random.nextInt(expected.length);
        long labels = expected[nodeId];
        long[] before = TokenIndexUpdaterTest.getLabels(labels);
        int changeCount = this.random.nextInt(4) + 1;
        for (int i = 0; i < changeCount; ++i) {
            labels = TokenIndexUpdaterTest.flipRandom(labels, 5, this.random.random());
        }
        expected[nodeId] = labels;
        return TokenIndexEntryUpdate.change((long)nodeId, null, (long[])before, (long[])TokenIndexUpdaterTest.getLabels(labels));
    }

    private void assertTreeHasKeysRepresentingIdRanges(final MutableLongSet expected) throws IOException {
        this.tree.visit((GBPTreeVisitor)new GBPTreeVisitor.Adaptor<TokenScanKey, TokenScanValue>(){

            public void key(TokenScanKey tokenScanKey, boolean isLeaf, long offloadId) {
                if (isLeaf) {
                    Assertions.assertTrue((boolean)expected.remove(tokenScanKey.idRange));
                }
            }
        }, CursorContext.NULL);
        Assertions.assertTrue((boolean)expected.isEmpty());
    }

    private static MutableLongSet setOfRange(long from, long to) {
        MutableLongSet set = LongSets.mutable.empty();
        for (long i = from; i < to; ++i) {
            set.add(i);
        }
        return set;
    }

    static long[] nodesWithLabel(long[] expected, int labelId) {
        int mask = 1 << labelId;
        int count = 0;
        for (long labels : expected) {
            if ((labels & (long)mask) == 0L) continue;
            ++count;
        }
        long[] result = new long[count];
        int cursor = 0;
        for (int nodeId = 0; nodeId < expected.length; ++nodeId) {
            long labels;
            labels = expected[nodeId];
            if ((labels & (long)mask) == 0L) continue;
            result[cursor++] = nodeId;
        }
        return result;
    }

    static long flipRandom(long existingLabels, int highLabelId, Random random) {
        return existingLabels ^ 1L << random.nextInt(highLabelId);
    }

    public static long[] getLabels(long bits) {
        long[] result = new long[Long.bitCount(bits)];
        int c = 0;
        for (int labelId = 0; labelId < 5; ++labelId) {
            int mask = 1 << labelId;
            if ((bits & (long)mask) == 0L) continue;
            result[c++] = labelId;
        }
        return result;
    }
}

