/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.config;

import org.assertj.core.api.AbstractDoubleArrayAssert;
import org.assertj.core.api.Assertions;
import org.neo4j.configuration.Config;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurve;
import org.neo4j.internal.helpers.collection.Pair;
import org.neo4j.kernel.impl.index.schema.config.ConfiguredSpaceFillingCurveSettingsCache;
import org.neo4j.kernel.impl.index.schema.config.SpaceFillingCurveSettings;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.Values;

public class SpatialIndexValueTestUtil {
    public static Pair<PointValue, PointValue> pointsWithSameValueOnSpaceFillingCurve(Config config) {
        ConfiguredSpaceFillingCurveSettingsCache configuredCache = new ConfiguredSpaceFillingCurveSettingsCache(config);
        SpaceFillingCurveSettings spaceFillingCurveSettings = configuredCache.forCRS(CoordinateReferenceSystem.WGS84);
        SpaceFillingCurve curve = spaceFillingCurveSettings.curve();
        double[] origin = new double[]{0.0, 0.0};
        Long spaceFillingCurveMapForOrigin = curve.derivedValueFor(origin);
        double[] centerPointForOriginTile = curve.centerPointFor(spaceFillingCurveMapForOrigin.longValue());
        PointValue originValue = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])origin);
        PointValue centerPointValue = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])centerPointForOriginTile);
        ((AbstractDoubleArrayAssert)Assertions.assertThat((double[])origin).as("need non equal points for this test", new Object[0])).isNotEqualTo((Object)centerPointValue);
        return Pair.of((Object)originValue, (Object)centerPointValue);
    }
}

