/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.kernel.api.helpers.StubNodeCursor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.kernel.api.schema.index.TestIndexDescriptorFactory;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.newapi.IndexTxStateUpdater;
import org.neo4j.kernel.impl.newapi.IndexTxStateUpdaterTestBase;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueTuple;
import org.neo4j.values.storable.Values;

class NodeIndexTxStateUpdaterTest
extends IndexTxStateUpdaterTestBase {
    private static final int LABEL_ID_1 = 10;
    private static final int LABEL_ID_2 = 11;
    private static final int UN_INDEXED_LABEL_ID = 12;
    private final IndexDescriptor indexOn1_1 = TestIndexDescriptorFactory.forLabel(10, 20);
    private final IndexDescriptor indexOn2_new = TestIndexDescriptorFactory.forLabel(11, 23);
    private final IndexDescriptor uniqueOn1_2 = TestIndexDescriptorFactory.uniqueForLabel(10, 21);
    private final IndexDescriptor indexOn1_1_new = TestIndexDescriptorFactory.forLabel(10, 20, 23);
    private final IndexDescriptor uniqueOn2_2_3 = TestIndexDescriptorFactory.uniqueForLabel(11, 21, 22);
    private final List<IndexDescriptor> indexes = Arrays.asList(this.indexOn1_1, this.indexOn2_new, this.uniqueOn1_2, this.indexOn1_1_new, this.uniqueOn2_2_3);
    private StubNodeCursor node;

    NodeIndexTxStateUpdaterTest() {
    }

    @BeforeEach
    void setup() throws IndexNotFoundKernelException {
        this.setUp(this.indexes);
        HashMap<Integer, Value> map = new HashMap<Integer, Value>();
        map.put(20, Values.of((Object)"hi1"));
        map.put(21, Values.of((Object)"hi2"));
        map.put(22, Values.of((Object)"hi3"));
        this.node = new StubNodeCursor().withNode(0L, new long[]{10L, 11L}, map);
        this.node.next();
    }

    @Test
    void shouldNotUpdateIndexesOnChangedIrrelevantLabel() {
        this.indexTxUpdater.onLabelChange(12, PROPS, (NodeCursor)this.node, (PropertyCursor)this.propertyCursor, IndexTxStateUpdater.LabelChangeType.ADDED_LABEL);
        this.indexTxUpdater.onLabelChange(12, PROPS, (NodeCursor)this.node, (PropertyCursor)this.propertyCursor, IndexTxStateUpdater.LabelChangeType.REMOVED_LABEL);
        ((TransactionState)Mockito.verify((Object)this.txState, (VerificationMode)Mockito.never())).indexDoUpdateEntry((SchemaDescriptor)ArgumentMatchers.any(), (long)ArgumentMatchers.anyInt(), (ValueTuple)ArgumentMatchers.any(), (ValueTuple)ArgumentMatchers.any());
    }

    @Test
    void shouldUpdateIndexesOnAddedLabel() {
        this.indexTxUpdater.onLabelChange(10, PROPS, (NodeCursor)this.node, (PropertyCursor)this.propertyCursor, IndexTxStateUpdater.LabelChangeType.ADDED_LABEL);
        this.verifyIndexUpdate(this.indexOn1_1.schema(), this.node.nodeReference(), null, NodeIndexTxStateUpdaterTest.values("hi1"));
        this.verifyIndexUpdate(this.uniqueOn1_2.schema(), this.node.nodeReference(), null, NodeIndexTxStateUpdaterTest.values("hi2"));
        ((TransactionState)Mockito.verify((Object)this.txState, (VerificationMode)Mockito.times((int)2))).indexDoUpdateEntry((SchemaDescriptor)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), (ValueTuple)ArgumentMatchers.isNull(), (ValueTuple)ArgumentMatchers.any());
    }

    @Test
    void shouldUpdateIndexesOnRemovedLabel() {
        this.indexTxUpdater.onLabelChange(11, PROPS, (NodeCursor)this.node, (PropertyCursor)this.propertyCursor, IndexTxStateUpdater.LabelChangeType.REMOVED_LABEL);
        this.verifyIndexUpdate(this.uniqueOn2_2_3.schema(), this.node.nodeReference(), NodeIndexTxStateUpdaterTest.values("hi2", "hi3"), null);
        ((TransactionState)Mockito.verify((Object)this.txState)).indexDoUpdateEntry((SchemaDescriptor)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), (ValueTuple)ArgumentMatchers.any(), (ValueTuple)ArgumentMatchers.isNull());
    }

    @Test
    void shouldNotUpdateIndexesOnChangedIrrelevantProperty() {
        this.indexTxUpdater.onPropertyAdd((NodeCursor)this.node, (PropertyCursor)this.propertyCursor, this.node.labels().all(), 24, PROPS, Values.of((Object)"whAt"));
        this.indexTxUpdater.onPropertyRemove((NodeCursor)this.node, (PropertyCursor)this.propertyCursor, this.node.labels().all(), 24, PROPS, Values.of((Object)"whAt"));
        this.indexTxUpdater.onPropertyChange((NodeCursor)this.node, (PropertyCursor)this.propertyCursor, this.node.labels().all(), 24, PROPS, Values.of((Object)"whAt"), Values.of((Object)"whAt2"));
        ((TransactionState)Mockito.verify((Object)this.txState, (VerificationMode)Mockito.never())).indexDoUpdateEntry((SchemaDescriptor)ArgumentMatchers.any(), (long)ArgumentMatchers.anyInt(), (ValueTuple)ArgumentMatchers.any(), (ValueTuple)ArgumentMatchers.any());
    }

    @Test
    void shouldUpdateIndexesOnAddedProperty() {
        this.indexTxUpdater.onPropertyAdd((NodeCursor)this.node, (PropertyCursor)this.propertyCursor, this.node.labels().all(), 23, PROPS, Values.of((Object)"newHi"));
        this.verifyIndexUpdate(this.indexOn2_new.schema(), this.node.nodeReference(), null, NodeIndexTxStateUpdaterTest.values("newHi"));
        this.verifyIndexUpdate(this.indexOn1_1_new.schema(), this.node.nodeReference(), null, NodeIndexTxStateUpdaterTest.values("hi1", "newHi"));
        ((TransactionState)Mockito.verify((Object)this.txState, (VerificationMode)Mockito.times((int)2))).indexDoUpdateEntry((SchemaDescriptor)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), (ValueTuple)ArgumentMatchers.isNull(), (ValueTuple)ArgumentMatchers.any());
    }

    @Test
    void shouldUpdateIndexesOnRemovedProperty() {
        this.indexTxUpdater.onPropertyRemove((NodeCursor)this.node, (PropertyCursor)this.propertyCursor, this.node.labels().all(), 21, PROPS, Values.of((Object)"hi2"));
        this.verifyIndexUpdate(this.uniqueOn1_2.schema(), this.node.nodeReference(), NodeIndexTxStateUpdaterTest.values("hi2"), null);
        this.verifyIndexUpdate(this.uniqueOn2_2_3.schema(), this.node.nodeReference(), NodeIndexTxStateUpdaterTest.values("hi2", "hi3"), null);
        ((TransactionState)Mockito.verify((Object)this.txState, (VerificationMode)Mockito.times((int)2))).indexDoUpdateEntry((SchemaDescriptor)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), (ValueTuple)ArgumentMatchers.any(), (ValueTuple)ArgumentMatchers.isNull());
    }

    @Test
    void shouldUpdateIndexesOnChangedProperty() {
        this.indexTxUpdater.onPropertyChange((NodeCursor)this.node, (PropertyCursor)this.propertyCursor, this.node.labels().all(), 21, PROPS, Values.of((Object)"hi2"), Values.of((Object)"new2"));
        this.verifyIndexUpdate(this.uniqueOn1_2.schema(), this.node.nodeReference(), NodeIndexTxStateUpdaterTest.values("hi2"), NodeIndexTxStateUpdaterTest.values("new2"));
        this.verifyIndexUpdate(this.uniqueOn2_2_3.schema(), this.node.nodeReference(), NodeIndexTxStateUpdaterTest.values("hi2", "hi3"), NodeIndexTxStateUpdaterTest.values("new2", "hi3"));
        ((TransactionState)Mockito.verify((Object)this.txState, (VerificationMode)Mockito.times((int)2))).indexDoUpdateEntry((SchemaDescriptor)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), (ValueTuple)ArgumentMatchers.any(), (ValueTuple)ArgumentMatchers.any());
    }
}

