/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import java.nio.file.Path;
import java.time.Clock;
import java.util.Collections;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.internal.kernel.api.security.AuthSubject;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.api.TestCommand;
import org.neo4j.kernel.impl.api.TestCommandReaderFactory;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.transaction.SimpleLogVersionRepository;
import org.neo4j.kernel.impl.transaction.SimpleTransactionIdStore;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.BatchingTransactionAppender;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.TransactionMetadataCache;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeaderReader;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.impl.transaction.log.rotation.FileLogRotation;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotation;
import org.neo4j.kernel.impl.transaction.log.rotation.monitor.LogRotationMonitor;
import org.neo4j.kernel.impl.transaction.tracing.LogAppendEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogForceEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogForceWaitEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogRotateEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogRotateEvents;
import org.neo4j.kernel.impl.transaction.tracing.SerializeTransactionEvent;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.monitoring.DatabaseHealth;
import org.neo4j.monitoring.Health;
import org.neo4j.monitoring.Monitors;
import org.neo4j.monitoring.PanicEventGenerator;
import org.neo4j.storageengine.api.CommandReaderFactory;
import org.neo4j.storageengine.api.LogVersionRepository;
import org.neo4j.storageengine.api.StorageCommand;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.LifeExtension;
import org.neo4j.test.extension.Neo4jLayoutExtension;

@Neo4jLayoutExtension
@ExtendWith(value={LifeExtension.class})
class BatchingTransactionAppenderRotationIT {
    @Inject
    private DatabaseLayout layout;
    @Inject
    private FileSystemAbstraction fileSystem;
    @Inject
    private LifeSupport life;
    private final SimpleLogVersionRepository logVersionRepository = new SimpleLogVersionRepository();
    private final SimpleTransactionIdStore transactionIdStore = new SimpleTransactionIdStore();
    private final Monitors monitors = new Monitors();

    BatchingTransactionAppenderRotationIT() {
    }

    @Test
    void correctLastAppliedToPreviousLogTransactionInHeaderOnLogFileRotation() throws IOException {
        LogFiles logFiles = this.getLogFiles(this.logVersionRepository, this.transactionIdStore);
        this.life.add((Lifecycle)logFiles);
        Health databaseHealth = BatchingTransactionAppenderRotationIT.getDatabaseHealth();
        LogRotation logRotation = FileLogRotation.transactionLogRotation((LogFiles)logFiles, (Clock)Clock.systemUTC(), (Health)databaseHealth, (LogRotationMonitor)((LogRotationMonitor)this.monitors.newMonitor(LogRotationMonitor.class, new String[0])));
        TransactionMetadataCache transactionMetadataCache = new TransactionMetadataCache();
        BatchingTransactionAppender transactionAppender = new BatchingTransactionAppender(logFiles, logRotation, transactionMetadataCache, (TransactionIdStore)this.transactionIdStore, databaseHealth);
        this.life.add((Lifecycle)transactionAppender);
        RotationLogAppendEvent logAppendEvent = new RotationLogAppendEvent(logRotation);
        TransactionToApply transactionToApply = BatchingTransactionAppenderRotationIT.prepareTransaction();
        transactionAppender.append(transactionToApply, (LogAppendEvent)logAppendEvent);
        LogFile logFile = logFiles.getLogFile();
        Assertions.assertEquals((long)1L, (long)logFile.getHighestLogVersion());
        Path highestLogFile = logFile.getHighestLogFile();
        LogHeader logHeader = LogHeaderReader.readLogHeader((FileSystemAbstraction)this.fileSystem, (Path)highestLogFile, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        Assertions.assertEquals((long)2L, (long)logHeader.getLastCommittedTxId());
    }

    private static TransactionToApply prepareTransaction() {
        List<StorageCommand> commands = BatchingTransactionAppenderRotationIT.createCommands();
        PhysicalTransactionRepresentation transactionRepresentation = new PhysicalTransactionRepresentation(commands);
        transactionRepresentation.setHeader(new byte[0], 0L, 0L, 0L, 0, AuthSubject.ANONYMOUS);
        return new TransactionToApply((TransactionRepresentation)transactionRepresentation, CursorContext.NULL);
    }

    private static List<StorageCommand> createCommands() {
        return Collections.singletonList(new TestCommand());
    }

    private LogFiles getLogFiles(SimpleLogVersionRepository logVersionRepository, SimpleTransactionIdStore transactionIdStore) throws IOException {
        return LogFilesBuilder.builder((DatabaseLayout)this.layout, (FileSystemAbstraction)this.fileSystem).withRotationThreshold(ByteUnit.mebiBytes((long)1L)).withLogVersionRepository((LogVersionRepository)logVersionRepository).withTransactionIdStore((TransactionIdStore)transactionIdStore).withLogEntryReader((LogEntryReader)new VersionAwareLogEntryReader((CommandReaderFactory)new TestCommandReaderFactory())).withStoreId(StoreId.UNKNOWN).build();
    }

    private static Health getDatabaseHealth() {
        return new DatabaseHealth(PanicEventGenerator.NO_OP, (Log)NullLog.getInstance());
    }

    private static class RotationLogAppendEvent
    implements LogAppendEvent {
        private final LogRotation logRotation;

        RotationLogAppendEvent(LogRotation logRotation) {
            this.logRotation = logRotation;
        }

        public LogForceWaitEvent beginLogForceWait() {
            return null;
        }

        public LogForceEvent beginLogForce() {
            return null;
        }

        public void appendToLogFile(LogPosition logPositionBeforeAppend, LogPosition logPositionAfterAppend) {
        }

        public void close() {
        }

        public void setLogRotated(boolean logRotated) {
        }

        public LogRotateEvent beginLogRotate() {
            return null;
        }

        public SerializeTransactionEvent beginSerializeTransaction() {
            return () -> {
                try {
                    this.logRotation.rotateLogFile((LogRotateEvents)LogAppendEvent.NULL);
                }
                catch (IOException e) {
                    throw new RuntimeException("Should be able to rotate file", e);
                }
            };
        }
    }
}

