/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.files;

import java.io.IOException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.kernel.impl.transaction.log.LogHeaderCache;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChecksumChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFile;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFileInformation;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFiles;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFilesContext;

class TransactionLogFileInformationTest {
    private final LogFiles logFiles = (LogFiles)Mockito.mock(TransactionLogFiles.class);
    private final LogFile logFile = (LogFile)Mockito.mock(TransactionLogFile.class);
    private final LogHeaderCache logHeaderCache = (LogHeaderCache)Mockito.mock(LogHeaderCache.class);
    private final TransactionLogFilesContext context = (TransactionLogFilesContext)Mockito.mock(TransactionLogFilesContext.class);

    TransactionLogFileInformationTest() {
    }

    @BeforeEach
    void setUp() {
        Mockito.when((Object)this.logFiles.getLogFile()).thenReturn((Object)this.logFile);
    }

    @Test
    void shouldReadAndCacheFirstCommittedTransactionIdForAGivenVersionWhenNotCached() throws Exception {
        TransactionLogFileInformation info = new TransactionLogFileInformation(this.logFiles, this.logHeaderCache, this.context);
        long expected = 5L;
        long version = 10L;
        Mockito.when((Object)this.logHeaderCache.getLogHeader(version)).thenReturn(null);
        Mockito.when((Object)this.logFiles.getLogFile().versionExists(version)).thenReturn((Object)true);
        LogHeader expectedHeader = new LogHeader(-1, -1L, expected - 1L, 64L);
        Mockito.when((Object)this.logFiles.getLogFile().extractHeader(version)).thenReturn((Object)expectedHeader);
        long firstCommittedTxId = info.getFirstEntryId(version);
        Assertions.assertEquals((long)expected, (long)firstCommittedTxId);
        ((LogHeaderCache)Mockito.verify((Object)this.logHeaderCache)).putHeader(version, expectedHeader);
    }

    @Test
    void shouldReadFirstCommittedTransactionIdForAGivenVersionWhenCached() throws Exception {
        TransactionLogFileInformation info = new TransactionLogFileInformation(this.logFiles, this.logHeaderCache, this.context);
        long expected = 5L;
        long version = 10L;
        LogHeader expectedHeader = new LogHeader(-1, -1L, expected - 1L, 64L);
        Mockito.when((Object)this.logHeaderCache.getLogHeader(version)).thenReturn((Object)expectedHeader);
        long firstCommittedTxId = info.getFirstEntryId(version);
        Assertions.assertEquals((long)expected, (long)firstCommittedTxId);
    }

    @Test
    void shouldReadAndCacheFirstCommittedTransactionIdWhenNotCached() throws Exception {
        TransactionLogFileInformation info = new TransactionLogFileInformation(this.logFiles, this.logHeaderCache, this.context);
        long expected = 5L;
        long version = 10L;
        Mockito.when((Object)this.logFile.getHighestLogVersion()).thenReturn((Object)version);
        Mockito.when((Object)this.logHeaderCache.getLogHeader(version)).thenReturn(null);
        Mockito.when((Object)this.logFile.versionExists(version)).thenReturn((Object)true);
        LogHeader expectedHeader = new LogHeader(-1, -1L, expected - 1L, 64L);
        Mockito.when((Object)this.logFile.extractHeader(version)).thenReturn((Object)expectedHeader);
        Mockito.when((Object)this.logFile.hasAnyEntries(version)).thenReturn((Object)true);
        long firstCommittedTxId = info.getFirstExistingEntryId();
        Assertions.assertEquals((long)expected, (long)firstCommittedTxId);
        ((LogHeaderCache)Mockito.verify((Object)this.logHeaderCache)).putHeader(version, expectedHeader);
    }

    @Test
    void shouldReadFirstCommittedTransactionIdWhenCached() throws Exception {
        TransactionLogFileInformation info = new TransactionLogFileInformation(this.logFiles, this.logHeaderCache, this.context);
        long expected = 5L;
        long version = 10L;
        Mockito.when((Object)this.logFile.getHighestLogVersion()).thenReturn((Object)version);
        Mockito.when((Object)this.logFile.versionExists(version)).thenReturn((Object)true);
        LogHeader expectedHeader = new LogHeader(-1, -1L, expected - 1L, 64L);
        Mockito.when((Object)this.logHeaderCache.getLogHeader(version)).thenReturn((Object)expectedHeader);
        Mockito.when((Object)this.logFile.hasAnyEntries(version)).thenReturn((Object)true);
        long firstCommittedTxId = info.getFirstExistingEntryId();
        Assertions.assertEquals((long)expected, (long)firstCommittedTxId);
    }

    @Test
    void shouldReturnNothingWhenThereAreNoTransactions() throws Exception {
        TransactionLogFileInformation info = new TransactionLogFileInformation(this.logFiles, this.logHeaderCache, this.context);
        long version = 10L;
        Mockito.when((Object)this.logFile.getHighestLogVersion()).thenReturn((Object)version);
        Mockito.when((Object)this.logFile.hasAnyEntries(version)).thenReturn((Object)false);
        long firstCommittedTxId = info.getFirstExistingEntryId();
        Assertions.assertEquals((long)-1L, (long)firstCommittedTxId);
    }

    @Test
    void doNotReadAgainPreviouslyObservedLogTransactionTime() throws IOException {
        LogEntryReader logEntryReader = (LogEntryReader)Mockito.mock(LogEntryReader.class);
        ReadableLogChannel readableLogChannel = (ReadableLogChannel)Mockito.mock(ReadableLogChannel.class);
        Mockito.when((Object)logEntryReader.readLogEntry((ReadableClosablePositionAwareChecksumChannel)readableLogChannel)).thenReturn((Object)new LogEntryStart(1L, 1L, 1, new byte[0], LogPosition.UNSPECIFIED));
        Mockito.when((Object)this.context.getLogEntryReader()).thenReturn((Object)logEntryReader);
        TransactionLogFileInformation fileInfo = new TransactionLogFileInformation(this.logFiles, this.logHeaderCache, this.context);
        LogHeader expectedHeader = new LogHeader(1, 2L, 3L, 4L);
        Mockito.when((Object)this.logFile.extractHeader(ArgumentMatchers.anyLong())).thenReturn((Object)expectedHeader);
        Mockito.when((Object)this.logFile.getRawReader((LogPosition)ArgumentMatchers.any())).thenReturn((Object)readableLogChannel);
        fileInfo.getFirstStartRecordTimestamp(1L);
        fileInfo.getFirstStartRecordTimestamp(1L);
        fileInfo.getFirstStartRecordTimestamp(1L);
        fileInfo.getFirstStartRecordTimestamp(1L);
        fileInfo.getFirstStartRecordTimestamp(1L);
        ((LogFile)Mockito.verify((Object)this.logFile, (VerificationMode)Mockito.times((int)1))).getRawReader((LogPosition)ArgumentMatchers.any());
    }
}

