/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state.storeview;

import java.util.function.IntPredicate;
import java.util.function.Supplier;
import org.assertj.core.api.Assertions;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.impl.factory.primitive.LongLists;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.common.EntityType;
import org.neo4j.configuration.Config;
import org.neo4j.function.Predicates;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.PropertyScanConsumer;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.api.index.TokenScanConsumer;
import org.neo4j.kernel.impl.index.schema.TokenIndexProvider;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.scheduler.JobSchedulerFactory;
import org.neo4j.kernel.impl.transaction.state.storeview.DynamicIndexStoreView;
import org.neo4j.kernel.impl.transaction.state.storeview.FullScanStoreView;
import org.neo4j.kernel.impl.transaction.state.storeview.StubTokenIndexReader;
import org.neo4j.kernel.impl.transaction.state.storeview.TestPropertyScanConsumer;
import org.neo4j.kernel.impl.transaction.state.storeview.TestTokenScanConsumer;
import org.neo4j.lock.LockService;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.StubStorageCursors;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;

class DynamicIndexStoreViewTest {
    private final JobScheduler jobScheduler = JobSchedulerFactory.createInitialisedScheduler();

    DynamicIndexStoreViewTest() {
    }

    @AfterEach
    void tearDown() throws Exception {
        this.jobScheduler.close();
    }

    @Test
    void shouldVisitNodesUsingTokenIndex() throws Exception {
        long[] nodeIds = new long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L};
        int[] indexedLabels = new int[]{2, 6};
        StubStorageCursors cursors = new StubStorageCursors().withTokenIndexes();
        IndexProxy indexProxy = (IndexProxy)Mockito.mock(IndexProxy.class);
        IndexingService.IndexProxyProvider indexProxies = (IndexingService.IndexProxyProvider)Mockito.mock(IndexingService.IndexProxyProvider.class);
        StubTokenIndexReader tokenReader = new StubTokenIndexReader();
        IndexDescriptor descriptor = IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptor.forAnyEntityTokens((EntityType)EntityType.NODE), (IndexProviderDescriptor)TokenIndexProvider.DESCRIPTOR).withName("index").materialise(0L);
        Mockito.when((Object)indexProxy.getState()).thenReturn((Object)InternalIndexState.ONLINE);
        Mockito.when((Object)indexProxy.newTokenReader()).thenReturn((Object)tokenReader);
        Mockito.when((Object)indexProxy.getDescriptor()).thenReturn((Object)descriptor);
        Mockito.when((Object)indexProxies.getIndexProxy((IndexDescriptor)ArgumentMatchers.any())).thenReturn((Object)indexProxy);
        for (long nodeId : nodeIds) {
            ((StubStorageCursors.NodeData)cursors.withNode(nodeId).propertyId(1L)).relationship(1L).labels(2L, 6L);
            tokenReader.index(indexedLabels, nodeId);
        }
        cursors.withNode(9L).labels(5L);
        cursors.withNode(10L).labels(6L);
        DynamicIndexStoreView storeView = this.dynamicIndexStoreView(cursors, indexProxies);
        TestTokenScanConsumer consumer = new TestTokenScanConsumer();
        StoreScan storeScan = storeView.visitNodes(indexedLabels, Predicates.ALWAYS_TRUE_INT, (PropertyScanConsumer)new TestPropertyScanConsumer(), (TokenScanConsumer)consumer, false, true, PageCacheTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        storeScan.run(StoreScan.NO_EXTERNAL_UPDATES);
        Assertions.assertThat((int)consumer.batches.size()).isEqualTo(1);
        Assertions.assertThat((int)consumer.batches.get(0).size()).isEqualTo(nodeIds.length);
    }

    @Test
    void shouldVisitRelationshipsUsingTokenIndex() throws Throwable {
        StubTokenIndexReader tokenReader = new StubTokenIndexReader();
        StubStorageCursors cursors = new StubStorageCursors().withTokenIndexes();
        IndexProxy indexProxy = (IndexProxy)Mockito.mock(IndexProxy.class);
        IndexingService.IndexProxyProvider indexProxies = (IndexingService.IndexProxyProvider)Mockito.mock(IndexingService.IndexProxyProvider.class);
        IndexDescriptor descriptor = IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptor.forAnyEntityTokens((EntityType)EntityType.RELATIONSHIP), (IndexProviderDescriptor)TokenIndexProvider.DESCRIPTOR).withName("index").materialise(0L);
        Mockito.when((Object)indexProxy.getState()).thenReturn((Object)InternalIndexState.ONLINE);
        Mockito.when((Object)indexProxy.getDescriptor()).thenReturn((Object)descriptor);
        Mockito.when((Object)indexProxy.newTokenReader()).thenReturn((Object)tokenReader);
        Mockito.when((Object)indexProxies.getIndexProxy((IndexDescriptor)ArgumentMatchers.any())).thenReturn((Object)indexProxy);
        int targetType = 1;
        int notTargetType = 2;
        int[] indexedTypes = new int[]{targetType};
        String targetPropertyKey = "key";
        String notTargetPropertyKey = "not-key";
        TextValue propertyValue = Values.stringValue((String)"value");
        MutableLongList relationshipsWithTargetType = LongLists.mutable.empty();
        long id = 0L;
        int wantedPropertyUpdates = 5;
        for (int i = 0; i < wantedPropertyUpdates; ++i) {
            cursors.withRelationship(id, 1L, targetType, 3L).properties(new Object[]{targetPropertyKey, propertyValue});
            tokenReader.index(indexedTypes, id);
            relationshipsWithTargetType.add(id++);
            cursors.withRelationship(id++, 1L, targetType, 3L).properties(new Object[]{notTargetPropertyKey, propertyValue});
            cursors.withRelationship(id++, 1L, notTargetType, 3L).properties(new Object[]{targetPropertyKey, propertyValue});
        }
        DynamicIndexStoreView storeView = this.dynamicIndexStoreView(cursors, indexProxies);
        TestTokenScanConsumer tokenConsumer = new TestTokenScanConsumer();
        TestPropertyScanConsumer propertyScanConsumer = new TestPropertyScanConsumer();
        StoreScan storeScan = storeView.visitRelationships(indexedTypes, relationType -> true, (PropertyScanConsumer)propertyScanConsumer, (TokenScanConsumer)tokenConsumer, false, true, PageCacheTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        storeScan.run(StoreScan.NO_EXTERNAL_UPDATES);
        Assertions.assertThat((int)propertyScanConsumer.batches.size()).isEqualTo(1);
        Assertions.assertThat((int)propertyScanConsumer.batches.get(0).size()).isEqualTo(wantedPropertyUpdates);
        Assertions.assertThat((int)tokenConsumer.batches.size()).isEqualTo(1);
        Assertions.assertThat((int)tokenConsumer.batches.get(0).size()).isEqualTo(relationshipsWithTargetType.size());
    }

    @Test
    void shouldVisitAllNodesWithoutTokenIndexes() {
        long[] nodeIds = new long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L};
        int[] indexedLabels = new int[]{2, 6};
        StubStorageCursors cursors = new StubStorageCursors().withoutTokenIndexes();
        IndexingService.IndexProxyProvider indexProxies = (IndexingService.IndexProxyProvider)Mockito.mock(IndexingService.IndexProxyProvider.class);
        for (long nodeId : nodeIds) {
            ((StubStorageCursors.NodeData)cursors.withNode(nodeId).propertyId(1L)).relationship(1L).labels(2L, 6L);
        }
        cursors.withNode(9L).labels(5L);
        cursors.withNode(10L).labels(6L);
        DynamicIndexStoreView storeView = this.dynamicIndexStoreView(cursors, indexProxies);
        TestTokenScanConsumer consumer = new TestTokenScanConsumer();
        StoreScan storeScan = storeView.visitNodes(indexedLabels, Predicates.ALWAYS_TRUE_INT, (PropertyScanConsumer)new TestPropertyScanConsumer(), (TokenScanConsumer)consumer, false, true, PageCacheTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        storeScan.run(StoreScan.NO_EXTERNAL_UPDATES);
        Assertions.assertThat((int)consumer.batches.size()).isEqualTo(1);
        Assertions.assertThat((int)consumer.batches.get(0).size()).isEqualTo(nodeIds.length + 2);
    }

    @Test
    void shouldVisitAllRelationshipsWithoutTokenIndexes() {
        StubStorageCursors cursors = new StubStorageCursors().withoutTokenIndexes();
        IndexingService.IndexProxyProvider indexProxies = (IndexingService.IndexProxyProvider)Mockito.mock(IndexingService.IndexProxyProvider.class);
        int targetType = 1;
        int notTargetType = 2;
        int[] targetTypeArray = new int[]{targetType};
        String targetPropertyKey = "key";
        TextValue propertyValue = Values.stringValue((String)"value");
        MutableLongList relationshipsWithTargetType = LongLists.mutable.empty();
        long id = 0L;
        int wantedPropertyUpdates = 5;
        for (int i = 0; i < wantedPropertyUpdates; ++i) {
            cursors.withRelationship(id, 1L, targetType, 3L).properties(new Object[]{targetPropertyKey, propertyValue});
            relationshipsWithTargetType.add(id++);
            cursors.withRelationship(id, 1L, notTargetType, 3L).properties(new Object[]{targetPropertyKey, propertyValue});
            relationshipsWithTargetType.add(id++);
        }
        int targetPropertyKeyId = cursors.propertyKeyTokenHolder().getIdByName(targetPropertyKey);
        IntPredicate propertyKeyIdFilter = value -> value == targetPropertyKeyId;
        DynamicIndexStoreView storeView = this.dynamicIndexStoreView(cursors, indexProxies);
        TestTokenScanConsumer tokenConsumer = new TestTokenScanConsumer();
        TestPropertyScanConsumer propertyScanConsumer = new TestPropertyScanConsumer();
        StoreScan storeScan = storeView.visitRelationships(targetTypeArray, propertyKeyIdFilter, (PropertyScanConsumer)propertyScanConsumer, (TokenScanConsumer)tokenConsumer, false, true, PageCacheTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        storeScan.run(StoreScan.NO_EXTERNAL_UPDATES);
        Assertions.assertThat((int)tokenConsumer.batches.size()).isEqualTo(1);
        Assertions.assertThat((int)tokenConsumer.batches.get(0).size()).isEqualTo(relationshipsWithTargetType.size());
    }

    private DynamicIndexStoreView dynamicIndexStoreView(StorageReader cursors, IndexingService.IndexProxyProvider indexingService) {
        Supplier<StorageReader> storageReaderSupplier = () -> cursors;
        return this.dynamicIndexStoreView(cursors, indexingService, new FullScanStoreView(LockService.NO_LOCK_SERVICE, storageReaderSupplier, Config.defaults(), this.jobScheduler));
    }

    private DynamicIndexStoreView dynamicIndexStoreView(StorageReader cursors, IndexingService.IndexProxyProvider indexingService, FullScanStoreView fullScanStoreView) {
        Supplier<StorageReader> storageReaderSupplier = () -> cursors;
        return new DynamicIndexStoreView(fullScanStoreView, Locks.NO_LOCKS, LockService.NO_LOCK_SERVICE, Config.defaults(), indexingService, storageReaderSupplier, (LogProvider)NullLogProvider.getInstance());
    }
}

