/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.internal.event;

import java.util.UUID;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.graphdb.event.TransactionEventListener;
import org.neo4j.kernel.database.DatabaseIdFactory;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.internal.event.DatabaseTransactionEventListeners;
import org.neo4j.kernel.internal.event.GlobalTransactionEventListeners;

class DatabaseTransactionEventListenersTest {
    DatabaseTransactionEventListenersTest() {
    }

    @Test
    void shouldUnregisterRemainingListenerOnShutdown() {
        GlobalTransactionEventListeners globalListeners = (GlobalTransactionEventListeners)Mockito.mock(GlobalTransactionEventListeners.class);
        NamedDatabaseId databaseId = DatabaseIdFactory.from((String)"foo", (UUID)UUID.randomUUID());
        DatabaseTransactionEventListeners listeners = new DatabaseTransactionEventListeners((GraphDatabaseFacade)Mockito.mock(GraphDatabaseFacade.class), globalListeners, databaseId);
        TransactionEventListener firstListener = (TransactionEventListener)Mockito.mock(TransactionEventListener.class);
        TransactionEventListener secondListener = (TransactionEventListener)Mockito.mock(TransactionEventListener.class);
        listeners.registerTransactionEventListener(firstListener);
        listeners.registerTransactionEventListener(secondListener);
        ((GlobalTransactionEventListeners)Mockito.verify((Object)globalListeners)).registerTransactionEventListener(databaseId.name(), firstListener);
        ((GlobalTransactionEventListeners)Mockito.verify((Object)globalListeners)).registerTransactionEventListener(databaseId.name(), secondListener);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{globalListeners});
        listeners.unregisterTransactionEventListener(firstListener);
        ((GlobalTransactionEventListeners)Mockito.verify((Object)globalListeners)).unregisterTransactionEventListener(databaseId.name(), firstListener);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{globalListeners});
        listeners.shutdown();
        ((GlobalTransactionEventListeners)Mockito.verify((Object)globalListeners)).unregisterTransactionEventListener(databaseId.name(), secondListener);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{globalListeners});
    }
}

