/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Instant;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.mutable.MutableInt;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.common.ProgressReporter;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.dbms.database.DatabaseStartAbortedException;
import org.neo4j.internal.helpers.collection.Pair;
import org.neo4j.internal.helpers.collection.Visitor;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FlushableChannel;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.fs.WritableChecksumChannel;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.memory.HeapScopedBuffer;
import org.neo4j.io.memory.ScopedBuffer;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.database.DatabaseIdFactory;
import org.neo4j.kernel.database.DatabaseStartupController;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.SimpleLogVersionRepository;
import org.neo4j.kernel.impl.transaction.SimpleTransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.PositionAwarePhysicalFlushableChecksumChannel;
import org.neo4j.kernel.impl.transaction.log.TestLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.TransactionMetadataCache;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckpointAppender;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryWriter;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeaderWriter;
import org.neo4j.kernel.impl.transaction.log.files.ChannelNativeAccessor;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.CheckpointFile;
import org.neo4j.kernel.impl.transaction.tracing.LogCheckPointEvent;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.recovery.CorruptedLogsTruncator;
import org.neo4j.kernel.recovery.DefaultRecoveryService;
import org.neo4j.kernel.recovery.RecoveryApplier;
import org.neo4j.kernel.recovery.RecoveryMonitor;
import org.neo4j.kernel.recovery.RecoveryService;
import org.neo4j.kernel.recovery.RecoveryStartInformation;
import org.neo4j.kernel.recovery.RecoveryStartInformationProvider;
import org.neo4j.kernel.recovery.RecoveryStartupChecker;
import org.neo4j.kernel.recovery.TransactionLogsRecovery;
import org.neo4j.logging.Log;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.monitoring.Monitors;
import org.neo4j.storageengine.api.LogVersionRepository;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.TransactionApplicationMode;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;
import org.neo4j.test.rule.TestDirectory;

@Neo4jLayoutExtension
class TransactionLogsRecoveryTest {
    @Inject
    private DefaultFileSystemAbstraction fileSystem;
    @Inject
    private DatabaseLayout databaseLayout;
    @Inject
    private TestDirectory testDirectory;
    private final LogVersionRepository logVersionRepository = new SimpleLogVersionRepository();
    private final TransactionIdStore transactionIdStore = new SimpleTransactionIdStore(5L, 0, 0L, 0L, 0L);
    private final int logVersion = 0;
    private LogEntry lastCommittedTxStartEntry;
    private LogEntry lastCommittedTxCommitEntry;
    private LogEntry expectedStartEntry;
    private LogEntry expectedCommitEntry;
    private final Monitors monitors = new Monitors();
    private final SimpleLogVersionRepository versionRepository = new SimpleLogVersionRepository();
    private LogFiles logFiles;
    private Path storeDir;
    private Lifecycle schemaLife;
    private LifeSupport life;

    TransactionLogsRecoveryTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.storeDir = this.testDirectory.homePath();
        this.logFiles = LogFilesBuilder.builder((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem).withLogVersionRepository(this.logVersionRepository).withTransactionIdStore(this.transactionIdStore).withLogEntryReader(TestLogEntryReader.logEntryReader()).withStoreId(StoreId.UNKNOWN).withConfig(Config.newBuilder().set(GraphDatabaseInternalSettings.fail_on_corrupted_log_files, (Object)false).build()).build();
        this.life = new LifeSupport();
        this.life.add((Lifecycle)this.logFiles);
        this.life.start();
        this.schemaLife = new LifecycleAdapter();
    }

    @AfterEach
    void tearDown() {
        this.life.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldRecoverExistingData() throws Exception {
        LogFile logFile = this.logFiles.getLogFile();
        Path file = logFile.getLogFileForVersion(0L);
        this.writeSomeData(file, (Visitor<Pair<LogEntryWriter, Consumer<LogPositionMarker>>, IOException>)((Visitor)pair -> {
            LogEntryWriter writer = (LogEntryWriter)pair.first();
            Consumer consumer = (Consumer)pair.other();
            LogPositionMarker marker = new LogPositionMarker();
            int previousChecksum = -559063315;
            consumer.accept(marker);
            LogPosition lastCommittedTxPosition = marker.newPosition();
            writer.writeStartEntry(2L, 3L, previousChecksum, new byte[0]);
            this.lastCommittedTxStartEntry = new LogEntryStart(2L, 3L, previousChecksum, new byte[0], lastCommittedTxPosition);
            previousChecksum = writer.writeCommitEntry(4L, 5L);
            this.lastCommittedTxCommitEntry = new LogEntryCommit(4L, 5L, previousChecksum);
            CheckpointFile checkpointFile = this.logFiles.getCheckpointFile();
            CheckpointAppender checkpointAppender = checkpointFile.getCheckpointAppender();
            checkpointAppender.checkPoint(LogCheckPointEvent.NULL, lastCommittedTxPosition, Instant.now(), "test");
            consumer.accept(marker);
            writer.writeStartEntry(6L, 4L, previousChecksum, new byte[0]);
            this.expectedStartEntry = new LogEntryStart(6L, 4L, previousChecksum, new byte[0], marker.newPosition());
            previousChecksum = writer.writeCommitEntry(5L, 7L);
            this.expectedCommitEntry = new LogEntryCommit(5L, 7L, previousChecksum);
            return true;
        }));
        LifeSupport life = new LifeSupport();
        final AtomicBoolean recoveryRequired = new AtomicBoolean();
        final MutableInt recoveredTransactions = new MutableInt();
        RecoveryMonitor monitor = new RecoveryMonitor(){

            public void recoveryRequired(LogPosition recoveryPosition) {
                recoveryRequired.set(true);
            }

            public void recoveryCompleted(int numberOfRecoveredTransactions, long recoveryTimeInMilliseconds) {
                recoveredTransactions.setValue(numberOfRecoveredTransactions);
            }
        };
        try {
            StorageEngine storageEngine = (StorageEngine)Mockito.mock(StorageEngine.class);
            LogEntryReader reader = TestLogEntryReader.logEntryReader();
            TransactionMetadataCache metadataCache = new TransactionMetadataCache();
            PhysicalLogicalTransactionStore txStore = new PhysicalLogicalTransactionStore(this.logFiles, metadataCache, reader, this.monitors, false);
            CorruptedLogsTruncator logPruner = new CorruptedLogsTruncator(this.storeDir, this.logFiles, (FileSystemAbstraction)this.fileSystem, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            this.monitors.addMonitorListener((Object)monitor, new String[0]);
            life.add((Lifecycle)new TransactionLogsRecovery((RecoveryService)new DefaultRecoveryService(storageEngine, this.transactionIdStore, (LogicalTransactionStore)txStore, this.versionRepository, this.logFiles, RecoveryStartInformationProvider.NO_MONITOR, (Log)Mockito.mock(Log.class), false){
                private int nr;

                public RecoveryApplier getRecoveryApplier(TransactionApplicationMode mode, PageCacheTracer cacheTracer, String tracerTag) {
                    final RecoveryApplier actual = super.getRecoveryApplier(mode, cacheTracer, tracerTag);
                    if (mode == TransactionApplicationMode.REVERSE_RECOVERY) {
                        return actual;
                    }
                    return new RecoveryApplier(){

                        public void close() throws Exception {
                            actual.close();
                        }

                        public boolean visit(CommittedTransactionRepresentation tx) throws Exception {
                            actual.visit((Object)tx);
                            switch (nr++) {
                                case 0: {
                                    org.junit.jupiter.api.Assertions.assertEquals((Object)TransactionLogsRecoveryTest.this.lastCommittedTxStartEntry, (Object)tx.getStartEntry());
                                    org.junit.jupiter.api.Assertions.assertEquals((Object)TransactionLogsRecoveryTest.this.lastCommittedTxCommitEntry, (Object)tx.getCommitEntry());
                                    break;
                                }
                                case 1: {
                                    org.junit.jupiter.api.Assertions.assertEquals((Object)TransactionLogsRecoveryTest.this.expectedStartEntry, (Object)tx.getStartEntry());
                                    org.junit.jupiter.api.Assertions.assertEquals((Object)TransactionLogsRecoveryTest.this.expectedCommitEntry, (Object)tx.getCommitEntry());
                                    break;
                                }
                                default: {
                                    org.junit.jupiter.api.Assertions.fail((String)"Too many recovered transactions");
                                }
                            }
                            return false;
                        }
                    };
                }
            }, logPruner, this.schemaLife, monitor, ProgressReporter.SILENT, false, RecoveryStartupChecker.EMPTY_CHECKER, PageCacheTracer.NULL));
            life.start();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)recoveryRequired.get());
            org.junit.jupiter.api.Assertions.assertEquals((int)2, (Integer)recoveredTransactions.getValue());
        }
        finally {
            life.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest(name="{0}")
    @CsvSource(value={"separateCheckpoints,true", "legacyCheckpoints,false"})
    void shouldSeeThatACleanDatabaseShouldNotRequireRecovery(String name, boolean useSeparateLogFiles) throws Exception {
        Path file = this.logFiles.getLogFile().getLogFileForVersion(0L);
        LogPositionMarker marker = new LogPositionMarker();
        this.writeSomeDataWithVersion(file, (Visitor<Pair<LogEntryWriter, Consumer<LogPositionMarker>>, IOException>)((Visitor)pair -> {
            LogEntryWriter writer = (LogEntryWriter)pair.first();
            Consumer consumer = (Consumer)pair.other();
            consumer.accept(marker);
            writer.writeStartEntry(2L, 3L, -559063315, new byte[0]);
            writer.writeCommitEntry(4L, 5L);
            consumer.accept(marker);
            if (useSeparateLogFiles) {
                CheckpointFile checkpointFile = this.logFiles.getCheckpointFile();
                CheckpointAppender checkpointAppender = checkpointFile.getCheckpointAppender();
                checkpointAppender.checkPoint(LogCheckPointEvent.NULL, marker.newPosition(), Instant.now(), "test");
            } else {
                writer.writeLegacyCheckPointEntry(marker.newPosition());
            }
            return true;
        }), useSeparateLogFiles ? KernelVersion.LATEST : KernelVersion.V4_0);
        LifeSupport life = new LifeSupport();
        RecoveryMonitor monitor = (RecoveryMonitor)Mockito.mock(RecoveryMonitor.class);
        try {
            StorageEngine storageEngine = (StorageEngine)Mockito.mock(StorageEngine.class);
            LogEntryReader reader = TestLogEntryReader.logEntryReader();
            TransactionMetadataCache metadataCache = new TransactionMetadataCache();
            PhysicalLogicalTransactionStore txStore = new PhysicalLogicalTransactionStore(this.logFiles, metadataCache, reader, this.monitors, false);
            CorruptedLogsTruncator logPruner = new CorruptedLogsTruncator(this.storeDir, this.logFiles, (FileSystemAbstraction)this.fileSystem, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            this.monitors.addMonitorListener((Object)new RecoveryMonitor(){

                public void recoveryRequired(LogPosition recoveryPosition) {
                    org.junit.jupiter.api.Assertions.fail((String)"Recovery should not be required");
                }
            }, new String[0]);
            life.add((Lifecycle)new TransactionLogsRecovery((RecoveryService)new DefaultRecoveryService(storageEngine, this.transactionIdStore, (LogicalTransactionStore)txStore, (LogVersionRepository)this.versionRepository, this.logFiles, RecoveryStartInformationProvider.NO_MONITOR, (Log)Mockito.mock(Log.class), false), logPruner, this.schemaLife, monitor, ProgressReporter.SILENT, false, RecoveryStartupChecker.EMPTY_CHECKER, PageCacheTracer.NULL));
            life.start();
            Mockito.verifyNoInteractions((Object[])new Object[]{monitor});
        }
        finally {
            life.shutdown();
        }
    }

    @Test
    void shouldTruncateLogAfterSinglePartialTransaction() throws Exception {
        Path file = this.logFiles.getLogFile().getLogFileForVersion(0L);
        LogPositionMarker marker = new LogPositionMarker();
        this.writeSomeData(file, (Visitor<Pair<LogEntryWriter, Consumer<LogPositionMarker>>, IOException>)((Visitor)pair -> {
            LogEntryWriter writer = (LogEntryWriter)pair.first();
            Consumer consumer = (Consumer)pair.other();
            consumer.accept(marker);
            writer.writeStartEntry(5L, 4L, 0, new byte[0]);
            return true;
        }));
        boolean recoveryRequired = this.recover(this.storeDir, this.logFiles);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)recoveryRequired);
        org.junit.jupiter.api.Assertions.assertEquals((long)marker.getByteOffset(), (long)Files.size(file));
    }

    @Test
    void doNotTruncateCheckpointsAfterLastTransaction() throws IOException {
        Path file = this.logFiles.getLogFile().getLogFileForVersion(0L);
        LogPositionMarker marker = new LogPositionMarker();
        this.writeSomeData(file, (Visitor<Pair<LogEntryWriter, Consumer<LogPositionMarker>>, IOException>)((Visitor)pair -> {
            LogEntryWriter writer = (LogEntryWriter)pair.first();
            writer.writeStartEntry(1L, 1L, -559063315, ArrayUtils.EMPTY_BYTE_ARRAY);
            writer.writeCommitEntry(1L, 2L);
            Consumer other = (Consumer)pair.other();
            other.accept(marker);
            CheckpointFile checkpointFile = this.logFiles.getCheckpointFile();
            CheckpointAppender checkpointAppender = checkpointFile.getCheckpointAppender();
            checkpointAppender.checkPoint(LogCheckPointEvent.NULL, marker.newPosition(), Instant.now(), "test");
            writer.writeStartEntry(5L, 4L, 0, new byte[0]);
            return true;
        }));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.recover(this.storeDir, this.logFiles));
        org.junit.jupiter.api.Assertions.assertEquals((long)marker.getByteOffset(), (long)Files.size(file));
        org.junit.jupiter.api.Assertions.assertEquals((long)256L, (long)Files.size(this.logFiles.getCheckpointFile().getCurrentFile()));
    }

    @Test
    void shouldTruncateInvalidCheckpointAndAllCorruptTransactions() throws IOException {
        Path file = this.logFiles.getLogFile().getLogFileForVersion(0L);
        LogPositionMarker marker = new LogPositionMarker();
        this.writeSomeData(file, (Visitor<Pair<LogEntryWriter, Consumer<LogPositionMarker>>, IOException>)((Visitor)pair -> {
            LogEntryWriter writer = (LogEntryWriter)pair.first();
            writer.writeStartEntry(1L, 1L, -559063315, ArrayUtils.EMPTY_BYTE_ARRAY);
            writer.writeCommitEntry(1L, 2L);
            Consumer other = (Consumer)pair.other();
            other.accept(marker);
            CheckpointFile checkpointFile = this.logFiles.getCheckpointFile();
            CheckpointAppender checkpointAppender = checkpointFile.getCheckpointAppender();
            checkpointAppender.checkPoint(LogCheckPointEvent.NULL, marker.newPosition(), Instant.now(), "valid checkpoint");
            checkpointAppender.checkPoint(LogCheckPointEvent.NULL, new LogPosition(marker.getLogVersion() + 1L, marker.getByteOffset()), Instant.now(), "invalid checkpoint");
            writer.writeStartEntry(5L, 4L, 0, new byte[0]);
            return true;
        }));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.recover(this.storeDir, this.logFiles));
        org.junit.jupiter.api.Assertions.assertEquals((long)marker.getByteOffset(), (long)Files.size(file));
        org.junit.jupiter.api.Assertions.assertEquals((long)256L, (long)Files.size(this.logFiles.getCheckpointFile().getCurrentFile()));
    }

    @Test
    void shouldTruncateLogAfterLastCompleteTransactionAfterSuccessfulRecovery() throws Exception {
        Path file = this.logFiles.getLogFile().getLogFileForVersion(0L);
        LogPositionMarker marker = new LogPositionMarker();
        this.writeSomeData(file, (Visitor<Pair<LogEntryWriter, Consumer<LogPositionMarker>>, IOException>)((Visitor)pair -> {
            LogEntryWriter writer = (LogEntryWriter)pair.first();
            Consumer consumer = (Consumer)pair.other();
            int previousChecksum = -559063315;
            writer.writeStartEntry(2L, 3L, previousChecksum, new byte[0]);
            previousChecksum = writer.writeCommitEntry(4L, 5L);
            consumer.accept(marker);
            writer.writeStartEntry(5L, 4L, previousChecksum, new byte[0]);
            return true;
        }));
        boolean recoveryRequired = this.recover(this.storeDir, this.logFiles);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)recoveryRequired);
        org.junit.jupiter.api.Assertions.assertEquals((long)marker.getByteOffset(), (long)Files.size(file));
    }

    @Test
    void shouldTellTransactionIdStoreAfterSuccessfulRecovery() throws Exception {
        Path file = this.logFiles.getLogFile().getLogFileForVersion(0L);
        LogPositionMarker marker = new LogPositionMarker();
        byte[] additionalHeaderData = new byte[]{};
        long transactionId = 4L;
        long commitTimestamp = 5L;
        this.writeSomeData(file, (Visitor<Pair<LogEntryWriter, Consumer<LogPositionMarker>>, IOException>)((Visitor)pair -> {
            LogEntryWriter writer = (LogEntryWriter)pair.first();
            Consumer consumer = (Consumer)pair.other();
            writer.writeStartEntry(2L, 3L, -559063315, additionalHeaderData);
            writer.writeCommitEntry(4L, 5L);
            consumer.accept(marker);
            return true;
        }));
        boolean recoveryRequired = this.recover(this.storeDir, this.logFiles);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)recoveryRequired);
        long[] lastClosedTransaction = this.transactionIdStore.getLastClosedTransaction();
        org.junit.jupiter.api.Assertions.assertEquals((long)4L, (long)lastClosedTransaction[0]);
        org.junit.jupiter.api.Assertions.assertEquals((long)5L, (long)this.transactionIdStore.getLastCommittedTransaction().commitTimestamp());
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)lastClosedTransaction[1]);
        org.junit.jupiter.api.Assertions.assertEquals((long)marker.getByteOffset(), (long)lastClosedTransaction[2]);
    }

    @Test
    void shouldInitSchemaLifeWhenRecoveryNotRequired() throws Exception {
        Lifecycle schemaLife = (Lifecycle)Mockito.mock(Lifecycle.class);
        RecoveryService recoveryService = (RecoveryService)Mockito.mock(RecoveryService.class);
        Mockito.when((Object)recoveryService.getRecoveryStartInformation()).thenReturn((Object)RecoveryStartInformation.NO_RECOVERY_REQUIRED);
        CorruptedLogsTruncator logPruner = new CorruptedLogsTruncator(this.storeDir, this.logFiles, (FileSystemAbstraction)this.fileSystem, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        RecoveryMonitor monitor = (RecoveryMonitor)Mockito.mock(RecoveryMonitor.class);
        TransactionLogsRecovery logsRecovery = new TransactionLogsRecovery(recoveryService, logPruner, schemaLife, monitor, ProgressReporter.SILENT, true, RecoveryStartupChecker.EMPTY_CHECKER, PageCacheTracer.NULL);
        logsRecovery.init();
        ((RecoveryMonitor)Mockito.verify((Object)monitor, (VerificationMode)Mockito.never())).recoveryRequired((LogPosition)ArgumentMatchers.any());
        ((Lifecycle)Mockito.verify((Object)schemaLife)).init();
    }

    @Test
    void shouldFailRecoveryWhenCanceled() throws Exception {
        Path file = this.logFiles.getLogFile().getLogFileForVersion(0L);
        LogPositionMarker marker = new LogPositionMarker();
        byte[] additionalHeaderData = new byte[]{};
        long transactionId = 4L;
        long commitTimestamp = 5L;
        this.writeSomeData(file, (Visitor<Pair<LogEntryWriter, Consumer<LogPositionMarker>>, IOException>)((Visitor)pair -> {
            LogEntryWriter writer = (LogEntryWriter)pair.first();
            Consumer consumer = (Consumer)pair.other();
            writer.writeStartEntry(2L, 3L, -559063315, additionalHeaderData);
            writer.writeCommitEntry(4L, 5L);
            consumer.accept(marker);
            return true;
        }));
        RecoveryMonitor monitor = (RecoveryMonitor)Mockito.mock(RecoveryMonitor.class);
        DatabaseStartupController startupController = (DatabaseStartupController)Mockito.mock(DatabaseStartupController.class);
        NamedDatabaseId databaseId = DatabaseIdFactory.from((String)"db", (UUID)UUID.randomUUID());
        Mockito.when((Object)startupController.shouldAbort(databaseId)).thenReturn((Object)false, (Object[])new Boolean[]{true});
        RecoveryStartupChecker recoveryStartupChecker = new RecoveryStartupChecker(startupController, databaseId);
        CorruptedLogsTruncator logsTruncator = (CorruptedLogsTruncator)Mockito.mock(CorruptedLogsTruncator.class);
        Exception exception = (Exception)org.junit.jupiter.api.Assertions.assertThrows(Exception.class, () -> this.recover(this.storeDir, this.logFiles, recoveryStartupChecker));
        Throwable rootCause = ExceptionUtils.getRootCause((Throwable)exception);
        Assertions.assertThat((Throwable)rootCause).isInstanceOf(DatabaseStartAbortedException.class);
        ((CorruptedLogsTruncator)Mockito.verify((Object)logsTruncator, (VerificationMode)Mockito.never())).truncate((LogPosition)ArgumentMatchers.any());
        ((RecoveryMonitor)Mockito.verify((Object)monitor, (VerificationMode)Mockito.never())).recoveryCompleted(ArgumentMatchers.anyInt(), ArgumentMatchers.anyLong());
    }

    private boolean recover(Path storeDir, LogFiles logFiles) {
        return this.recover(storeDir, logFiles, RecoveryStartupChecker.EMPTY_CHECKER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean recover(Path storeDir, LogFiles logFiles, RecoveryStartupChecker startupChecker) {
        LifeSupport life = new LifeSupport();
        final AtomicBoolean recoveryRequired = new AtomicBoolean();
        RecoveryMonitor monitor = new RecoveryMonitor(){

            public void recoveryRequired(LogPosition recoveryPosition) {
                recoveryRequired.set(true);
            }
        };
        try {
            StorageEngine storageEngine = (StorageEngine)Mockito.mock(StorageEngine.class);
            LogEntryReader reader = TestLogEntryReader.logEntryReader();
            TransactionMetadataCache metadataCache = new TransactionMetadataCache();
            PhysicalLogicalTransactionStore txStore = new PhysicalLogicalTransactionStore(logFiles, metadataCache, reader, this.monitors, false);
            CorruptedLogsTruncator logPruner = new CorruptedLogsTruncator(storeDir, logFiles, (FileSystemAbstraction)this.fileSystem, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            this.monitors.addMonitorListener((Object)monitor, new String[0]);
            life.add((Lifecycle)new TransactionLogsRecovery((RecoveryService)new DefaultRecoveryService(storageEngine, this.transactionIdStore, (LogicalTransactionStore)txStore, (LogVersionRepository)this.versionRepository, logFiles, RecoveryStartInformationProvider.NO_MONITOR, (Log)Mockito.mock(Log.class), false), logPruner, this.schemaLife, monitor, ProgressReporter.SILENT, false, startupChecker, PageCacheTracer.NULL));
            life.start();
        }
        finally {
            life.shutdown();
        }
        return recoveryRequired.get();
    }

    private void writeSomeData(Path file, Visitor<Pair<LogEntryWriter, Consumer<LogPositionMarker>>, IOException> visitor) throws IOException {
        this.writeSomeDataWithVersion(file, visitor, KernelVersion.LATEST);
    }

    private void writeSomeDataWithVersion(Path file, Visitor<Pair<LogEntryWriter, Consumer<LogPositionMarker>>, IOException> visitor, KernelVersion version) throws IOException {
        try (PhysicalLogVersionedStoreChannel versionedStoreChannel = new PhysicalLogVersionedStoreChannel((StoreChannel)this.fileSystem.write(file), 0L, 7, file, ChannelNativeAccessor.EMPTY_ACCESSOR);
             PositionAwarePhysicalFlushableChecksumChannel writableLogChannel = new PositionAwarePhysicalFlushableChecksumChannel((LogVersionedStoreChannel)versionedStoreChannel, (ScopedBuffer)new HeapScopedBuffer(1, ByteUnit.KibiByte, (MemoryTracker)EmptyMemoryTracker.INSTANCE));){
            LogHeaderWriter.writeLogHeader((FlushableChannel)writableLogChannel, (LogHeader)new LogHeader(0L, 2L, StoreId.UNKNOWN));
            writableLogChannel.beginChecksum();
            Consumer<LogPositionMarker> consumer = marker -> {
                try {
                    writableLogChannel.getCurrentPosition(marker);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            };
            LogEntryWriter first = new LogEntryWriter((WritableChecksumChannel)writableLogChannel, version);
            visitor.visit((Object)Pair.of((Object)first, consumer));
        }
    }
}

