/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.impl.notification;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.TreeSet;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.impl.notification.NotificationDetail;

class NotificationDetailTest {
    NotificationDetailTest() {
    }

    @Test
    void shouldConstructIndexDetails() {
        NotificationDetail detail = NotificationDetail.Factory.index((String)"Person", (String[])new String[]{"name"});
        Assertions.assertThat((String)detail.name()).isEqualTo("hinted index");
        Assertions.assertThat((String)detail.value()).isEqualTo("index on :Person(name)");
        Assertions.assertThat((String)detail.toString()).isEqualTo("hinted index is: index on :Person(name)");
    }

    @Test
    void shouldConstructSuboptimalIndexDetails() {
        NotificationDetail detail = NotificationDetail.Factory.suboptimalIndex((String)"Person", (String[])new String[]{"name"});
        Assertions.assertThat((String)detail.name()).isEqualTo("index");
        Assertions.assertThat((String)detail.value()).isEqualTo("index on :Person(name)");
        Assertions.assertThat((String)detail.toString()).isEqualTo("index is: index on :Person(name)");
    }

    @Test
    void shouldConstructCartesianProductDetailsSingular() {
        HashSet<String> idents = new HashSet<String>();
        idents.add("n");
        NotificationDetail detail = NotificationDetail.Factory.cartesianProduct(idents);
        Assertions.assertThat((String)detail.name()).isEqualTo("identifier");
        Assertions.assertThat((String)detail.value()).isEqualTo("(n)");
        Assertions.assertThat((String)detail.toString()).isEqualTo("identifier is: (n)");
    }

    @Test
    void shouldConstructCartesianProductDetails() {
        TreeSet<String> idents = new TreeSet<String>();
        idents.add("n");
        idents.add("node2");
        NotificationDetail detail = NotificationDetail.Factory.cartesianProduct(idents);
        Assertions.assertThat((String)detail.name()).isEqualTo("identifiers");
        Assertions.assertThat((String)detail.value()).isEqualTo("(n, node2)");
        Assertions.assertThat((String)detail.toString()).isEqualTo("identifiers are: (n, node2)");
    }

    @Test
    void shouldConstructJoinHintDetailsSingular() {
        ArrayList<String> idents = new ArrayList<String>();
        idents.add("n");
        NotificationDetail detail = NotificationDetail.Factory.joinKey(idents);
        Assertions.assertThat((String)detail.name()).isEqualTo("hinted join key identifier");
        Assertions.assertThat((String)detail.value()).isEqualTo("n");
        Assertions.assertThat((String)detail.toString()).isEqualTo("hinted join key identifier is: n");
    }

    @Test
    void shouldConstructJoinHintDetails() {
        ArrayList<String> idents = new ArrayList<String>();
        idents.add("n");
        idents.add("node2");
        NotificationDetail detail = NotificationDetail.Factory.joinKey(idents);
        Assertions.assertThat((String)detail.name()).isEqualTo("hinted join key identifiers");
        Assertions.assertThat((String)detail.value()).isEqualTo("n, node2");
        Assertions.assertThat((String)detail.toString()).isEqualTo("hinted join key identifiers are: n, node2");
    }
}

