/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.nio.charset.StandardCharsets;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mockito;
import org.neo4j.kernel.impl.index.schema.CompositeGenericKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.config.IndexSpecificSpaceFillingCurveSettings;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.values.storable.Values;

@ExtendWith(value={RandomExtension.class})
class CompositeGenericKeyTest {
    @Inject
    RandomRule random;

    CompositeGenericKeyTest() {
    }

    @Test
    void testDocumentedStringArrayKeySizeFormulaIsCorrect() {
        CompositeGenericKey key = new CompositeGenericKey(1, (IndexSpecificSpaceFillingCurveSettings)Mockito.mock(IndexSpecificSpaceFillingCurveSettings.class));
        int maxArrayLength = this.random.nextInt(500);
        int maxStringLength = this.random.nextInt(100);
        for (int i = 0; i < 100; ++i) {
            String[] strings = this.random.randomValues().nextStringArrayRaw(0, maxArrayLength, 0, maxStringLength);
            key.initialize((long)i);
            key.writeValue(0, Values.of((Object)strings), NativeIndexKey.Inclusion.NEUTRAL);
            Assertions.assertThat((int)CompositeGenericKeyTest.includingEntityId(CompositeGenericKeyTest.calculateKeySize(strings))).isEqualTo(key.size());
        }
    }

    private static int includingEntityId(int keySize) {
        return 8 + keySize;
    }

    private static int calculateKeySize(String[] strings) {
        int arrayLength = strings.length;
        int totalStringLength = 0;
        for (String string : strings) {
            totalStringLength += string.getBytes(StandardCharsets.UTF_8).length;
        }
        return 3 + 2 * arrayLength + totalStringLength;
    }
}

