/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.IntFunction;
import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.eclipse.collections.impl.map.mutable.primitive.IntObjectHashMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.common.EntityType;
import org.neo4j.index.internal.gbptree.Seeker;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.collection.Pair;
import org.neo4j.kernel.impl.index.schema.AllEntriesTokenScanReader;
import org.neo4j.kernel.impl.index.schema.EntityTokenRange;
import org.neo4j.kernel.impl.index.schema.NativeAllEntriesTokenScanReader;
import org.neo4j.kernel.impl.index.schema.TokenScanKey;
import org.neo4j.kernel.impl.index.schema.TokenScanValue;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.rule.RandomRule;

@ExtendWith(value={RandomExtension.class})
class NativeAllEntriesTokenScanReaderTest {
    @Inject
    private RandomRule random;
    static final Seeker<TokenScanKey, TokenScanValue> EMPTY_CURSOR = new Seeker<TokenScanKey, TokenScanValue>(){

        public boolean next() {
            return false;
        }

        public void close() {
        }

        public TokenScanKey key() {
            throw new IllegalStateException();
        }

        public TokenScanValue value() {
            throw new IllegalStateException();
        }
    };

    NativeAllEntriesTokenScanReaderTest() {
    }

    @Test
    void shouldSeeNonOverlappingRanges() throws Exception {
        int rangeSize = 4;
        NativeAllEntriesTokenScanReaderTest.shouldIterateCorrectlyOver(NativeAllEntriesTokenScanReaderTest.labels(0, rangeSize, 0L, 1L, 2L, 3L), NativeAllEntriesTokenScanReaderTest.labels(1, rangeSize, 4L, 6L), NativeAllEntriesTokenScanReaderTest.labels(2, rangeSize, 12L), NativeAllEntriesTokenScanReaderTest.labels(3, rangeSize, 17L, 18L));
    }

    @Test
    void shouldSeeOverlappingRanges() throws Exception {
        int rangeSize = 4;
        NativeAllEntriesTokenScanReaderTest.shouldIterateCorrectlyOver(NativeAllEntriesTokenScanReaderTest.labels(0, rangeSize, 0L, 1L, 3L, 55L), NativeAllEntriesTokenScanReaderTest.labels(3, rangeSize, 1L, 2L, 5L, 6L, 43L), NativeAllEntriesTokenScanReaderTest.labels(5, rangeSize, 8L, 9L, 15L, 42L), NativeAllEntriesTokenScanReaderTest.labels(6, rangeSize, 4L, 8L, 12L));
    }

    @Test
    void shouldSeeRangesFromRandomData() throws Exception {
        List<Labels> labels = NativeAllEntriesTokenScanReaderTest.randomData(this.random);
        NativeAllEntriesTokenScanReaderTest.shouldIterateCorrectlyOver(labels.toArray(new Labels[0]));
    }

    private static void shouldIterateCorrectlyOver(Labels ... data) throws Exception {
        try (NativeAllEntriesTokenScanReader reader = new NativeAllEntriesTokenScanReader(NativeAllEntriesTokenScanReaderTest.store(data), NativeAllEntriesTokenScanReaderTest.highestLabelId(data), EntityType.NODE);){
            NativeAllEntriesTokenScanReaderTest.assertRanges((AllEntriesTokenScanReader)reader, data);
        }
    }

    static List<Labels> randomData(RandomRule random) {
        ArrayList<Labels> labels = new ArrayList<Labels>();
        int labelCount = random.intBetween(30, 100);
        int labelId = 0;
        for (int i = 0; i < labelCount; ++i) {
            labelId += random.intBetween(1, 20);
            int nodeCount = random.intBetween(20, 100);
            long[] nodeIds = new long[nodeCount];
            long nodeId = 0L;
            for (int j = 0; j < nodeCount; ++j) {
                nodeIds[j] = nodeId += (long)random.intBetween(1, 100);
            }
            labels.add(NativeAllEntriesTokenScanReaderTest.labels(labelId, nodeIds));
        }
        return labels;
    }

    private static int highestLabelId(Labels[] data) {
        int highest = 0;
        for (Labels labels : data) {
            highest = Integer.max(highest, labels.labelId);
        }
        return highest;
    }

    private static void assertRanges(AllEntriesTokenScanReader reader, Labels[] data) {
        Iterator iterator = reader.iterator();
        long highestRangeId = NativeAllEntriesTokenScanReaderTest.highestRangeId(data);
        for (long rangeId = 0L; rangeId <= highestRangeId; ++rangeId) {
            SortedMap<Long, List<Long>> expected = NativeAllEntriesTokenScanReaderTest.rangeOf(data, rangeId);
            if (expected == null) continue;
            Assertions.assertTrue((boolean)iterator.hasNext(), (String)("Was expecting range " + expected));
            EntityTokenRange range = (EntityTokenRange)iterator.next();
            Assertions.assertEquals((long)rangeId, (long)range.id());
            for (Map.Entry<Long, List<Long>> expectedEntry : expected.entrySet()) {
                long[] labels = range.tokens(expectedEntry.getKey().longValue());
                Assertions.assertArrayEquals((long[])PrimitiveLongCollections.asArray(expectedEntry.getValue().iterator()), (long[])labels);
            }
        }
        Assertions.assertFalse((boolean)iterator.hasNext());
    }

    private static SortedMap<Long, List<Long>> rangeOf(Labels[] data, long rangeId) {
        TreeMap<Long, List<Long>> result = new TreeMap<Long, List<Long>>();
        for (Labels label : data) {
            for (Pair<TokenScanKey, TokenScanValue> entry : label.entries) {
                if (((TokenScanKey)entry.first()).idRange != rangeId) continue;
                long baseNodeId = ((TokenScanKey)entry.first()).idRange * 64L;
                for (long bits = ((TokenScanValue)entry.other()).bits; bits != 0L; bits &= bits - 1L) {
                    long nodeId = baseNodeId + (long)Long.numberOfTrailingZeros(bits);
                    result.computeIfAbsent(nodeId, id -> new ArrayList()).add(Long.valueOf(label.labelId));
                }
            }
        }
        return result.isEmpty() ? null : result;
    }

    private static long highestRangeId(Labels[] data) {
        long highest = 0L;
        for (Labels labels : data) {
            Pair<TokenScanKey, TokenScanValue> highestEntry = labels.entries.get(labels.entries.size() - 1);
            highest = Long.max(highest, ((TokenScanKey)highestEntry.first()).idRange);
        }
        return highest;
    }

    private static IntFunction<Seeker<TokenScanKey, TokenScanValue>> store(Labels ... labels) {
        IntObjectHashMap labelsMap = new IntObjectHashMap(labels.length);
        for (Labels item : labels) {
            labelsMap.put(item.labelId, (Object)item);
        }
        return arg_0 -> NativeAllEntriesTokenScanReaderTest.lambda$store$1((MutableIntObjectMap)labelsMap, arg_0);
    }

    static Labels labels(int labelId, long ... nodeIds) {
        ArrayList<Pair<TokenScanKey, TokenScanValue>> entries = new ArrayList<Pair<TokenScanKey, TokenScanValue>>();
        long currentRange = 0L;
        TokenScanValue value = new TokenScanValue();
        for (long nodeId : nodeIds) {
            long range = nodeId / 64L;
            if (range != currentRange && value.bits != 0L) {
                entries.add((Pair<TokenScanKey, TokenScanValue>)Pair.of((Object)new TokenScanKey().set(labelId, currentRange), (Object)value));
                value = new TokenScanValue();
            }
            value.set(Math.toIntExact(nodeId % 64L));
            currentRange = range;
        }
        if (value.bits != 0L) {
            entries.add((Pair<TokenScanKey, TokenScanValue>)Pair.of((Object)new TokenScanKey().set(labelId, currentRange), (Object)value));
        }
        return new Labels(labelId, entries, nodeIds);
    }

    private static /* synthetic */ Seeker lambda$store$1(MutableIntObjectMap labelsMap, int labelId) {
        Labels item = (Labels)labelsMap.get(labelId);
        return item != null ? item.cursor() : EMPTY_CURSOR;
    }

    static final class LabelsSeeker<TokenScanKey, TokenScanValue>
    implements Seeker<TokenScanKey, TokenScanValue> {
        int cursor = -1;
        private boolean closed;
        private final List<Pair<TokenScanKey, TokenScanValue>> entries;

        LabelsSeeker(List<Pair<TokenScanKey, TokenScanValue>> entries) {
            this.entries = entries;
        }

        public TokenScanKey key() {
            Assertions.assertFalse((boolean)this.closed);
            return (TokenScanKey)this.entries.get(this.cursor).first();
        }

        public TokenScanValue value() {
            Assertions.assertFalse((boolean)this.closed);
            return (TokenScanValue)this.entries.get(this.cursor).other();
        }

        public boolean next() {
            if (this.cursor + 1 >= this.entries.size()) {
                this.close();
                return false;
            }
            ++this.cursor;
            return true;
        }

        public void close() {
            this.closed = true;
        }
    }

    static class Labels {
        private final int labelId;
        private final List<Pair<TokenScanKey, TokenScanValue>> entries;
        private final long[] nodeIds;

        Labels(int labelId, List<Pair<TokenScanKey, TokenScanValue>> entries, long ... nodeIds) {
            this.labelId = labelId;
            this.entries = entries;
            this.nodeIds = nodeIds;
        }

        Seeker<TokenScanKey, TokenScanValue> cursor() {
            return new LabelsSeeker<TokenScanKey, TokenScanValue>(this.entries);
        }

        Seeker<TokenScanKey, TokenScanValue> descendingCursor() {
            return new LabelsSeeker<TokenScanKey, TokenScanValue>(Iterables.reverse(this.entries));
        }

        public long[] getNodeIds() {
            return this.nodeIds;
        }
    }
}

