/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.api.schema.index.TestIndexDescriptorFactory;
import org.neo4j.kernel.impl.newapi.SchemaMatcher;

abstract class SchemaMatcherTest {
    private static final int tokenId1 = 10;
    private static final int nonExistentTokenId = 12;
    private static final int propId1 = 20;
    private static final int propId2 = 21;
    private static final int unIndexedPropId = 22;
    private static final int nonExistentPropId = 23;
    private static final int specialPropId = 24;
    private static final int[] props = new int[]{20, 21, 22};
    private final IndexDescriptor index1 = this.index1();
    private final IndexDescriptor index1_2 = this.index1_2();
    private final IndexDescriptor indexWithMissingProperty = this.indexWithMissingProperty();
    private final IndexDescriptor indexWithMissingToken = this.indexWithMissingToken();
    private final IndexDescriptor indexOnSpecialProperty = this.indexOnSpecialProperty();

    SchemaMatcherTest() {
    }

    @Test
    void shouldMatchOnSingleProperty() {
        ArrayList matched = new ArrayList();
        SchemaMatcher.onMatchingSchema((Iterator)Iterators.iterator((Object)this.index1), (int)22, (int[])props, matched::add);
        Assertions.assertThat(matched).containsExactly((Object[])new IndexDescriptor[]{this.index1});
    }

    @Test
    void shouldMatchOnTwoProperties() {
        ArrayList matched = new ArrayList();
        SchemaMatcher.onMatchingSchema((Iterator)Iterators.iterator((Object)this.index1_2), (int)22, (int[])props, matched::add);
        Assertions.assertThat(matched).containsExactly((Object[])new IndexDescriptor[]{this.index1_2});
    }

    @Test
    void shouldNotMatchIfEntityIsMissingProperty() {
        ArrayList matched = new ArrayList();
        SchemaMatcher.onMatchingSchema((Iterator)Iterators.iterator((Object)this.indexWithMissingProperty), (int)22, (int[])props, matched::add);
        Assertions.assertThat(matched).isEmpty();
    }

    @Test
    void shouldMatchOnSpecialProperty() {
        ArrayList matched = new ArrayList();
        SchemaMatcher.onMatchingSchema((Iterator)Iterators.iterator((Object)this.indexOnSpecialProperty), (int)24, (int[])props, matched::add);
        Assertions.assertThat(matched).containsExactly((Object[])new IndexDescriptor[]{this.indexOnSpecialProperty});
    }

    @Test
    void shouldMatchSeveralTimes() {
        List<IndexDescriptor> indexes = Arrays.asList(this.index1, this.index1, this.index1_2, this.index1_2);
        ArrayList matched = new ArrayList();
        SchemaMatcher.onMatchingSchema(indexes.iterator(), (int)22, (int[])props, matched::add);
        Assertions.assertThat(matched).isEqualTo(indexes);
    }

    abstract IndexDescriptor index1();

    abstract IndexDescriptor index1_2();

    abstract IndexDescriptor indexWithMissingProperty();

    abstract IndexDescriptor indexWithMissingToken();

    abstract IndexDescriptor indexOnSpecialProperty();

    static class ForRelationship
    extends SchemaMatcherTest {
        ForRelationship() {
        }

        @Override
        IndexDescriptor index1() {
            return TestIndexDescriptorFactory.forRelType(10, 20);
        }

        @Override
        IndexDescriptor index1_2() {
            return TestIndexDescriptorFactory.forRelType(10, 20, 21);
        }

        @Override
        IndexDescriptor indexWithMissingProperty() {
            return TestIndexDescriptorFactory.forRelType(10, 20, 23);
        }

        @Override
        IndexDescriptor indexWithMissingToken() {
            return TestIndexDescriptorFactory.forRelType(12, 20, 21);
        }

        @Override
        IndexDescriptor indexOnSpecialProperty() {
            return TestIndexDescriptorFactory.forRelType(10, 20, 24);
        }
    }

    static class ForNode
    extends SchemaMatcherTest {
        ForNode() {
        }

        @Override
        IndexDescriptor index1() {
            return TestIndexDescriptorFactory.forLabel(10, 20);
        }

        @Override
        IndexDescriptor index1_2() {
            return TestIndexDescriptorFactory.forLabel(10, 20, 21);
        }

        @Override
        IndexDescriptor indexWithMissingProperty() {
            return TestIndexDescriptorFactory.forLabel(10, 20, 23);
        }

        @Override
        IndexDescriptor indexWithMissingToken() {
            return TestIndexDescriptorFactory.forLabel(12, 20, 21);
        }

        @Override
        IndexDescriptor indexOnSpecialProperty() {
            return TestIndexDescriptorFactory.forLabel(10, 20, 24);
        }
    }
}

