/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import java.io.IOException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.neo4j.io.fs.WritableChannel;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.api.TestCommand;
import org.neo4j.kernel.impl.api.TestCommandReaderFactory;
import org.neo4j.kernel.impl.transaction.log.InMemoryClosableChannel;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChecksumChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommand;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryInlinedCheckPoint;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.storageengine.api.CommandReaderFactory;
import org.neo4j.storageengine.api.StorageCommand;

class VersionAwareLogEntryReaderTest {
    private final LogEntryReader logEntryReader = new VersionAwareLogEntryReader((CommandReaderFactory)new TestCommandReaderFactory());

    VersionAwareLogEntryReaderTest() {
    }

    @Test
    void shouldReadAStartLogEntry() throws IOException {
        LogEntryStart start = new LogEntryStart(1L, 2L, -559063315, new byte[]{4}, new LogPosition(0L, 0L));
        InMemoryClosableChannel channel = new InMemoryClosableChannel(true);
        VersionAwareLogEntryReaderTest.writeStartEntry(channel, start);
        LogEntry logEntry = this.logEntryReader.readLogEntry((ReadableClosablePositionAwareChecksumChannel)channel);
        Assertions.assertEquals((Object)start, (Object)logEntry);
    }

    @Test
    void shouldReadACommitLogEntry() throws IOException {
        LogEntryCommit commit = new LogEntryCommit(42L, 21L, 1734331568);
        InMemoryClosableChannel channel = new InMemoryClosableChannel(true);
        VersionAwareLogEntryReaderTest.writeCommitEntry(channel, commit);
        LogEntry logEntry = this.logEntryReader.readLogEntry((ReadableClosablePositionAwareChecksumChannel)channel);
        Assertions.assertEquals((Object)commit, (Object)logEntry);
    }

    @Test
    void shouldReadACommandLogEntry() throws IOException {
        KernelVersion version = KernelVersion.LATEST;
        TestCommand testCommand = new TestCommand(new byte[]{100, 101, 102});
        LogEntryCommand command = new LogEntryCommand(version, (StorageCommand)testCommand);
        InMemoryClosableChannel channel = new InMemoryClosableChannel(true);
        channel.put(version.version());
        channel.put((byte)3);
        testCommand.serialize((WritableChannel)channel);
        LogEntry logEntry = this.logEntryReader.readLogEntry((ReadableClosablePositionAwareChecksumChannel)channel);
        Assertions.assertEquals((Object)command, (Object)logEntry);
    }

    @Test
    void shouldReadACheckPointLogEntry() throws IOException {
        LogEntryInlinedCheckPoint checkPoint = new LogEntryInlinedCheckPoint(new LogPosition(42L, 43L));
        InMemoryClosableChannel channel = new InMemoryClosableChannel(true);
        channel.put(checkPoint.getVersion().version());
        channel.put((byte)7);
        channel.putLong(checkPoint.getLogPosition().getLogVersion());
        channel.putLong(checkPoint.getLogPosition().getByteOffset());
        channel.putChecksum();
        LogEntry logEntry = this.logEntryReader.readLogEntry((ReadableClosablePositionAwareChecksumChannel)channel);
        Assertions.assertEquals((Object)checkPoint, (Object)logEntry);
    }

    @Test
    void shouldReturnNullWhenThereIsNoCommand() throws IOException {
        InMemoryClosableChannel channel = new InMemoryClosableChannel(true);
        channel.put(KernelVersion.LATEST.version());
        channel.put((byte)3);
        channel.put((byte)0);
        LogEntry logEntry = this.logEntryReader.readLogEntry((ReadableClosablePositionAwareChecksumChannel)channel);
        Assertions.assertNull((Object)logEntry);
    }

    @Test
    void shouldReturnNullWhenNotEnoughDataInTheChannel() throws IOException {
        InMemoryClosableChannel channel = new InMemoryClosableChannel(true);
        LogEntry logEntry = this.logEntryReader.readLogEntry((ReadableClosablePositionAwareChecksumChannel)channel);
        Assertions.assertNull((Object)logEntry);
    }

    @Disabled
    @Test
    void shouldValidateChecksumChain() throws IOException {
        InMemoryClosableChannel channel = new InMemoryClosableChannel(true);
        LogPosition startPosition = new LogPosition(0L, 174L);
        int checksum1 = 1021763356;
        LogEntryStart start1 = new LogEntryStart(1L, 2L, -559063315, new byte[]{4}, startPosition);
        LogEntryCommit commit1 = new LogEntryCommit(42L, 21L, checksum1);
        int checksum2 = 2120750830;
        LogEntryStart start2 = new LogEntryStart(35L, 30L, checksum1, new byte[]{5}, startPosition);
        LogEntryCommit commit2 = new LogEntryCommit(76L, 35L, checksum2);
        int checksum3 = -1462443939;
        LogEntryStart start3 = new LogEntryStart(58L, 80L, checksum2, new byte[]{6}, startPosition);
        LogEntryCommit commit3 = new LogEntryCommit(83L, 47L, checksum3);
        int notChecksum3 = checksum3 + 1;
        LogEntryStart start4 = new LogEntryStart(68L, 83L, notChecksum3, new byte[]{7}, startPosition);
        VersionAwareLogEntryReaderTest.writeStartEntry(channel, start1);
        VersionAwareLogEntryReaderTest.writeCommitEntry(channel, commit1);
        VersionAwareLogEntryReaderTest.writeStartEntry(channel, start2);
        VersionAwareLogEntryReaderTest.writeCommitEntry(channel, commit2);
        VersionAwareLogEntryReaderTest.writeStartEntry(channel, start3);
        VersionAwareLogEntryReaderTest.writeCommitEntry(channel, commit3);
        VersionAwareLogEntryReaderTest.writeStartEntry(channel, start4);
        Assertions.assertEquals((Object)start1, (Object)this.logEntryReader.readLogEntry((ReadableClosablePositionAwareChecksumChannel)channel));
        Assertions.assertEquals((Object)commit1, (Object)this.logEntryReader.readLogEntry((ReadableClosablePositionAwareChecksumChannel)channel));
        Assertions.assertEquals((Object)start2, (Object)this.logEntryReader.readLogEntry((ReadableClosablePositionAwareChecksumChannel)channel));
        Assertions.assertEquals((Object)commit2, (Object)this.logEntryReader.readLogEntry((ReadableClosablePositionAwareChecksumChannel)channel));
        Assertions.assertEquals((Object)start3, (Object)this.logEntryReader.readLogEntry((ReadableClosablePositionAwareChecksumChannel)channel));
        Assertions.assertEquals((Object)commit3, (Object)this.logEntryReader.readLogEntry((ReadableClosablePositionAwareChecksumChannel)channel));
        IllegalStateException e = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> this.logEntryReader.readLogEntry((ReadableClosablePositionAwareChecksumChannel)channel));
        Assertions.assertTrue((boolean)e.getMessage().contains("The checksum chain is broken"));
    }

    private static void writeStartEntry(InMemoryClosableChannel channel, LogEntryStart start) {
        channel.beginChecksum();
        channel.put(start.getVersion().version());
        channel.put((byte)1);
        channel.putLong(start.getTimeWritten());
        channel.putLong(start.getLastCommittedTxWhenTransactionStarted());
        channel.putInt(start.getPreviousChecksum());
        channel.putInt(start.getAdditionalHeader().length);
        channel.put(start.getAdditionalHeader(), start.getAdditionalHeader().length);
    }

    private static void writeCommitEntry(InMemoryClosableChannel channel, LogEntryCommit commit) {
        channel.put(commit.getVersion().version());
        channel.put((byte)5);
        channel.putLong(commit.getTxId());
        channel.putLong(commit.getTimeWritten());
        channel.putChecksum();
    }
}

