/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state.storeview;

import java.util.BitSet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.common.EntityType;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.batchimport.Configuration;
import org.neo4j.internal.batchimport.staging.BatchSender;
import org.neo4j.internal.batchimport.staging.ProcessorStep;
import org.neo4j.internal.batchimport.staging.Stage;
import org.neo4j.internal.batchimport.staging.StageControl;
import org.neo4j.internal.batchimport.staging.Step;
import org.neo4j.internal.batchimport.stats.StatsProvider;
import org.neo4j.internal.schema.AnyTokenSchemaDescriptor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.index.schema.DatabaseIndexContext;
import org.neo4j.kernel.impl.index.schema.IndexFiles;
import org.neo4j.kernel.impl.index.schema.TokenIndexAccessor;
import org.neo4j.kernel.impl.transaction.state.storeview.ReadEntityIdsStep;
import org.neo4j.kernel.impl.transaction.state.storeview.TokenIndexScanIdIterator;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.extension.pagecache.PageCacheExtension;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.test.rule.TestDirectory;

@ExtendWith(value={RandomExtension.class})
@PageCacheExtension
@Neo4jLayoutExtension
class ReadEntityIdsStepUsingTokenIndexTest {
    private static final int TOKEN_ID = 0;
    private static final AnyTokenSchemaDescriptor SCHEMA_DESCRIPTOR = SchemaDescriptor.forAnyEntityTokens((EntityType)EntityType.NODE);
    private static final IndexDescriptor INDEX_DESCRIPTOR = IndexPrototype.forSchema((SchemaDescriptor)SCHEMA_DESCRIPTOR).withName("index").materialise(1L);
    @Inject
    TestDirectory testDir;
    @Inject
    PageCache pageCache;
    @Inject
    private DatabaseLayout databaseLayout;
    @Inject
    private RandomRule random;

    ReadEntityIdsStepUsingTokenIndexTest() {
    }

    @Test
    void shouldSeeRecentUpdatesRightInFrontOfExternalUpdatesPoint() throws Exception {
        long entityCount = 1000 + this.random.nextInt(100);
        final BitSet expectedEntityIds = new BitSet();
        final BitSet seenEntityIds = new BitSet();
        try (final TokenIndexAccessor indexAccessor = this.indexAccessor();){
            this.populateTokenIndex(indexAccessor, expectedEntityIds, entityCount);
            final Configuration configuration = Configuration.withBatchSize((Configuration)Configuration.DEFAULT, (int)100);
            Stage stage = new Stage("Test", null, configuration, 0){
                {
                    super(name, part, config, orderingGuarantees);
                    this.add((Step)new ReadEntityIdsStep(this.control(), configuration, cursorContext -> new TokenIndexScanIdIterator(indexAccessor.newTokenReader(), new int[]{0}, CursorContext.NULL), PageCacheTracer.NULL, (StoreScan.ExternalUpdatesCheck)new ControlledUpdatesCheck(indexAccessor, expectedEntityIds), new AtomicBoolean(true)));
                    this.add((Step)new CollectEntityIdsStep(this.control(), configuration, seenEntityIds));
                }
            };
            stage.execute().awaitCompletion();
            Assertions.assertThat((Object)seenEntityIds).isEqualTo((Object)expectedEntityIds);
        }
    }

    private void populateTokenIndex(TokenIndexAccessor indexAccessor, BitSet entityIds, long count) throws Exception {
        try (IndexUpdater updater = indexAccessor.newUpdater(IndexUpdateMode.ONLINE, CursorContext.NULL);){
            long id = 0L;
            int i = 0;
            while ((long)i < count) {
                updater.process((IndexEntryUpdate)IndexEntryUpdate.change((long)id, (SchemaDescriptorSupplier)INDEX_DESCRIPTOR, (long[])PrimitiveLongCollections.EMPTY_LONG_ARRAY, (long[])new long[]{0L}));
                entityIds.set((int)id);
                id += (long)this.random.nextInt(1, 5);
                ++i;
            }
        }
    }

    private TokenIndexAccessor indexAccessor() {
        return new TokenIndexAccessor(DatabaseIndexContext.builder((PageCache)this.pageCache, (FileSystemAbstraction)this.testDir.getFileSystem(), (String)"neo4j").build(), this.databaseLayout, (IndexFiles)new IndexFiles.SingleFile(this.testDir.getFileSystem(), this.databaseLayout.labelScanStore()), this.config(), INDEX_DESCRIPTOR, RecoveryCleanupWorkCollector.immediate());
    }

    private Config config() {
        return Config.newBuilder().set(GraphDatabaseSettings.neo4j_home, (Object)this.testDir.absolutePath()).set(GraphDatabaseSettings.preallocate_logical_logs, (Object)false).build();
    }

    private static class CollectEntityIdsStep
    extends ProcessorStep<long[]> {
        private final BitSet seenEntityIds;

        CollectEntityIdsStep(StageControl control, Configuration config, BitSet seenEntityIds) {
            super(control, "Collector", config, 1, PageCacheTracer.NULL, new StatsProvider[0]);
            this.seenEntityIds = seenEntityIds;
        }

        protected void process(long[] entityIds, BatchSender sender, CursorContext cursorContext) throws Throwable {
            for (long entityId : entityIds) {
                this.seenEntityIds.set((int)entityId);
            }
        }
    }

    private class ControlledUpdatesCheck
    implements StoreScan.ExternalUpdatesCheck {
        private final TokenIndexAccessor indexAccessor;
        private final BitSet expectedEntityIds;

        ControlledUpdatesCheck(TokenIndexAccessor indexAccessor, BitSet expectedEntityIds) {
            this.indexAccessor = indexAccessor;
            this.expectedEntityIds = expectedEntityIds;
        }

        public boolean needToApplyExternalUpdates() {
            return ReadEntityIdsStepUsingTokenIndexTest.this.random.nextBoolean();
        }

        public void applyExternalUpdates(long currentlyIndexedNodeId) {
            int numIds = ReadEntityIdsStepUsingTokenIndexTest.this.random.nextInt(5, 50);
            try (IndexUpdater updater = this.indexAccessor.newUpdater(IndexUpdateMode.ONLINE, CursorContext.NULL);){
                for (int i = 0; i < numIds; ++i) {
                    long candidateId = currentlyIndexedNodeId + (long)i + 1L;
                    if (this.expectedEntityIds.get((int)candidateId)) continue;
                    updater.process((IndexEntryUpdate)IndexEntryUpdate.change((long)candidateId, (SchemaDescriptorSupplier)INDEX_DESCRIPTOR, (long[])PrimitiveLongCollections.EMPTY_LONG_ARRAY, (long[])new long[]{0L}));
                    this.expectedEntityIds.set((int)candidateId);
                }
            }
            catch (IndexEntryConflictException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

