/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.counts.CountsAccessor;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.diagnostics.DiagnosticsLogger;
import org.neo4j.io.fs.WritableChannel;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.api.InjectedNLIUpgradeCallback;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.recovery.ParallelRecoveryVisitor;
import org.neo4j.lock.LockGroup;
import org.neo4j.lock.LockService;
import org.neo4j.lock.LockTracer;
import org.neo4j.lock.LockType;
import org.neo4j.lock.ResourceLocker;
import org.neo4j.logging.Log;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.CommandCreationContext;
import org.neo4j.storageengine.api.CommandStream;
import org.neo4j.storageengine.api.CommandsToApply;
import org.neo4j.storageengine.api.IndexUpdateListener;
import org.neo4j.storageengine.api.MetadataProvider;
import org.neo4j.storageengine.api.StorageCommand;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.StoreFileMetadata;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.TransactionApplicationMode;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;
import org.neo4j.storageengine.api.txstate.TxStateVisitor;
import org.neo4j.test.Barrier;

class ParallelRecoveryVisitorTest {
    ParallelRecoveryVisitorTest() {
    }

    @Test
    void shouldApplyUnrelatedInParallel() throws Exception {
        final Barrier.Control barrier = new Barrier.Control();
        RecoveryControllableStorageEngine storageEngine = new RecoveryControllableStorageEngine(){

            @Override
            public void apply(CommandsToApply batch, TransactionApplicationMode mode) throws Exception {
                long txId = ParallelRecoveryVisitorTest.idOf((CommandStream)batch);
                if (txId == 2L) {
                    barrier.reached();
                } else if (txId == 3L) {
                    barrier.awaitUninterruptibly();
                }
                super.apply(batch, mode);
                if (txId == 3L) {
                    barrier.release();
                }
            }
        };
        try (ParallelRecoveryVisitor visitor = new ParallelRecoveryVisitor((StorageEngine)storageEngine, TransactionApplicationMode.RECOVERY, PageCacheTracer.NULL, "test", 2);){
            visitor.visit(this.tx(2L, this.commandsRelatedToNode(99L)));
            visitor.visit(this.tx(3L, this.commandsRelatedToNode(999L)));
        }
        Assertions.assertThat((long[])storageEngine.lockOrder()).isEqualTo((Object)new long[]{2L, 3L});
        Assertions.assertThat((long[])storageEngine.applyOrder()).isEqualTo((Object)new long[]{3L, 2L});
    }

    @Test
    void shouldApplyRelatedToSameNodeInSequence() throws Exception {
        RecoveryControllableStorageEngine storageEngine = new RecoveryControllableStorageEngine(){

            @Override
            public void apply(CommandsToApply batch, TransactionApplicationMode mode) throws Exception {
                if (ParallelRecoveryVisitorTest.idOf((CommandStream)batch) == 2L) {
                    Thread.sleep(50L);
                }
                super.apply(batch, mode);
            }
        };
        try (ParallelRecoveryVisitor visitor = new ParallelRecoveryVisitor((StorageEngine)storageEngine, TransactionApplicationMode.RECOVERY, PageCacheTracer.NULL, "test", 2);){
            visitor.visit(this.tx(2L, this.commandsRelatedToNode(99L)));
            visitor.visit(this.tx(3L, this.commandsRelatedToNode(99L)));
        }
        Assertions.assertThat((long[])storageEngine.lockOrder()).isEqualTo((Object)new long[]{2L, 3L});
        Assertions.assertThat((long[])storageEngine.applyOrder()).isEqualTo((Object)new long[]{2L, 3L});
    }

    @Test
    void shouldApplyUnrelatedInParallelToRelatedInSequence() throws Exception {
        final Barrier.Control barrier = new Barrier.Control();
        RecoveryControllableStorageEngine storageEngine = new RecoveryControllableStorageEngine(){

            @Override
            public void lockRecoveryCommands(CommandStream commands, LockService lockService, LockGroup lockGroup, TransactionApplicationMode mode) {
                if (ParallelRecoveryVisitorTest.idOf(commands) == 5L) {
                    barrier.release();
                }
                super.lockRecoveryCommands(commands, lockService, lockGroup, TransactionApplicationMode.RECOVERY);
            }

            @Override
            public void apply(CommandsToApply batch, TransactionApplicationMode mode) throws Exception {
                long txId = ParallelRecoveryVisitorTest.idOf((CommandStream)batch);
                if (txId > 2L) {
                    barrier.awaitUninterruptibly();
                }
                super.apply(batch, mode);
                if (txId == 2L) {
                    barrier.reached();
                }
            }
        };
        try (ParallelRecoveryVisitor visitor = new ParallelRecoveryVisitor((StorageEngine)storageEngine, TransactionApplicationMode.RECOVERY, PageCacheTracer.NULL, "test", 2);){
            visitor.visit(this.tx(2L, this.commandsRelatedToNode(99L)));
            visitor.visit(this.tx(3L, this.commandsRelatedToNode(999L)));
            visitor.visit(this.tx(4L, this.commandsRelatedToNode(9999L)));
            visitor.visit(this.tx(5L, this.commandsRelatedToNode(99L)));
        }
        Assertions.assertThat((long[])storageEngine.lockOrder()).isEqualTo((Object)new long[]{2L, 3L, 4L, 5L});
        long[] applyOrder = storageEngine.applyOrder();
        Assertions.assertThat((long)applyOrder[0]).isEqualTo(2L);
        Assertions.assertThat((long)applyOrder[applyOrder.length - 1]).isEqualTo(5L);
    }

    @Test
    void shouldPropagateApplyFailureOnVisit() throws Exception {
        final String failure = "Deliberate failure applying transaction";
        RecoveryControllableStorageEngine storageEngine = new RecoveryControllableStorageEngine(){

            @Override
            public void apply(CommandsToApply batch, TransactionApplicationMode mode) throws Exception {
                super.apply(batch, mode);
                throw new Exception(failure);
            }
        };
        try (ParallelRecoveryVisitor visitor = new ParallelRecoveryVisitor((StorageEngine)storageEngine, TransactionApplicationMode.RECOVERY, PageCacheTracer.NULL, "test", 2);){
            Assertions.assertThatThrownBy(() -> {
                for (long txId = 2L; txId < 100L; ++txId) {
                    visitor.visit(this.tx(txId, this.commandsRelatedToNode(99L)));
                    Thread.sleep(50L);
                }
            }).getCause().hasMessageContaining(failure);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    void shouldPropagateApplyFailureOnClose() throws Exception {
        final String failure = "Deliberate failure applying transaction";
        RecoveryControllableStorageEngine storageEngine = new RecoveryControllableStorageEngine(){

            @Override
            public void apply(CommandsToApply batch, TransactionApplicationMode mode) throws Exception {
                super.apply(batch, mode);
                throw new Exception(failure);
            }
        };
        ParallelRecoveryVisitor visitor = new ParallelRecoveryVisitor((StorageEngine)storageEngine, TransactionApplicationMode.RECOVERY, PageCacheTracer.NULL, "test", 2);
        visitor.visit(this.tx(2L, this.commandsRelatedToNode(99L)));
        Assertions.assertThatThrownBy(() -> ((ParallelRecoveryVisitor)visitor).close()).getCause().hasMessageContaining(failure);
    }

    private CommittedTransactionRepresentation tx(long txId, List<StorageCommand> commands) {
        commands.forEach(cmd -> {
            ((RecoveryTestBaseCommand)cmd).txId = txId;
        });
        LogEntryStart startEntry = new LogEntryStart(0L, 0L, 0, new byte[0], LogPosition.UNSPECIFIED);
        PhysicalTransactionRepresentation txRepresentation = new PhysicalTransactionRepresentation(commands);
        LogEntryCommit commitEntry = new LogEntryCommit(txId, 0L, 0);
        return new CommittedTransactionRepresentation(startEntry, (TransactionRepresentation)txRepresentation, commitEntry);
    }

    private List<StorageCommand> commandsRelatedToNode(long nodeId) {
        ArrayList<StorageCommand> commands = new ArrayList<StorageCommand>();
        commands.add(new CommandRelatedToNode(nodeId));
        return commands;
    }

    private boolean hasId(CommandStream commands, long txId) {
        return ParallelRecoveryVisitorTest.idOf(commands) == txId;
    }

    private static long idOf(CommandStream commands) {
        return ((RecoveryTestBaseCommand)commands.iterator().next()).txId;
    }

    private static class RecoveryControllableStorageEngine
    extends LifecycleAdapter
    implements StorageEngine {
        private final long[] lockOrder = new long[100];
        private final long[] applyOrder = new long[100];
        private final AtomicInteger lockOrderCursor = new AtomicInteger();
        private final AtomicInteger applyOrderCursor = new AtomicInteger();

        private RecoveryControllableStorageEngine() {
        }

        public void lockRecoveryCommands(CommandStream commands, LockService lockService, LockGroup lockGroup, TransactionApplicationMode mode) {
            commands.forEach(cmd -> ((RecoveryTestBaseCommand)cmd).lock(lockService, lockGroup));
            this.lockOrder[this.lockOrderCursor.getAndIncrement()] = ParallelRecoveryVisitorTest.idOf(commands);
        }

        public void apply(CommandsToApply batch, TransactionApplicationMode mode) throws Exception {
            this.applyOrder[this.applyOrderCursor.getAndIncrement()] = ParallelRecoveryVisitorTest.idOf((CommandStream)batch);
        }

        long[] lockOrder() {
            return Arrays.copyOf(this.lockOrder, this.lockOrderCursor.get());
        }

        long[] applyOrder() {
            return Arrays.copyOf(this.applyOrder, this.applyOrderCursor.get());
        }

        public CommandCreationContext newCommandCreationContext(MemoryTracker memoryTracker) {
            throw new UnsupportedOperationException();
        }

        public void addIndexUpdateListener(IndexUpdateListener indexUpdateListener) {
            throw new UnsupportedOperationException();
        }

        public void createCommands(Collection<StorageCommand> target, ReadableTransactionState state, StorageReader storageReader, CommandCreationContext creationContext, ResourceLocker locks, LockTracer lockTracer, long lastTransactionIdWhenStarted, TxStateVisitor.Decorator additionalTxStateVisitor, CursorContext cursorContext, MemoryTracker memoryTracker) throws KernelException {
            throw new UnsupportedOperationException();
        }

        public List<StorageCommand> createUpgradeCommands(KernelVersion versionToUpgradeTo, InjectedNLIUpgradeCallback injectedNLIUpgradeCallback) {
            throw new UnsupportedOperationException();
        }

        public void flushAndForce(CursorContext cursorTracer) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void dumpDiagnostics(Log errorLog, DiagnosticsLogger diagnosticsLog) {
            throw new UnsupportedOperationException();
        }

        public void forceClose() {
            throw new UnsupportedOperationException();
        }

        public void listStorageFiles(Collection<StoreFileMetadata> atomic, Collection<StoreFileMetadata> replayable) {
            throw new UnsupportedOperationException();
        }

        public StoreId getStoreId() {
            throw new UnsupportedOperationException();
        }

        public Lifecycle schemaAndTokensLifecycle() {
            throw new UnsupportedOperationException();
        }

        public MetadataProvider metadataProvider() {
            throw new UnsupportedOperationException();
        }

        public CountsAccessor countsAccessor() {
            throw new UnsupportedOperationException();
        }

        public StorageReader newReader() {
            throw new UnsupportedOperationException();
        }
    }

    private static class CommandRelatedToNode
    extends RecoveryTestBaseCommand {
        final long nodeId;

        CommandRelatedToNode(long nodeId) {
            this.nodeId = nodeId;
        }

        @Override
        void lock(LockService lockService, LockGroup lockGroup) {
            lockGroup.add(lockService.acquireNodeLock(this.nodeId, LockType.EXCLUSIVE));
        }
    }

    private static abstract class RecoveryTestBaseCommand
    implements StorageCommand {
        long txId;

        private RecoveryTestBaseCommand() {
        }

        public void serialize(WritableChannel channel) throws IOException {
        }

        public KernelVersion version() {
            return KernelVersion.LATEST;
        }

        abstract void lock(LockService var1, LockGroup var2);
    }
}

