/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.security;

import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.kernel.api.security.AuthToken;
import org.neo4j.string.UTF8;

class AuthTokenTest {
    AuthTokenTest() {
    }

    @Test
    void shouldMakeBasicAuthToken() {
        Map token = AuthToken.newBasicAuthToken((String)"me", (String)"my secret");
        ((ObjectAssert)Assertions.assertThat(token.get("principal")).as("Should have correct username", new Object[0])).isEqualTo((Object)"me");
        ((ObjectAssert)Assertions.assertThat(token.get("credentials")).as("Should have correct password", new Object[0])).isEqualTo((Object)UTF8.encode((String)"my secret"));
        ((ObjectAssert)Assertions.assertThat(token.get("scheme")).as("Should have correct scheme", new Object[0])).isEqualTo((Object)"basic");
        ((ObjectAssert)Assertions.assertThat(token.get("realm")).as("Should have no realm", new Object[0])).isNull();
    }

    @Test
    void shouldMakeBasicAuthTokenWithRealm() {
        Map token = AuthToken.newBasicAuthToken((String)"me", (String)"my secret", (String)"my realm");
        ((ObjectAssert)Assertions.assertThat(token.get("principal")).as("Should have correct username", new Object[0])).isEqualTo((Object)"me");
        ((ObjectAssert)Assertions.assertThat(token.get("credentials")).as("Should have correct password", new Object[0])).isEqualTo((Object)UTF8.encode((String)"my secret"));
        ((ObjectAssert)Assertions.assertThat(token.get("scheme")).as("Should have correct scheme", new Object[0])).isEqualTo((Object)"basic");
        ((ObjectAssert)Assertions.assertThat(token.get("realm")).as("Should have correct realm", new Object[0])).isEqualTo((Object)"my realm");
    }

    @Test
    void shouldMakeCustomAuthTokenAndBasicScheme() {
        Map token = AuthToken.newCustomAuthToken((String)"me", (String)"my secret", (String)"my realm", (String)"basic");
        ((ObjectAssert)Assertions.assertThat(token.get("principal")).as("Should have correct username", new Object[0])).isEqualTo((Object)"me");
        ((ObjectAssert)Assertions.assertThat(token.get("credentials")).as("Should have correct password", new Object[0])).isEqualTo((Object)UTF8.encode((String)"my secret"));
        ((ObjectAssert)Assertions.assertThat(token.get("scheme")).as("Should have correct scheme", new Object[0])).isEqualTo((Object)"basic");
        ((ObjectAssert)Assertions.assertThat(token.get("realm")).as("Should have correctno realm", new Object[0])).isEqualTo((Object)"my realm");
    }

    @Test
    void shouldMakeCustomAuthTokenAndCustomcScheme() {
        Map token = AuthToken.newCustomAuthToken((String)"me", (String)"my secret", (String)"my realm", (String)"my scheme");
        ((ObjectAssert)Assertions.assertThat(token.get("principal")).as("Should have correct username", new Object[0])).isEqualTo((Object)"me");
        ((ObjectAssert)Assertions.assertThat(token.get("credentials")).as("Should have correct password", new Object[0])).isEqualTo((Object)UTF8.encode((String)"my secret"));
        ((ObjectAssert)Assertions.assertThat(token.get("scheme")).as("Should have correct scheme", new Object[0])).isEqualTo((Object)"my scheme");
        ((ObjectAssert)Assertions.assertThat(token.get("realm")).as("Should have correct realm", new Object[0])).isEqualTo((Object)"my realm");
    }

    @Test
    void shouldMakeCustomAuthTokenAndCustomcSchemeWithParameters() {
        Map token = AuthToken.newCustomAuthToken((String)"me", (String)"my secret", (String)"my realm", (String)"my scheme", (Map)MapUtil.map((Object[])new Object[]{"a", "A", "b", "B"}));
        ((ObjectAssert)Assertions.assertThat(token.get("principal")).as("Should have correct username", new Object[0])).isEqualTo((Object)"me");
        ((ObjectAssert)Assertions.assertThat(token.get("credentials")).as("Should have correct password", new Object[0])).isEqualTo((Object)UTF8.encode((String)"my secret"));
        ((ObjectAssert)Assertions.assertThat(token.get("scheme")).as("Should have correct scheme", new Object[0])).isEqualTo((Object)"my scheme");
        ((ObjectAssert)Assertions.assertThat(token.get("realm")).as("Should have correct realm", new Object[0])).isEqualTo((Object)"my realm");
        ((ObjectAssert)Assertions.assertThat(token.get("parameters")).as("Should have correct parameters", new Object[0])).isEqualTo((Object)MapUtil.map((Object[])new Object[]{"a", "A", "b", "B"}));
    }
}

