/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.api.TransactionQueue;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;

class TransactionQueueTest {
    TransactionQueueTest() {
    }

    @Test
    void shouldEmptyIfTooMany() throws Exception {
        int i;
        TransactionQueue.Applier applier = (TransactionQueue.Applier)Mockito.mock(TransactionQueue.Applier.class);
        int batchSize = 10;
        TransactionQueue queue = new TransactionQueue(batchSize, applier);
        for (i = 0; i < 9; ++i) {
            queue.queue((TransactionToApply)Mockito.mock(TransactionToApply.class));
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{applier});
        }
        queue.queue((TransactionToApply)Mockito.mock(TransactionToApply.class));
        ((TransactionQueue.Applier)Mockito.verify((Object)applier)).apply((TransactionToApply)ArgumentMatchers.any(), (TransactionToApply)ArgumentMatchers.any());
        Mockito.reset((Object[])new TransactionQueue.Applier[]{applier});
        queue.queue((TransactionToApply)Mockito.mock(TransactionToApply.class));
        for (i = 0; i < 2; ++i) {
            queue.queue((TransactionToApply)Mockito.mock(TransactionToApply.class));
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{applier});
        }
        queue.empty();
        ((TransactionQueue.Applier)Mockito.verify((Object)applier)).apply((TransactionToApply)ArgumentMatchers.any(), (TransactionToApply)ArgumentMatchers.any());
    }

    @Test
    void shouldLinkTogetherTransactions() throws Exception {
        int i;
        TransactionQueue.Applier applier = (TransactionQueue.Applier)Mockito.mock(TransactionQueue.Applier.class);
        int batchSize = 10;
        TransactionQueue queue = new TransactionQueue(batchSize, applier);
        TransactionToApply[] txs = new TransactionToApply[batchSize];
        for (i = 0; i < batchSize; ++i) {
            txs[i] = new TransactionToApply((TransactionRepresentation)Mockito.mock(TransactionRepresentation.class), CursorContext.NULL);
            queue.queue(txs[i]);
        }
        ((TransactionQueue.Applier)Mockito.verify((Object)applier)).apply((TransactionToApply)ArgumentMatchers.any(), (TransactionToApply)ArgumentMatchers.any());
        for (i = 0; i < txs.length - 1; ++i) {
            Assertions.assertEquals((Object)txs[i + 1], (Object)txs[i].next());
        }
    }
}

