/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.factory;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.helpers.DatabaseReadOnlyChecker;
import org.neo4j.graphdb.WriteOperationsNotAllowedException;
import org.neo4j.kernel.impl.factory.AccessCapability;
import org.neo4j.kernel.impl.factory.AccessCapabilityFactory;
import org.neo4j.kernel.impl.factory.CanWrite;
import org.neo4j.kernel.impl.factory.ReadOnly;

class AccessCapabilityFactoryTest {
    private final DatabaseReadOnlyChecker readWriteChecker = DatabaseReadOnlyChecker.writable();
    private final DatabaseReadOnlyChecker readOnlyChecker = DatabaseReadOnlyChecker.readOnly();

    AccessCapabilityFactoryTest() {
    }

    @Test
    void shouldCreateConfigDependentFactoryForReadWriteConfig() {
        AccessCapabilityFactory factory = AccessCapabilityFactory.configDependent();
        AccessCapability accessCapability = factory.newAccessCapability(this.readWriteChecker);
        Assertions.assertThat((Object)accessCapability).isInstanceOf(CanWrite.class);
        org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> ((AccessCapability)accessCapability).assertCanWrite());
    }

    @Test
    void shouldCreateConfigDependentFactoryForReadOnlyConfig() {
        AccessCapabilityFactory factory = AccessCapabilityFactory.configDependent();
        AccessCapability accessCapability = factory.newAccessCapability(this.readOnlyChecker);
        Assertions.assertThat((Object)accessCapability).isInstanceOf(ReadOnly.class);
        org.junit.jupiter.api.Assertions.assertThrows(WriteOperationsNotAllowedException.class, () -> ((AccessCapability)accessCapability).assertCanWrite());
    }

    @Test
    void shouldCreateFixedFactory() {
        CanWrite accessCapability1 = CanWrite.INSTANCE;
        ReadOnly accessCapability2 = ReadOnly.INSTANCE;
        AccessCapabilityFactory factory1 = AccessCapabilityFactory.fixed((AccessCapability)accessCapability1);
        AccessCapabilityFactory factory2 = AccessCapabilityFactory.fixed((AccessCapability)accessCapability2);
        org.junit.jupiter.api.Assertions.assertEquals((Object)accessCapability1, (Object)factory1.newAccessCapability(this.readWriteChecker));
        org.junit.jupiter.api.Assertions.assertEquals((Object)accessCapability1, (Object)factory1.newAccessCapability(this.readOnlyChecker));
        org.junit.jupiter.api.Assertions.assertEquals((Object)accessCapability2, (Object)factory2.newAccessCapability(this.readWriteChecker));
        org.junit.jupiter.api.Assertions.assertEquals((Object)accessCapability2, (Object)factory2.newAccessCapability(this.readOnlyChecker));
    }
}

