/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.impl.index.schema.IndexFiles;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexPopulator;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexTestHelp;
import org.neo4j.kernel.impl.index.schema.fusion.FusionVersion;
import org.neo4j.kernel.impl.index.schema.fusion.IndexSlot;
import org.neo4j.kernel.impl.index.schema.fusion.InstanceSelector;
import org.neo4j.kernel.impl.index.schema.fusion.SlotSelector;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.values.storable.Value;

abstract class FusionIndexPopulatorTest {
    private static final long indexId = 8L;
    private IndexPopulator[] alivePopulators;
    private EnumMap<IndexSlot, IndexPopulator> populators;
    private FusionIndexPopulator fusionIndexPopulator;
    private FileSystemAbstraction fs;
    private IndexDirectoryStructure directoryStructure;
    private final FusionVersion fusionVersion;

    FusionIndexPopulatorTest(FusionVersion fusionVersion) {
        this.fusionVersion = fusionVersion;
    }

    @BeforeEach
    void setup() {
        this.initiateMocks();
    }

    private void initiateMocks() {
        IndexSlot[] aliveSlots = this.fusionVersion.aliveSlots();
        this.populators = new EnumMap(IndexSlot.class);
        FusionIndexTestHelp.fill(this.populators, IndexPopulator.EMPTY);
        this.alivePopulators = new IndexPopulator[aliveSlots.length];
        block4: for (int i = 0; i < aliveSlots.length; ++i) {
            IndexPopulator mock;
            this.alivePopulators[i] = mock = (IndexPopulator)Mockito.mock(IndexPopulator.class);
            switch (aliveSlots[i]) {
                case GENERIC: {
                    this.populators.put(IndexSlot.GENERIC, mock);
                    continue block4;
                }
                case LUCENE: {
                    this.populators.put(IndexSlot.LUCENE, mock);
                    continue block4;
                }
                default: {
                    throw new RuntimeException();
                }
            }
        }
        SlotSelector slotSelector = this.fusionVersion.slotSelector();
        InstanceSelector instanceSelector = new InstanceSelector(this.populators);
        this.fs = (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class);
        this.directoryStructure = IndexDirectoryStructure.directoriesByProvider((Path)Path.of("storeDir", new String[0])).forProvider(IndexProviderDescriptor.UNDECIDED);
        Mockito.when((Object)this.fs.fileExists(this.directoryStructure.directoryForIndex(8L))).thenReturn((Object)true);
        IndexFiles.Directory indexFiles = new IndexFiles.Directory(this.fs, this.directoryStructure, 8L);
        this.fusionIndexPopulator = new FusionIndexPopulator(slotSelector, instanceSelector, (IndexFiles)indexFiles, false);
    }

    @Test
    void createMustCreateAll() throws IOException {
        this.fusionIndexPopulator.create();
        for (IndexPopulator alivePopulator : this.alivePopulators) {
            ((IndexPopulator)Mockito.verify((Object)alivePopulator)).create();
        }
    }

    @Test
    void createRemoveAnyLeftOversThatWasThereInIndexDirectoryBeforePopulation() throws IOException {
        this.fusionIndexPopulator.create();
        ((FileSystemAbstraction)Mockito.verify((Object)this.fs)).deleteRecursively(this.directoryStructure.directoryForIndex(8L));
    }

    @Test
    void createMustThrowIfAnyThrow() throws IOException {
        for (IndexPopulator alivePopulator : this.alivePopulators) {
            UncheckedIOException failure = new UncheckedIOException(new IOException("fail"));
            ((IndexPopulator)Mockito.doThrow((Throwable[])new Throwable[]{failure}).when((Object)alivePopulator)).create();
            FusionIndexTestHelp.verifyCallFail(failure, () -> {
                this.fusionIndexPopulator.create();
                return null;
            });
            ((IndexPopulator)Mockito.doAnswer(invocation -> null).when((Object)alivePopulator)).create();
        }
    }

    @Test
    void dropMustDropAll() throws IOException {
        this.fusionIndexPopulator.drop();
        for (IndexPopulator alivePopulator : this.alivePopulators) {
            ((IndexPopulator)Mockito.verify((Object)alivePopulator)).drop();
        }
        ((FileSystemAbstraction)Mockito.verify((Object)this.fs)).deleteRecursively(this.directoryStructure.directoryForIndex(8L));
    }

    @Test
    void dropMustThrowIfAnyDropThrow() {
        for (IndexPopulator alivePopulator : this.alivePopulators) {
            UncheckedIOException failure = new UncheckedIOException(new IOException("fail"));
            ((IndexPopulator)Mockito.doThrow((Throwable[])new Throwable[]{failure}).when((Object)alivePopulator)).drop();
            FusionIndexTestHelp.verifyCallFail(failure, () -> {
                this.fusionIndexPopulator.drop();
                return null;
            });
            ((IndexPopulator)Mockito.doAnswer(invocation -> null).when((Object)alivePopulator)).drop();
        }
    }

    @Test
    void addMustSelectCorrectPopulator() throws Exception {
        EnumMap<IndexSlot, Value[]> values = FusionIndexTestHelp.valuesByGroup();
        Value[] allValues = FusionIndexTestHelp.allValues();
        for (IndexSlot indexSlot : IndexSlot.values()) {
            for (Value value : values.get(indexSlot)) {
                this.verifyAddWithCorrectPopulator(this.orLucene(this.populators.get(indexSlot)), value);
            }
        }
        for (IndexSlot indexSlot : allValues) {
            for (Value secondValue : allValues) {
                this.verifyAddWithCorrectPopulator(this.populators.get(IndexSlot.GENERIC), new Value[]{indexSlot, secondValue});
            }
        }
    }

    private void verifyAddWithCorrectPopulator(IndexPopulator correctPopulator, Value ... numberValues) throws IndexEntryConflictException {
        List<IndexEntryUpdate<LabelSchemaDescriptor>> update = Collections.singletonList(FusionIndexTestHelp.add(numberValues));
        this.fusionIndexPopulator.add(update, CursorContext.NULL);
        ((IndexPopulator)Mockito.verify((Object)correctPopulator)).add(update, CursorContext.NULL);
        for (IndexPopulator alivePopulator : this.alivePopulators) {
            if (alivePopulator == correctPopulator) continue;
            ((IndexPopulator)Mockito.verify((Object)alivePopulator, (VerificationMode)Mockito.never())).add(update, CursorContext.NULL);
        }
    }

    @Test
    void verifyDeferredConstraintsMustThrowIfAnyThrow() throws Exception {
        for (IndexPopulator alivePopulator : this.alivePopulators) {
            IndexEntryConflictException failure = (IndexEntryConflictException)((Object)Mockito.mock(IndexEntryConflictException.class));
            ((IndexPopulator)Mockito.doThrow((Throwable[])new Throwable[]{failure}).when((Object)alivePopulator)).verifyDeferredConstraints((NodePropertyAccessor)ArgumentMatchers.any());
            FusionIndexTestHelp.verifyCallFail((Exception)((Object)failure), () -> {
                this.fusionIndexPopulator.verifyDeferredConstraints(null);
                return null;
            });
            ((IndexPopulator)Mockito.doAnswer(invocation -> null).when((Object)alivePopulator)).verifyDeferredConstraints((NodePropertyAccessor)ArgumentMatchers.any());
        }
    }

    @Test
    void successfulCloseMustCloseAll() {
        this.closeAndVerifyPropagation(true);
    }

    @Test
    void unsuccessfulCloseMustCloseAll() {
        this.closeAndVerifyPropagation(false);
    }

    private void closeAndVerifyPropagation(boolean populationCompletedSuccessfully) {
        this.fusionIndexPopulator.close(populationCompletedSuccessfully, CursorContext.NULL);
        for (IndexPopulator alivePopulator : this.alivePopulators) {
            ((IndexPopulator)Mockito.verify((Object)alivePopulator)).close(populationCompletedSuccessfully, CursorContext.NULL);
        }
    }

    @Test
    void closeMustThrowIfCloseAnyThrow() {
        for (IndexSlot aliveSlot : this.fusionVersion.aliveSlots()) {
            UncheckedIOException failure = new UncheckedIOException(new IOException("fail"));
            ((IndexPopulator)Mockito.doThrow((Throwable[])new Throwable[]{failure}).when((Object)this.populators.get(aliveSlot))).close(ArgumentMatchers.anyBoolean(), (CursorContext)ArgumentMatchers.any());
            FusionIndexTestHelp.verifyCallFail(failure, () -> {
                this.fusionIndexPopulator.close(ArgumentMatchers.anyBoolean(), (CursorContext)ArgumentMatchers.any());
                return null;
            });
            this.initiateMocks();
        }
    }

    private void verifyOtherCloseOnThrow(IndexPopulator throwingPopulator) {
        UncheckedIOException failure = new UncheckedIOException(new IOException("fail"));
        ((IndexPopulator)Mockito.doThrow((Throwable[])new Throwable[]{failure}).when((Object)throwingPopulator)).close(ArgumentMatchers.anyBoolean(), (CursorContext)ArgumentMatchers.any());
        Assertions.assertThrows(UncheckedIOException.class, () -> this.fusionIndexPopulator.close(true, CursorContext.NULL));
        for (IndexPopulator alivePopulator : this.alivePopulators) {
            ((IndexPopulator)Mockito.verify((Object)alivePopulator)).close(true, CursorContext.NULL);
        }
    }

    @Test
    void closeMustCloseOthersIfAnyThrow() {
        for (IndexSlot throwingSlot : this.fusionVersion.aliveSlots()) {
            this.verifyOtherCloseOnThrow(this.populators.get(throwingSlot));
            this.initiateMocks();
        }
    }

    @Test
    void closeMustThrowIfAllThrow() {
        ArrayList<UncheckedIOException> failures = new ArrayList<UncheckedIOException>();
        for (IndexPopulator alivePopulator : this.alivePopulators) {
            UncheckedIOException failure = new UncheckedIOException(new IOException("FAILURE[" + alivePopulator + "]"));
            failures.add(failure);
            ((IndexPopulator)Mockito.doThrow((Throwable[])new Throwable[]{failure}).when((Object)alivePopulator)).close(ArgumentMatchers.anyBoolean(), (CursorContext)ArgumentMatchers.any());
        }
        UncheckedIOException e = (UncheckedIOException)Assertions.assertThrows(UncheckedIOException.class, () -> this.fusionIndexPopulator.close(ArgumentMatchers.anyBoolean(), (CursorContext)ArgumentMatchers.any()));
        if (!failures.contains(e)) {
            Assertions.fail((String)("Thrown exception didn't match any of the expected failures: " + failures));
        }
    }

    @Test
    void markAsFailedMustMarkAll() {
        String failureMessage = "failure";
        this.fusionIndexPopulator.markAsFailed(failureMessage);
        for (IndexPopulator alivePopulator : this.alivePopulators) {
            ((IndexPopulator)Mockito.verify((Object)alivePopulator)).markAsFailed(failureMessage);
        }
    }

    @Test
    void markAsFailedMustThrowIfAnyThrow() {
        for (IndexPopulator alivePopulator : this.alivePopulators) {
            UncheckedIOException failure = new UncheckedIOException(new IOException("fail"));
            ((IndexPopulator)Mockito.doThrow((Throwable[])new Throwable[]{failure}).when((Object)alivePopulator)).markAsFailed(ArgumentMatchers.anyString());
            FusionIndexTestHelp.verifyCallFail(failure, () -> {
                this.fusionIndexPopulator.markAsFailed(ArgumentMatchers.anyString());
                return null;
            });
            ((IndexPopulator)Mockito.doAnswer(invocation -> null).when((Object)alivePopulator)).markAsFailed(ArgumentMatchers.anyString());
        }
    }

    @Test
    void shouldIncludeSampleOnCorrectPopulator() {
        EnumMap<IndexSlot, Value[]> values = FusionIndexTestHelp.valuesByGroup();
        for (IndexSlot activeSlot : this.fusionVersion.aliveSlots()) {
            this.verifySampleToCorrectPopulator(values.get(activeSlot), this.populators.get(activeSlot));
        }
    }

    private void verifySampleToCorrectPopulator(Value[] values, IndexPopulator populator) {
        for (Value value : values) {
            IndexEntryUpdate<LabelSchemaDescriptor> update = FusionIndexTestHelp.add(value);
            this.fusionIndexPopulator.includeSample(update);
            ((IndexPopulator)Mockito.verify((Object)populator)).includeSample(update);
            Mockito.reset((Object[])new IndexPopulator[]{populator});
        }
    }

    private IndexPopulator orLucene(IndexPopulator populator) {
        return populator != IndexPopulator.EMPTY ? populator : this.populators.get(IndexSlot.LUCENE);
    }
}

