/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.io.IOException;
import java.util.Collections;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.neo4j.kernel.impl.api.TestCommand;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionCursor;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChecksumChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommand;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryInlinedCheckPoint;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.storageengine.api.StorageCommand;

class PhysicalTransactionCursorTest {
    private final ReadableLogChannel channel = (ReadableLogChannel)Mockito.mock(ReadableLogChannel.class, (Answer)Mockito.RETURNS_MOCKS);
    private final LogEntryReader entryReader = (LogEntryReader)Mockito.mock(LogEntryReader.class);
    private static final LogEntry NULL_ENTRY = null;
    private static final LogEntryInlinedCheckPoint A_CHECK_POINT_ENTRY = new LogEntryInlinedCheckPoint(LogPosition.UNSPECIFIED);
    private static final LogEntryStart A_START_ENTRY = new LogEntryStart(0L, 0L, 0, null, LogPosition.UNSPECIFIED);
    private static final LogEntryCommit A_COMMIT_ENTRY = new LogEntryCommit(42L, 0L, -559063315);
    private static final LogEntryCommand A_COMMAND_ENTRY = new LogEntryCommand((StorageCommand)new TestCommand());
    private PhysicalTransactionCursor cursor;

    PhysicalTransactionCursorTest() {
    }

    @BeforeEach
    void setup() throws IOException {
        this.cursor = new PhysicalTransactionCursor((ReadableClosablePositionAwareChecksumChannel)this.channel, this.entryReader);
    }

    @Test
    void shouldCloseTheUnderlyingChannel() throws IOException {
        this.cursor.close();
        ((ReadableLogChannel)Mockito.verify((Object)this.channel)).close();
    }

    @Test
    void shouldReturnFalseWhenThereAreNoEntries() throws IOException {
        Mockito.when((Object)this.entryReader.readLogEntry((ReadableClosablePositionAwareChecksumChannel)this.channel)).thenReturn((Object)NULL_ENTRY);
        boolean result = this.cursor.next();
        Assertions.assertFalse((boolean)result);
        Assertions.assertNull((Object)this.cursor.get());
    }

    @Test
    void shouldReturnFalseWhenThereIsAStartEntryButNoCommitEntries() throws IOException {
        Mockito.when((Object)this.entryReader.readLogEntry((ReadableClosablePositionAwareChecksumChannel)this.channel)).thenReturn((Object)A_START_ENTRY, (Object[])new LogEntry[]{NULL_ENTRY});
        boolean result = this.cursor.next();
        Assertions.assertFalse((boolean)result);
        Assertions.assertNull((Object)this.cursor.get());
    }

    @Test
    void shouldCallTheVisitorWithTheFoundTransaction() throws IOException {
        Mockito.when((Object)this.entryReader.readLogEntry((ReadableClosablePositionAwareChecksumChannel)this.channel)).thenReturn((Object)A_START_ENTRY, (Object[])new LogEntry[]{A_COMMAND_ENTRY, A_COMMIT_ENTRY});
        this.cursor.next();
        PhysicalTransactionRepresentation txRepresentation = new PhysicalTransactionRepresentation(Collections.singletonList(A_COMMAND_ENTRY.getCommand()));
        Assertions.assertEquals((Object)new CommittedTransactionRepresentation(A_START_ENTRY, (TransactionRepresentation)txRepresentation, A_COMMIT_ENTRY), (Object)this.cursor.get());
    }

    @Test
    void shouldSkipCheckPoints() throws IOException {
        Mockito.when((Object)this.entryReader.readLogEntry((ReadableClosablePositionAwareChecksumChannel)this.channel)).thenReturn((Object)A_CHECK_POINT_ENTRY, (Object[])new LogEntry[]{A_START_ENTRY, A_COMMAND_ENTRY, A_COMMIT_ENTRY, A_CHECK_POINT_ENTRY});
        this.cursor.next();
        PhysicalTransactionRepresentation txRepresentation = new PhysicalTransactionRepresentation(Collections.singletonList(A_COMMAND_ENTRY.getCommand()));
        Assertions.assertEquals((Object)new CommittedTransactionRepresentation(A_START_ENTRY, (TransactionRepresentation)txRepresentation, A_COMMIT_ENTRY), (Object)this.cursor.get());
    }
}

