/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.internal.event;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.event.LabelEntry;
import org.neo4j.graphdb.event.PropertyEntry;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.exceptions.PropertyKeyIdNotFoundKernelException;
import org.neo4j.internal.kernel.api.security.AbstractSecurityLog;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.kernel.api.security.AuthSubject;
import org.neo4j.internal.kernel.api.security.CommunitySecurityLog;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.security.AnonymousContext;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.state.TxState;
import org.neo4j.kernel.impl.core.NodeEntity;
import org.neo4j.kernel.impl.core.RelationshipEntity;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.internal.event.TxStateTransactionDataSnapshot;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.StubStorageCursors;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

class TxStateTransactionDataViewTest {
    private final StubStorageCursors ops = new StubStorageCursors();
    private final KernelTransactionImplementation transaction = (KernelTransactionImplementation)Mockito.mock(KernelTransactionImplementation.class);
    private final InternalTransaction internalTransaction = (InternalTransaction)Mockito.mock(InternalTransaction.class);
    private final TokenRead tokenRead = (TokenRead)Mockito.mock(TokenRead.class);
    private final TransactionState state = new TxState();

    TxStateTransactionDataViewTest() {
    }

    @BeforeEach
    void setup() throws PropertyKeyIdNotFoundKernelException {
        Mockito.when((Object)this.transaction.memoryTracker()).thenReturn((Object)EmptyMemoryTracker.INSTANCE);
        Mockito.when((Object)this.transaction.internalTransaction()).thenReturn((Object)this.internalTransaction);
        KernelTransaction kernelTransaction = (KernelTransaction)Mockito.mock(KernelTransaction.class);
        Mockito.when((Object)this.internalTransaction.kernelTransaction()).thenReturn((Object)kernelTransaction);
        Mockito.when((Object)kernelTransaction.cursorContext()).thenReturn((Object)CursorContext.NULL);
        Mockito.when((Object)this.transaction.tokenRead()).thenReturn((Object)this.tokenRead);
        Mockito.when((Object)this.tokenRead.propertyKeyName(ArgumentMatchers.anyInt())).thenAnswer(invocationOnMock -> {
            int id = (Integer)invocationOnMock.getArgument(0);
            return this.ops.propertyKeyTokenHolder().getTokenById(id).name();
        });
    }

    @Test
    void showsCreatedNodes() {
        this.state.nodeDoCreate(1L);
        this.state.nodeDoCreate(2L);
        Assertions.assertThat(TxStateTransactionDataViewTest.idList(this.snapshot().createdNodes())).isEqualTo(Arrays.asList(1L, 2L));
    }

    @Test
    void showsDeletedNodes() throws Exception {
        this.state.nodeDoDelete(1L);
        this.state.nodeDoDelete(2L);
        int labelId = 15;
        Mockito.when((Object)this.tokenRead.nodeLabelName(labelId)).thenReturn((Object)"label");
        this.ops.withNode(1L).labels(labelId).properties(new Object[]{"key", Values.of((Object)"p")});
        this.ops.withNode(2L);
        TxStateTransactionDataSnapshot snapshot = this.snapshot();
        Assertions.assertThat(TxStateTransactionDataViewTest.idList(snapshot.deletedNodes())).isEqualTo(Arrays.asList(1L, 2L));
        Assertions.assertThat((String)((LabelEntry)Iterables.single((Iterable)snapshot.removedLabels())).label().name()).isEqualTo("label");
        Assertions.assertThat((String)((PropertyEntry)Iterables.single((Iterable)snapshot.removedNodeProperties())).key()).isEqualTo("key");
    }

    @Test
    void showsAddedRelationships() {
        this.state.relationshipDoCreate(1L, 1, 1L, 2L);
        this.state.relationshipDoCreate(2L, 1, 1L, 1L);
        Assertions.assertThat(TxStateTransactionDataViewTest.idList(this.snapshot().createdRelationships())).isEqualTo(Arrays.asList(1L, 2L));
    }

    @Test
    void showsRemovedRelationships() {
        this.state.relationshipDoDelete(1L, 1, 1L, 2L);
        this.state.relationshipDoDelete(2L, 1, 1L, 1L);
        this.ops.withRelationship(1L, 1L, 1, 2L);
        this.ops.withRelationship(2L, 1L, 1, 1L).properties(new Object[]{"key", Values.of((Object)"p")});
        TxStateTransactionDataSnapshot snapshot = this.snapshot();
        Assertions.assertThat(TxStateTransactionDataViewTest.idList(snapshot.deletedRelationships())).isEqualTo(Arrays.asList(1L, 2L));
        Assertions.assertThat((String)((PropertyEntry)Iterables.single((Iterable)snapshot.removedRelationshipProperties())).key()).isEqualTo("key");
    }

    @Test
    void correctlySaysNodeIsDeleted() {
        this.state.nodeDoDelete(1L);
        Node node = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)node.getId()).thenReturn((Object)1L);
        this.ops.withNode(1L);
        Assertions.assertThat((boolean)this.snapshot().isDeleted(node)).isEqualTo(true);
    }

    @Test
    void correctlySaysRelIsDeleted() {
        this.state.relationshipDoDelete(1L, 1, 1L, 2L);
        Relationship rel = (Relationship)Mockito.mock(Relationship.class);
        Mockito.when((Object)rel.getId()).thenReturn((Object)1L);
        this.ops.withRelationship(1L, 1L, 1, 2L);
        Assertions.assertThat((boolean)this.snapshot().isDeleted(rel)).isEqualTo(true);
    }

    @Test
    void shouldListAddedNodePropertiesProperties() throws Exception {
        int propertyKeyId = this.ops.propertyKeyTokenHolder().getOrCreateId("theKey");
        Value prevValue = Values.of((Object)"prevValue");
        this.state.nodeDoChangeProperty(1L, propertyKeyId, Values.of((Object)"newValue"));
        this.ops.withNode(1L).properties(new Object[]{"theKey", prevValue});
        Iterable propertyEntries = this.snapshot().assignedNodeProperties();
        PropertyEntry entry = (PropertyEntry)Iterables.single((Iterable)propertyEntries);
        Assertions.assertThat((String)entry.key()).isEqualTo("theKey");
        Assertions.assertThat((Object)entry.value()).isEqualTo((Object)"newValue");
        Assertions.assertThat((Object)entry.previouslyCommittedValue()).isEqualTo((Object)"prevValue");
        Assertions.assertThat((long)((Node)entry.entity()).getId()).isEqualTo(1L);
    }

    @Test
    void shouldListRemovedNodeProperties() throws Exception {
        int propertyKeyId = this.ops.propertyKeyTokenHolder().getOrCreateId("theKey");
        Value prevValue = Values.of((Object)"prevValue");
        this.state.nodeDoRemoveProperty(1L, propertyKeyId);
        this.ops.withNode(1L).properties(new Object[]{"theKey", prevValue});
        Iterable propertyEntries = this.snapshot().removedNodeProperties();
        PropertyEntry entry = (PropertyEntry)Iterables.single((Iterable)propertyEntries);
        Assertions.assertThat((String)entry.key()).isEqualTo("theKey");
        Assertions.assertThat((Object)entry.previouslyCommittedValue()).isEqualTo((Object)"prevValue");
        Assertions.assertThat((long)((Node)entry.entity()).getId()).isEqualTo(1L);
    }

    @Test
    void shouldListRemovedRelationshipProperties() throws Exception {
        int propertyKeyId = this.ops.propertyKeyTokenHolder().getOrCreateId("theKey");
        Value prevValue = Values.of((Object)"prevValue");
        this.state.relationshipDoRemoveProperty(1L, propertyKeyId);
        this.ops.withRelationship(1L, 0L, 0, 0L).properties(new Object[]{"theKey", prevValue});
        Iterable propertyEntries = this.snapshot().removedRelationshipProperties();
        PropertyEntry entry = (PropertyEntry)Iterables.single((Iterable)propertyEntries);
        Assertions.assertThat((String)entry.key()).isEqualTo("theKey");
        Assertions.assertThat((Object)entry.previouslyCommittedValue()).isEqualTo((Object)"prevValue");
        Assertions.assertThat((long)((Relationship)entry.entity()).getId()).isEqualTo(1L);
    }

    @Test
    void shouldListAddedRelationshipProperties() throws Exception {
        Value prevValue = Values.of((Object)"prevValue");
        int propertyKeyId = this.ops.propertyKeyTokenHolder().getOrCreateId("theKey");
        this.state.relationshipDoReplaceProperty(1L, propertyKeyId, prevValue, Values.of((Object)"newValue"));
        this.ops.withRelationship(1L, 0L, 0, 0L).properties(new Object[]{"theKey", prevValue});
        Iterable propertyEntries = this.snapshot().assignedRelationshipProperties();
        PropertyEntry entry = (PropertyEntry)Iterables.single((Iterable)propertyEntries);
        Assertions.assertThat((String)entry.key()).isEqualTo("theKey");
        Assertions.assertThat((Object)entry.value()).isEqualTo((Object)"newValue");
        Assertions.assertThat((Object)entry.previouslyCommittedValue()).isEqualTo((Object)"prevValue");
        Assertions.assertThat((long)((Relationship)entry.entity()).getId()).isEqualTo(1L);
    }

    @Test
    void shouldListAddedLabels() throws Exception {
        int labelId = 2;
        Mockito.when((Object)this.tokenRead.nodeLabelName(labelId)).thenReturn((Object)"theLabel");
        this.state.nodeDoAddLabel((long)labelId, 1L);
        Iterable labelEntries = this.snapshot().assignedLabels();
        LabelEntry entry = (LabelEntry)Iterables.single((Iterable)labelEntries);
        Assertions.assertThat((String)entry.label().name()).isEqualTo("theLabel");
        Assertions.assertThat((long)entry.node().getId()).isEqualTo(1L);
    }

    @Test
    void shouldListRemovedLabels() throws Exception {
        int labelId = 2;
        Mockito.when((Object)this.tokenRead.nodeLabelName(labelId)).thenReturn((Object)"theLabel");
        this.state.nodeDoRemoveLabel((long)labelId, 1L);
        Iterable labelEntries = this.snapshot().removedLabels();
        LabelEntry entry = (LabelEntry)Iterables.single((Iterable)labelEntries);
        Assertions.assertThat((String)entry.label().name()).isEqualTo("theLabel");
        Assertions.assertThat((long)entry.node().getId()).isEqualTo(1L);
    }

    @Test
    void accessTransactionIdAndCommitTime() {
        long committedTransactionId = 7L;
        long commitTime = 10L;
        Mockito.when((Object)this.transaction.getTransactionId()).thenReturn((Object)committedTransactionId);
        Mockito.when((Object)this.transaction.getCommitTime()).thenReturn((Object)commitTime);
        TxStateTransactionDataSnapshot transactionDataSnapshot = this.snapshot();
        org.junit.jupiter.api.Assertions.assertEquals((long)committedTransactionId, (long)transactionDataSnapshot.getTransactionId());
        org.junit.jupiter.api.Assertions.assertEquals((long)commitTime, (long)transactionDataSnapshot.getCommitTime());
    }

    @Test
    void shouldGetEmptyUsernameForAnonymousContext() {
        Mockito.when((Object)this.transaction.securityContext()).thenReturn((Object)AnonymousContext.read().authorize(LoginContext.IdLookup.EMPTY, "neo4j", (AbstractSecurityLog)CommunitySecurityLog.NULL_LOG));
        TxStateTransactionDataSnapshot transactionDataSnapshot = this.snapshot();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"", (Object)transactionDataSnapshot.username());
    }

    @Test
    void shouldAccessUsernameFromAuthSubject() {
        AuthSubject authSubject = (AuthSubject)Mockito.mock(AuthSubject.class);
        Mockito.when((Object)authSubject.username()).thenReturn((Object)"Christof");
        Mockito.when((Object)this.transaction.securityContext()).thenReturn((Object)new SecurityContext(authSubject, (AccessMode)AccessMode.Static.FULL, ClientConnectionInfo.EMBEDDED_CONNECTION, null));
        TxStateTransactionDataSnapshot transactionDataSnapshot = this.snapshot();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Christof", (Object)transactionDataSnapshot.username());
    }

    @Test
    void shouldAccessEmptyMetaData() {
        TxStateTransactionDataSnapshot transactionDataSnapshot = this.snapshot();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)transactionDataSnapshot.metaData().size());
    }

    @Test
    void shouldAccessExampleMetaData() {
        Mockito.when((Object)this.transaction.getMetaData()).thenReturn((Object)MapUtil.genericMap((Object[])new Object[]{"username", "Igor"}));
        TxStateTransactionDataSnapshot transactionDataSnapshot = new TxStateTransactionDataSnapshot((ReadableTransactionState)this.state, (StorageReader)this.ops, (KernelTransaction)this.transaction);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)transactionDataSnapshot.metaData().size());
        ((MapAssert)Assertions.assertThat((Map)transactionDataSnapshot.metaData()).as("Expected metadata map to contain defined username", new Object[0])).isEqualTo((Object)MapUtil.genericMap((Object[])new Object[]{"username", "Igor"}));
    }

    private static List<Long> idList(Iterable<? extends Entity> entities) {
        ArrayList<Long> out = new ArrayList<Long>();
        for (Entity entity : entities) {
            out.add(entity instanceof Node ? entity.getId() : entity.getId());
        }
        return out;
    }

    private TxStateTransactionDataSnapshot snapshot() {
        Mockito.when((Object)this.internalTransaction.newNodeEntity(ArgumentMatchers.anyLong())).thenAnswer(invocation -> new NodeEntity(this.internalTransaction, ((Long)invocation.getArgument(0)).longValue()));
        Mockito.when((Object)this.internalTransaction.newRelationshipEntity(ArgumentMatchers.anyLong())).thenAnswer(invocation -> new RelationshipEntity(this.internalTransaction, ((Long)invocation.getArgument(0)).longValue()));
        Mockito.when((Object)this.internalTransaction.newRelationshipEntity(ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyLong())).thenAnswer(invocation -> new RelationshipEntity(this.internalTransaction, ((Long)invocation.getArgument(0)).longValue(), ((Long)invocation.getArgument(1)).longValue(), ((Integer)invocation.getArgument(2)).intValue(), ((Long)invocation.getArgument(3)).longValue()));
        return new TxStateTransactionDataSnapshot((ReadableTransactionState)this.state, (StorageReader)this.ops, (KernelTransaction)this.transaction);
    }
}

