/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.trackable;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.collection.trackable.HeapTrackingCollections;
import org.neo4j.collection.trackable.HeapTrackingLongStack;
import org.neo4j.memory.LocalMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.rule.RandomRule;

@ExtendWith(value={RandomExtension.class})
class HeapTrackingLongStackTest {
    private final MemoryTracker memoryTracker = new LocalMemoryTracker();
    private HeapTrackingLongStack aStack;
    private long[] longArray;
    @Inject
    private RandomRule random;

    HeapTrackingLongStackTest() {
    }

    @BeforeEach
    void setUp() {
        this.longArray = new long[100];
        for (int i = 0; i < this.longArray.length; ++i) {
            this.longArray[i] = i;
        }
        this.aStack = HeapTrackingCollections.newLongStack((MemoryTracker)this.memoryTracker);
        for (long l : this.longArray) {
            this.aStack.push(l);
        }
    }

    @AfterEach
    void tearDown() {
        this.longArray = null;
        this.aStack.close();
        Assertions.assertEquals((long)0L, (long)this.memoryTracker.estimatedHeapMemory(), (String)"Leaking memory");
    }

    @Test
    void pop() {
        Assertions.assertEquals((int)100, (int)this.aStack.size(), (String)"Returned incorrect size for existing list");
        int i = 99;
        while (this.aStack.notEmpty()) {
            Assertions.assertEquals((long)i--, (long)this.aStack.pop());
        }
        Assertions.assertEquals((int)-1, (int)i);
        Assertions.assertEquals((int)0, (int)this.aStack.size(), (String)"Returned incorrect size for modified list");
    }

    @Test
    void peek() {
        Assertions.assertEquals((int)100, (int)this.aStack.size(), (String)"Returned incorrect size for existing list");
        Assertions.assertEquals((long)99L, (long)this.aStack.peek());
        Assertions.assertEquals((int)100, (int)this.aStack.size(), (String)"Returned incorrect size for existing list");
    }

    @Test
    void push() {
        Assertions.assertEquals((int)100, (int)this.aStack.size(), (String)"Returned incorrect size for existing list");
        this.aStack.push(42L);
        Assertions.assertEquals((long)42L, (long)this.aStack.peek());
        Assertions.assertEquals((int)101, (int)this.aStack.size(), (String)"Returned incorrect size for modified list");
    }
}

