/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.util.Collections;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.commons.lang3.mutable.MutableLong;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.graphdb.TransientFailureException;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.availability.DatabaseAvailabilityGuard;
import org.neo4j.kernel.impl.coreapi.TransactionImpl;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.kernel.impl.query.TransactionalContextFactory;
import org.neo4j.token.TokenHolders;

class TransactionImplTest {
    private final TokenHolders tokenHolders = (TokenHolders)Mockito.mock(TokenHolders.class);
    private final QueryExecutionEngine engine = (QueryExecutionEngine)Mockito.mock(QueryExecutionEngine.class);
    private final TransactionalContextFactory contextFactory = (TransactionalContextFactory)Mockito.mock(TransactionalContextFactory.class);
    private final DatabaseAvailabilityGuard availabilityGuard = (DatabaseAvailabilityGuard)Mockito.mock(DatabaseAvailabilityGuard.class);

    TransactionImplTest() {
    }

    @Test
    void shouldThrowTransientExceptionOnTransientKernelException() throws Exception {
        KernelTransaction kernelTransaction = (KernelTransaction)Mockito.mock(KernelTransaction.class);
        Mockito.when((Object)kernelTransaction.isOpen()).thenReturn((Object)true);
        ((KernelTransaction)Mockito.doThrow((Throwable[])new Throwable[]{new TransactionFailureException((Status)Status.Transaction.ConstraintsChanged, "Proving that transaction does the right thing", new Object[0])}).when((Object)kernelTransaction)).close();
        TransactionImpl transaction = new TransactionImpl(this.tokenHolders, this.contextFactory, this.availabilityGuard, this.engine, kernelTransaction, null, null);
        transaction.commit();
    }

    @Test
    void shouldThrowTransactionExceptionOnTransientKernelException() throws Exception {
        KernelTransaction kernelTransaction = (KernelTransaction)Mockito.mock(KernelTransaction.class);
        Mockito.when((Object)kernelTransaction.isOpen()).thenReturn((Object)true);
        ((KernelTransaction)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("Just a random failure")}).when((Object)kernelTransaction)).close();
        TransactionImpl transaction = new TransactionImpl(this.tokenHolders, this.contextFactory, this.availabilityGuard, this.engine, kernelTransaction, null, null);
        transaction.commit();
    }

    @Test
    void shouldLetThroughTransientFailureException() throws Exception {
        KernelTransaction kernelTransaction = (KernelTransaction)Mockito.mock(KernelTransaction.class);
        Mockito.when((Object)kernelTransaction.isOpen()).thenReturn((Object)true);
        ((KernelTransaction)Mockito.doThrow((Throwable[])new Throwable[]{new TransientFailureException("Just a random failure"){

            public Status status() {
                return null;
            }
        }}).when((Object)kernelTransaction)).close();
        TransactionImpl transaction = new TransactionImpl(this.tokenHolders, this.contextFactory, this.availabilityGuard, this.engine, kernelTransaction, null, null);
        transaction.commit();
    }

    @Test
    void shouldShowTransactionTerminatedExceptionAsTransient() throws Exception {
        KernelTransaction kernelTransaction = (KernelTransaction)Mockito.mock(KernelTransaction.class);
        ((KernelTransaction)Mockito.doReturn((Object)true).when((Object)kernelTransaction)).isOpen();
        TransactionTerminatedException error = new TransactionTerminatedException((Status)Status.Transaction.Terminated);
        ((KernelTransaction)Mockito.doThrow((Throwable[])new Throwable[]{error}).when((Object)kernelTransaction)).close();
        TransactionImpl transaction = new TransactionImpl(this.tokenHolders, this.contextFactory, this.availabilityGuard, this.engine, kernelTransaction, null, null);
        transaction.commit();
    }

    @Test
    void shouldReturnTerminationReason() {
        KernelTransaction kernelTransaction = (KernelTransaction)Mockito.mock(KernelTransaction.class);
        Mockito.when((Object)kernelTransaction.getReasonIfTerminated()).thenReturn(Optional.empty()).thenReturn(Optional.of(Status.Transaction.Terminated));
        TransactionImpl tx = new TransactionImpl(this.tokenHolders, this.contextFactory, this.availabilityGuard, this.engine, kernelTransaction, null, null);
        Optional terminationReason1 = tx.terminationReason();
        Optional terminationReason2 = tx.terminationReason();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)terminationReason1.isPresent());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)terminationReason2.isPresent());
        org.junit.jupiter.api.Assertions.assertEquals((Object)Status.Transaction.Terminated, terminationReason2.get());
    }

    @Test
    void fireCallbackOnClose() {
        KernelTransaction kernelTransaction = (KernelTransaction)Mockito.mock(KernelTransaction.class);
        MutableLong calls = new MutableLong();
        try (TransactionImpl tx = new TransactionImpl(this.tokenHolders, this.contextFactory, this.availabilityGuard, this.engine, kernelTransaction, null, null);){
            tx.addCloseCallback(() -> ((MutableLong)calls).increment());
            tx.commit();
        }
        tx = new TransactionImpl(this.tokenHolders, this.contextFactory, this.availabilityGuard, this.engine, kernelTransaction, null, null);
        try {
            tx.addCloseCallback(() -> ((MutableLong)calls).increment());
            tx.rollback();
        }
        finally {
            tx.close();
        }
        tx = new TransactionImpl(this.tokenHolders, this.contextFactory, this.availabilityGuard, this.engine, kernelTransaction, null, null);
        try {
            tx.addCloseCallback(() -> ((MutableLong)calls).increment());
        }
        finally {
            tx.close();
        }
        org.junit.jupiter.api.Assertions.assertEquals((long)3L, (long)calls.longValue());
    }

    @Test
    void testFindNodesValidation() {
        this.checkForIAE(tx -> tx.findNodes(null), "Label");
        this.checkForIAE(tx -> tx.findNodes(null, "key", (Object)"value"), "Label");
        this.checkForIAE(tx -> tx.findNodes(Label.label((String)"test"), null, null), "Property key");
        this.checkForIAE(tx -> tx.findNodes(Label.label((String)"test"), "key", null), "property value");
        this.checkForIAE(tx -> tx.findNodes(null, "key", "template", null), "Label");
        this.checkForIAE(tx -> tx.findNodes(Label.label((String)"test"), null, "template", null), "Property key");
        this.checkForIAE(tx -> tx.findNodes(Label.label((String)"test"), "key", null, null), "Template");
        this.checkForIAE(tx -> tx.findNodes(null, "key", (Object)"value", "key", (Object)"value"), "Label");
        this.checkForIAE(tx -> tx.findNodes(Label.label((String)"test"), null, (Object)"value", "key", (Object)"value"), "Property key");
        this.checkForIAE(tx -> tx.findNodes(Label.label((String)"test"), "key", null, "key", (Object)"value"), "property value");
        this.checkForIAE(tx -> tx.findNodes(Label.label((String)"test"), "key", (Object)"value", null, (Object)"value"), "Property key");
        this.checkForIAE(tx -> tx.findNodes(Label.label((String)"test"), "key", (Object)"value", "key", null), "property value");
        this.checkForIAE(tx -> tx.findNodes(null, "key", (Object)"value", "key", (Object)"value", "key", (Object)"value"), "Label");
        this.checkForIAE(tx -> tx.findNodes(Label.label((String)"test"), null, (Object)"value", "key", (Object)"value", "key", (Object)"value"), "Property key");
        this.checkForIAE(tx -> tx.findNodes(Label.label((String)"test"), "key", null, "key", (Object)"value", "key", (Object)"value"), "property value");
        this.checkForIAE(tx -> tx.findNodes(Label.label((String)"test"), "key", (Object)"value", "key", (Object)"value", null, (Object)"value"), "Property key");
        this.checkForIAE(tx -> tx.findNodes(Label.label((String)"test"), "key", (Object)"value", "key", (Object)"value", "key", null), "property value");
        this.checkForIAE(tx -> tx.findNodes(null, Collections.emptyMap()), "Label");
        this.checkForIAE(tx -> tx.findNodes(Label.label((String)"test"), null), "Property values");
    }

    @Test
    void testFindRelationshipsValidation() {
        this.checkForIAE(tx -> tx.findRelationships(null), "Relationship type");
        this.checkForIAE(tx -> tx.findRelationships(null, "key", (Object)"value"), "Relationship type");
        this.checkForIAE(tx -> tx.findRelationships(RelationshipType.withName((String)"test"), null, null), "Property key");
        this.checkForIAE(tx -> tx.findRelationships(RelationshipType.withName((String)"test"), "key", null), "property value");
        this.checkForIAE(tx -> tx.findRelationships(null, "key", "template", null), "Relationship type");
        this.checkForIAE(tx -> tx.findRelationships(RelationshipType.withName((String)"test"), null, "template", null), "Property key");
        this.checkForIAE(tx -> tx.findRelationships(RelationshipType.withName((String)"test"), "key", null, null), "Template");
        this.checkForIAE(tx -> tx.findRelationships(null, "key", (Object)"value", "key", (Object)"value"), "Relationship type");
        this.checkForIAE(tx -> tx.findRelationships(RelationshipType.withName((String)"test"), null, (Object)"value", "key", (Object)"value"), "Property key");
        this.checkForIAE(tx -> tx.findRelationships(RelationshipType.withName((String)"test"), "key", null, "key", (Object)"value"), "property value");
        this.checkForIAE(tx -> tx.findRelationships(RelationshipType.withName((String)"test"), "key", (Object)"value", null, (Object)"value"), "Property key");
        this.checkForIAE(tx -> tx.findRelationships(RelationshipType.withName((String)"test"), "key", (Object)"value", "key", null), "property value");
        this.checkForIAE(tx -> tx.findRelationships(null, "key", (Object)"value", "key", (Object)"value", "key", (Object)"value"), "Relationship type");
        this.checkForIAE(tx -> tx.findRelationships(RelationshipType.withName((String)"test"), null, (Object)"value", "key", (Object)"value", "key", (Object)"value"), "Property key");
        this.checkForIAE(tx -> tx.findRelationships(RelationshipType.withName((String)"test"), "key", null, "key", (Object)"value", "key", (Object)"value"), "property value");
        this.checkForIAE(tx -> tx.findRelationships(RelationshipType.withName((String)"test"), "key", (Object)"value", "key", (Object)"value", null, (Object)"value"), "Property key");
        this.checkForIAE(tx -> tx.findRelationships(RelationshipType.withName((String)"test"), "key", (Object)"value", "key", (Object)"value", "key", null), "property value");
        this.checkForIAE(tx -> tx.findRelationships(null, Collections.emptyMap()), "Relationship type");
        this.checkForIAE(tx -> tx.findRelationships(RelationshipType.withName((String)"test"), null), "Property values");
    }

    private void checkForIAE(Consumer<Transaction> consumer, String message) {
        KernelTransaction kernelTransaction = (KernelTransaction)Mockito.mock(KernelTransaction.class);
        Mockito.when((Object)kernelTransaction.tokenRead()).thenReturn((Object)((TokenRead)Mockito.mock(TokenRead.class)));
        try (TransactionImpl tx = new TransactionImpl(this.tokenHolders, this.contextFactory, this.availabilityGuard, this.engine, kernelTransaction, null, null);){
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> consumer.accept((Transaction)tx)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining(message);
        }
    }
}

