/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.factory;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.configuration.helpers.DatabaseReadOnlyChecker;
import org.neo4j.kernel.database.TestDatabaseIdRepository;
import org.neo4j.kernel.impl.api.DatabaseTransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.factory.CommunityCommitProcessFactory;
import org.neo4j.kernel.impl.transaction.log.TransactionAppender;
import org.neo4j.storageengine.api.StorageEngine;

class CommunityCommitProcessFactoryTest {
    CommunityCommitProcessFactoryTest() {
    }

    @Test
    void createRegularCommitProcessWhenWritable() {
        CommunityCommitProcessFactory factory = new CommunityCommitProcessFactory();
        TransactionCommitProcess commitProcess = factory.create((TransactionAppender)Mockito.mock(TransactionAppender.class), (StorageEngine)Mockito.mock(StorageEngine.class), TestDatabaseIdRepository.randomNamedDatabaseId(), DatabaseReadOnlyChecker.writable());
        Assertions.assertThat((Object)commitProcess).isInstanceOf(DatabaseTransactionCommitProcess.class);
    }

    @Test
    void createRegularCommitProcessWhenDynamicallyReadOnly() {
        CommunityCommitProcessFactory factory = new CommunityCommitProcessFactory();
        TransactionCommitProcess commitProcess = factory.create((TransactionAppender)Mockito.mock(TransactionAppender.class), (StorageEngine)Mockito.mock(StorageEngine.class), TestDatabaseIdRepository.randomNamedDatabaseId(), DatabaseReadOnlyChecker.readOnly());
        Assertions.assertThat((Object)commitProcess).isInstanceOf(DatabaseTransactionCommitProcess.class);
    }
}

