/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.config;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.Config;
import org.neo4j.gis.spatial.index.Envelope;
import org.neo4j.kernel.impl.index.schema.config.ConfiguredSpaceFillingCurveSettingsCache;
import org.neo4j.kernel.impl.index.schema.config.CrsConfig;
import org.neo4j.kernel.impl.index.schema.config.SpaceFillingCurveSettings;
import org.neo4j.values.storable.CoordinateReferenceSystem;

class SpaceFillingCurveSettingsFactoryTest {
    SpaceFillingCurveSettingsFactoryTest() {
    }

    @Test
    void shouldGetDefaultSpaceFillingCurveSettingsForWGS84() {
        SpaceFillingCurveSettingsFactoryTest.shouldGetSettingsFor(Config.defaults(), CoordinateReferenceSystem.WGS84, 2, new Envelope(-180.0, 180.0, -90.0, 90.0));
    }

    @Test
    void shouldGetDefaultSpaceFillingCurveSettingsForWGS84_3D() {
        SpaceFillingCurveSettingsFactoryTest.shouldGetSettingsFor(Config.defaults(), CoordinateReferenceSystem.WGS84_3D, 3, new Envelope(new double[]{-180.0, -90.0, -1000000.0}, new double[]{180.0, 90.0, 1000000.0}));
    }

    @Test
    void shouldGetDefaultSpaceFillingCurveSettingsForCartesian() {
        SpaceFillingCurveSettingsFactoryTest.shouldGetSettingsFor(Config.defaults(), CoordinateReferenceSystem.Cartesian, 2, new Envelope(-1000000.0, 1000000.0, -1000000.0, 1000000.0));
    }

    @Test
    void shouldGetDefaultSpaceFillingCurveSettingsForCartesian_3D() {
        SpaceFillingCurveSettingsFactoryTest.shouldGetSettingsFor(Config.defaults(), CoordinateReferenceSystem.Cartesian_3D, 3, new Envelope(new double[]{-1000000.0, -1000000.0, -1000000.0}, new double[]{1000000.0, 1000000.0, 1000000.0}));
    }

    @Test
    void shouldGetModifiedSpaceFillingCurveSettingsForWGS84() {
        CoordinateReferenceSystem crs = CoordinateReferenceSystem.WGS84;
        for (int minx = -180; minx < 0; minx += 45) {
            for (int miny = -180; miny < 0; miny += 45) {
                for (int width = 10; width < 90; width += 40) {
                    for (int height = 10; height < 90; height += 40) {
                        SpaceFillingCurveSettingsFactoryTest.shouldGetCustomSettingsFor(crs, new double[]{minx, miny}, new double[]{minx + width, miny + height});
                    }
                }
            }
        }
    }

    @Test
    void shouldGetModifiedSpaceFillingCurveSettingsForWGS84_3D() {
        CoordinateReferenceSystem crs = CoordinateReferenceSystem.WGS84_3D;
        SpaceFillingCurveSettingsFactoryTest.shouldGetCustomSettingsFor(crs, new double[]{-180.0, -90.0, -1000000.0}, new double[]{180.0, 90.0, 1000000.0});
        SpaceFillingCurveSettingsFactoryTest.shouldGetCustomSettingsFor(crs, new double[]{0.0, -90.0, -1000000.0}, new double[]{180.0, 0.0, 1000000.0});
        SpaceFillingCurveSettingsFactoryTest.shouldGetCustomSettingsFor(crs, new double[]{-90.0, -45.0, -1000.0}, new double[]{90.0, 45.0, 1000.0});
        SpaceFillingCurveSettingsFactoryTest.shouldGetCustomSettingsFor(crs, new double[]{-90.0, -90.0, -1000.0}, new double[]{90.0, 45.0, 1000.0});
        SpaceFillingCurveSettingsFactoryTest.shouldGetCustomSettingsFor(crs, new double[]{-1000.0, -1000.0, -1000.0}, new double[]{1000.0, 1000.0, 1000.0});
    }

    @Test
    void shouldGetModifiedSpaceFillingCurveSettingsForCartesian() {
        CoordinateReferenceSystem crs = CoordinateReferenceSystem.Cartesian;
        for (int maxBits = 30; maxBits <= 60; maxBits += 10) {
            for (int minx = -1000000; minx < 0; minx += 200000) {
                for (int miny = -1000000; miny < 0; miny += 2000000) {
                    for (int width = 100000; width < 1000000; width += 200000) {
                        for (int height = 100000; height < 1000000; height += 200000) {
                            SpaceFillingCurveSettingsFactoryTest.shouldGetCustomSettingsFor(crs, new double[]{minx, miny}, new double[]{minx + width, miny + height});
                        }
                    }
                }
            }
        }
    }

    @Test
    void shouldGetModifiedSpaceFillingCurveSettingsForCartesian_3D() {
        CoordinateReferenceSystem crs = CoordinateReferenceSystem.Cartesian_3D;
        SpaceFillingCurveSettingsFactoryTest.shouldGetCustomSettingsFor(crs, new double[]{-1000000.0, -1000000.0, -1000000.0}, new double[]{1000000.0, 1000000.0, 1000000.0});
        SpaceFillingCurveSettingsFactoryTest.shouldGetCustomSettingsFor(crs, new double[]{0.0, -1000000.0, -1000000.0}, new double[]{1000000.0, 0.0, 1000000.0});
        SpaceFillingCurveSettingsFactoryTest.shouldGetCustomSettingsFor(crs, new double[]{-1000.0, -1000.0, -1000.0}, new double[]{1000.0, 1000.0, 1000.0});
        SpaceFillingCurveSettingsFactoryTest.shouldGetCustomSettingsFor(crs, new double[]{-1.0E9, -1.0E9, -1.0E9}, new double[]{1.0E9, 1.0E9, 1.0E9});
    }

    private static void shouldGetCustomSettingsFor(CoordinateReferenceSystem crs, double[] min, double[] max) {
        CrsConfig crsConf = CrsConfig.group((CoordinateReferenceSystem)crs);
        Config config = Config.newBuilder().set(crsConf.min, Arrays.stream(min).boxed().collect(Collectors.toList())).set(crsConf.max, Arrays.stream(max).boxed().collect(Collectors.toList())).build();
        SpaceFillingCurveSettingsFactoryTest.shouldGetSettingsFor(config, crs, min.length, new Envelope(min, max));
    }

    private static void shouldGetSettingsFor(Config config, CoordinateReferenceSystem crs, int dimensions, Envelope envelope) {
        ConfiguredSpaceFillingCurveSettingsCache configuredSettings = new ConfiguredSpaceFillingCurveSettingsCache(config);
        SpaceFillingCurveSettings settings = configuredSettings.forCRS(crs);
        ((AbstractIntegerAssert)Assertions.assertThat((int)settings.getDimensions()).as("Expected " + dimensions + "D for " + crs.getName(), new Object[0])).isEqualTo(dimensions);
        ((ObjectAssert)Assertions.assertThat((Object)settings.indexExtents()).as("Should have normal geographic 2D extents", new Object[0])).isEqualTo((Object)envelope);
    }
}

