/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.storageengine.api.TransactionId;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.util.concurrent.ArrayQueueOutOfOrderSequence;
import org.neo4j.util.concurrent.OutOfOrderSequence;

public class SimpleTransactionIdStore
implements TransactionIdStore {
    private final AtomicLong committingTransactionId = new AtomicLong();
    private final OutOfOrderSequence closedTransactionId = new ArrayQueueOutOfOrderSequence(-1L, 100, new long[1]);
    private final AtomicReference<TransactionId> committedTransactionId = new AtomicReference<TransactionId>(new TransactionId(1L, -559063315, 0L));
    private final long previouslyCommittedTxId;
    private final int initialTransactionChecksum;
    private final long previouslyCommittedTxCommitTimestamp;

    public SimpleTransactionIdStore() {
        this(1L, -559063315, 0L, 0L, 64L);
    }

    public SimpleTransactionIdStore(long previouslyCommittedTxId, int checksum, long previouslyCommittedTxCommitTimestamp, long previouslyCommittedTxLogVersion, long previouslyCommittedTxLogByteOffset) {
        assert (previouslyCommittedTxId >= 1L) : "cannot start from a tx id less than BASE_TX_ID";
        this.setLastCommittedAndClosedTransactionId(previouslyCommittedTxId, checksum, previouslyCommittedTxCommitTimestamp, previouslyCommittedTxLogByteOffset, previouslyCommittedTxLogVersion, CursorContext.NULL);
        this.previouslyCommittedTxId = previouslyCommittedTxId;
        this.initialTransactionChecksum = checksum;
        this.previouslyCommittedTxCommitTimestamp = previouslyCommittedTxCommitTimestamp;
    }

    public long nextCommittingTransactionId() {
        return this.committingTransactionId.incrementAndGet();
    }

    public long committingTransactionId() {
        return this.committingTransactionId.get();
    }

    public synchronized void transactionCommitted(long transactionId, int checksum, long commitTimestamp, CursorContext cursorContext) {
        TransactionId current = this.committedTransactionId.get();
        if (current == null || transactionId > current.transactionId()) {
            this.committedTransactionId.set(new TransactionId(transactionId, checksum, commitTimestamp));
        }
    }

    public long getLastCommittedTransactionId() {
        return this.committedTransactionId.get().transactionId();
    }

    public TransactionId getLastCommittedTransaction() {
        return this.committedTransactionId.get();
    }

    public TransactionId getUpgradeTransaction() {
        return new TransactionId(this.previouslyCommittedTxId, this.initialTransactionChecksum, this.previouslyCommittedTxCommitTimestamp);
    }

    public long getLastClosedTransactionId() {
        return this.closedTransactionId.getHighestGapFreeNumber();
    }

    public long[] getLastClosedTransaction() {
        return this.closedTransactionId.get();
    }

    public void setLastCommittedAndClosedTransactionId(long transactionId, int checksum, long commitTimestamp, long byteOffset, long logVersion, CursorContext cursorContext) {
        this.committingTransactionId.set(transactionId);
        this.committedTransactionId.set(new TransactionId(transactionId, checksum, commitTimestamp));
        this.closedTransactionId.set(transactionId, new long[]{logVersion, byteOffset});
    }

    public void transactionClosed(long transactionId, long logVersion, long byteOffset, CursorContext cursorContext) {
        this.closedTransactionId.offer(transactionId, new long[]{logVersion, byteOffset});
    }

    public void resetLastClosedTransaction(long transactionId, long byteOffset, long logVersion, boolean missingLogs, CursorContext cursorContext) {
        this.closedTransactionId.set(transactionId, new long[]{logVersion, byteOffset});
    }

    public void flush(CursorContext cursorContext) {
    }
}

