/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.nio.file.Path;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.memory.ByteBufferFactory;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.index.schema.BlockEntry;
import org.neo4j.kernel.impl.index.schema.IndexUpdateCursor;
import org.neo4j.kernel.impl.index.schema.IndexUpdateEntry;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexUpdater;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.SimpleEntryStorage;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.UpdateMode;
import org.neo4j.storageengine.api.ValueIndexEntryUpdate;

public class IndexUpdateStorage<KEY extends NativeIndexKey<KEY>, VALUE extends NativeIndexValue>
extends SimpleEntryStorage<IndexEntryUpdate<?>, IndexUpdateCursor<KEY, VALUE>> {
    private final Layout<KEY, VALUE> layout;
    private final KEY key1;
    private final KEY key2;
    private final VALUE value;

    IndexUpdateStorage(FileSystemAbstraction fs, Path file, ByteBufferFactory.Allocator byteBufferFactory, int blockSize, Layout<KEY, VALUE> layout, MemoryTracker memoryTracker) {
        super(fs, file, byteBufferFactory, blockSize, memoryTracker);
        this.layout = layout;
        this.key1 = (NativeIndexKey)((Object)layout.newKey());
        this.key2 = (NativeIndexKey)((Object)layout.newKey());
        this.value = (NativeIndexValue)layout.newValue();
    }

    @Override
    public void add(IndexEntryUpdate<?> update, PageCursor pageCursor) throws IOException {
        ValueIndexEntryUpdate valueUpdate = (ValueIndexEntryUpdate)update;
        int entrySize = 1;
        UpdateMode updateMode = valueUpdate.updateMode();
        switch (updateMode) {
            case ADDED: {
                NativeIndexUpdater.initializeKeyAndValueFromUpdate(this.key1, this.value, valueUpdate.getEntityId(), valueUpdate.values());
                entrySize += BlockEntry.entrySize(this.layout, this.key1, this.value);
                break;
            }
            case REMOVED: {
                NativeIndexUpdater.initializeKeyFromUpdate(this.key1, valueUpdate.getEntityId(), valueUpdate.values());
                entrySize += BlockEntry.keySize(this.layout, this.key1);
                break;
            }
            case CHANGED: {
                NativeIndexUpdater.initializeKeyFromUpdate(this.key1, valueUpdate.getEntityId(), valueUpdate.beforeValues());
                NativeIndexUpdater.initializeKeyAndValueFromUpdate(this.key2, this.value, valueUpdate.getEntityId(), valueUpdate.values());
                entrySize += BlockEntry.keySize(this.layout, this.key1) + BlockEntry.entrySize(this.layout, this.key2, this.value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown update mode " + updateMode);
            }
        }
        this.prepareWrite(entrySize);
        pageCursor.putByte((byte)updateMode.ordinal());
        IndexUpdateEntry.write(pageCursor, this.layout, updateMode, this.key1, this.key2, this.value);
    }

    @Override
    public IndexUpdateCursor<KEY, VALUE> reader(PageCursor pageCursor) {
        return new IndexUpdateCursor<KEY, VALUE>(pageCursor, this.layout);
    }
}

