/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.stats;

import org.neo4j.counts.CountsAccessor;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.id.IdType;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.store.stats.StoreEntityCounters;

public class DatabaseEntityCounters
implements StoreEntityCounters {
    private final IdGeneratorFactory idGeneratorFactory;
    private final CountsAccessor countsAccessor;

    public DatabaseEntityCounters(IdGeneratorFactory idGeneratorFactory, CountsAccessor countsAccessor) {
        this.idGeneratorFactory = idGeneratorFactory;
        this.countsAccessor = countsAccessor;
    }

    @Override
    public long nodes() {
        return this.idGeneratorFactory.get(IdType.NODE).getNumberOfIdsInUse();
    }

    @Override
    public long relationships() {
        return this.idGeneratorFactory.get(IdType.RELATIONSHIP).getNumberOfIdsInUse();
    }

    @Override
    public long properties() {
        return this.idGeneratorFactory.get(IdType.PROPERTY).getNumberOfIdsInUse();
    }

    @Override
    public long relationshipTypes() {
        return this.idGeneratorFactory.get(IdType.RELATIONSHIP_TYPE_TOKEN).getNumberOfIdsInUse();
    }

    @Override
    public long allNodesCountStore(CursorContext cursorContext) {
        return this.countsAccessor.nodeCount(-1, cursorContext);
    }

    @Override
    public long allRelationshipsCountStore(CursorContext cursorContext) {
        return this.countsAccessor.relationshipCount(-1, -1, -1, cursorContext);
    }
}

