/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.trackable;

import java.util.HashSet;
import org.assertj.core.api.Assertions;
import org.eclipse.collections.impl.block.factory.HashingStrategies;
import org.github.jamm.MemoryMeter;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.collection.trackable.HeapTrackingUnifiedIdentityHashingSet;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.LocalMemoryTracker;
import org.neo4j.memory.MemoryGroup;
import org.neo4j.memory.MemoryPool;
import org.neo4j.memory.MemoryPools;
import org.neo4j.memory.MemoryTracker;

class HeapTrackingUnifiedIdentityHashingSetTest {
    private static final long INTEGER_SIZE = HeapEstimator.shallowSizeOfInstance(Integer.class);
    private final MemoryMeter meter = new MemoryMeter();
    private MemoryPool memoryPool;
    private MemoryTracker memoryTracker;

    HeapTrackingUnifiedIdentityHashingSetTest() {
    }

    @BeforeEach
    void setUp() {
        this.memoryPool = new MemoryPools().pool(MemoryGroup.TRANSACTION, 0L, null);
        this.memoryTracker = new LocalMemoryTracker(this.memoryPool);
    }

    @Test
    void calculateEmptySize() {
        HeapTrackingUnifiedIdentityHashingSet unifiedSet = HeapTrackingUnifiedIdentityHashingSet.createUnifiedIdentityHashingSet((MemoryTracker)this.memoryTracker);
        this.assertExactEstimation(unifiedSet);
        unifiedSet.close();
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)this.memoryTracker.estimatedHeapMemory());
    }

    @Test
    void reactToGrowth() {
        long totalBytesIntegers = 0L;
        HeapTrackingUnifiedIdentityHashingSet unifiedSet = HeapTrackingUnifiedIdentityHashingSet.createUnifiedIdentityHashingSet((MemoryTracker)this.memoryTracker);
        this.assertExactEstimation(unifiedSet);
        HashSet<Integer> seenHashes = new HashSet<Integer>();
        for (int i = 0; i < 10; ++i) {
            Integer integer = i;
            if (!seenHashes.add(unifiedSet.getIndex((Object)integer))) continue;
            totalBytesIntegers += INTEGER_SIZE;
            this.memoryTracker.allocateHeap(INTEGER_SIZE);
            unifiedSet.add((Object)integer);
        }
        this.assertExactEstimation(unifiedSet);
        Assertions.assertThat((long)this.memoryPool.usedHeap()).isGreaterThanOrEqualTo(this.memoryTracker.estimatedHeapMemory());
        unifiedSet.close();
        this.memoryTracker.releaseHeap(totalBytesIntegers);
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)this.memoryTracker.estimatedHeapMemory());
        this.memoryTracker.reset();
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)this.memoryPool.usedHeap());
    }

    @Test
    void handleLargeArraysWithoutOverflowing() {
        Assertions.assertThat((long)HeapTrackingUnifiedIdentityHashingSet.arrayHeapSize((int)0x20000000)).isGreaterThan(0L);
    }

    private void assertExactEstimation(HeapTrackingUnifiedIdentityHashingSet<?> unifiedSet) {
        org.junit.jupiter.api.Assertions.assertEquals((long)(this.meter.measureDeep(unifiedSet) - this.meter.measureDeep((Object)this.memoryTracker) - this.meter.measureDeep((Object)HashingStrategies.identityStrategy())), (long)this.memoryTracker.estimatedHeapMemory());
    }
}

