/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api;

import java.util.concurrent.atomic.AtomicReference;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.neo4j.collection.Dependencies;
import org.neo4j.collection.pool.Pool;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.helpers.DatabaseReadOnlyChecker;
import org.neo4j.dbms.database.DbmsRuntimeRepository;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.security.AbstractSecurityLog;
import org.neo4j.internal.kernel.api.security.CommunitySecurityLog;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.schema.SchemaState;
import org.neo4j.io.pagecache.context.EmptyVersionContextSupplier;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.database.DatabaseTracers;
import org.neo4j.kernel.database.TestDatabaseIdRepository;
import org.neo4j.kernel.impl.api.InternalTransactionCommitProcess;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.LeaseService;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.kernel.impl.api.state.ConstraintIndexCreator;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.constraints.StandardConstraintSemantics;
import org.neo4j.kernel.impl.factory.CanWrite;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.NoOpClient;
import org.neo4j.kernel.impl.query.TransactionExecutionMonitor;
import org.neo4j.kernel.impl.transaction.TransactionMonitor;
import org.neo4j.kernel.impl.util.collection.CollectionsFactorySupplier;
import org.neo4j.kernel.internal.event.DatabaseTransactionEventListeners;
import org.neo4j.memory.MemoryPools;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.resources.CpuClock;
import org.neo4j.storageengine.api.CommandCreationContext;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.time.Clocks;
import org.neo4j.token.TokenHolders;
import org.neo4j.token.api.TokenHolder;

public final class KernelTransactionFactory {
    private KernelTransactionFactory() {
    }

    private static Instances kernelTransactionWithInternals(LoginContext loginContext) {
        StorageEngine storageEngine = (StorageEngine)Mockito.mock(StorageEngine.class);
        StorageReader storageReader = (StorageReader)Mockito.mock(StorageReader.class);
        Mockito.when((Object)storageEngine.newReader()).thenReturn((Object)storageReader);
        Mockito.when((Object)storageEngine.newCommandCreationContext((MemoryTracker)ArgumentMatchers.any())).thenReturn((Object)((CommandCreationContext)Mockito.mock(CommandCreationContext.class)));
        Dependencies dependencies = new Dependencies();
        dependencies.satisfyDependency((Object)((GraphDatabaseFacade)Mockito.mock(GraphDatabaseFacade.class)));
        KernelTransactionImplementation transaction = new KernelTransactionImplementation(Config.defaults(), (DatabaseTransactionEventListeners)Mockito.mock(DatabaseTransactionEventListeners.class), (ConstraintIndexCreator)Mockito.mock(ConstraintIndexCreator.class), (GlobalProcedures)Mockito.mock(GlobalProcedures.class), (TransactionCommitProcess)Mockito.mock(InternalTransactionCommitProcess.class), (TransactionMonitor)Mockito.mock(TransactionMonitor.class), (Pool)Mockito.mock(Pool.class), Clocks.nanoClock(), new AtomicReference<CpuClock>(CpuClock.NOT_AVAILABLE), (DatabaseTracers)Mockito.mock(DatabaseTracers.class, (Answer)Mockito.RETURNS_MOCKS), storageEngine, any -> CanWrite.INSTANCE, EmptyVersionContextSupplier.EMPTY, CollectionsFactorySupplier.ON_HEAP, (ConstraintSemantics)new StandardConstraintSemantics(), (SchemaState)Mockito.mock(SchemaState.class), KernelTransactionFactory.mockedTokenHolders(), (IndexingService)Mockito.mock(IndexingService.class), (IndexStatisticsStore)Mockito.mock(IndexStatisticsStore.class), dependencies, new TestDatabaseIdRepository().defaultDatabase(), LeaseService.NO_LEASES, MemoryPools.NO_TRACKING, DatabaseReadOnlyChecker.writable(), TransactionExecutionMonitor.NO_OP, (AbstractSecurityLog)CommunitySecurityLog.NULL_LOG, () -> KernelVersion.LATEST, (DbmsRuntimeRepository)Mockito.mock(DbmsRuntimeRepository.class));
        transaction.initialize(0L, 0L, (Locks.Client)new NoOpClient(), KernelTransaction.Type.IMPLICIT, loginContext.authorize(LoginContext.IdLookup.EMPTY, "neo4j", (AbstractSecurityLog)CommunitySecurityLog.NULL_LOG), 0L, 1L, ClientConnectionInfo.EMBEDDED_CONNECTION);
        return new Instances(transaction);
    }

    private static TokenHolders mockedTokenHolders() {
        return new TokenHolders((TokenHolder)Mockito.mock(TokenHolder.class), (TokenHolder)Mockito.mock(TokenHolder.class), (TokenHolder)Mockito.mock(TokenHolder.class));
    }

    static KernelTransaction kernelTransaction(LoginContext loginContext) {
        return KernelTransactionFactory.kernelTransactionWithInternals((LoginContext)loginContext).transaction;
    }

    public static class Instances {
        public KernelTransactionImplementation transaction;

        Instances(KernelTransactionImplementation transaction) {
            this.transaction = transaction;
        }
    }
}

