/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.api.index.IndexMap;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.IndexUpdaterMap;
import org.neo4j.kernel.impl.api.index.TestIndexProviderDescriptor;

class IndexUpdaterMapTest {
    private IndexMap indexMap;
    private IndexProxy indexProxy1;
    private IndexDescriptor schemaIndexDescriptor1;
    private IndexUpdater indexUpdater1;
    private IndexProxy indexProxy2;
    private IndexDescriptor schemaIndexDescriptor;
    private IndexUpdaterMap updaterMap;

    IndexUpdaterMapTest() {
    }

    @BeforeEach
    void before() {
        this.indexMap = new IndexMap();
        this.indexProxy1 = (IndexProxy)Mockito.mock(IndexProxy.class);
        this.schemaIndexDescriptor1 = IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)2, (int[])new int[]{3}), (IndexProviderDescriptor)TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR).withName("a").materialise(0L);
        this.indexUpdater1 = (IndexUpdater)Mockito.mock(IndexUpdater.class);
        Mockito.when((Object)this.indexProxy1.getDescriptor()).thenReturn((Object)this.schemaIndexDescriptor1);
        Mockito.when((Object)this.indexProxy1.newUpdater((IndexUpdateMode)ArgumentMatchers.any(IndexUpdateMode.class), (CursorContext)ArgumentMatchers.any(CursorContext.class))).thenReturn((Object)this.indexUpdater1);
        this.indexProxy2 = (IndexProxy)Mockito.mock(IndexProxy.class);
        this.schemaIndexDescriptor = IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)5, (int[])new int[]{6}), (IndexProviderDescriptor)TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR).withName("b").materialise(1L);
        IndexUpdater indexUpdater2 = (IndexUpdater)Mockito.mock(IndexUpdater.class);
        Mockito.when((Object)this.indexProxy2.getDescriptor()).thenReturn((Object)this.schemaIndexDescriptor);
        Mockito.when((Object)this.indexProxy2.newUpdater((IndexUpdateMode)ArgumentMatchers.any(IndexUpdateMode.class), (CursorContext)ArgumentMatchers.any(CursorContext.class))).thenReturn((Object)indexUpdater2);
        this.updaterMap = new IndexUpdaterMap(this.indexMap, IndexUpdateMode.ONLINE);
    }

    @Test
    void shouldRetrieveUpdaterFromIndexMapForExistingIndex() {
        this.indexMap.putIndexProxy(this.indexProxy1);
        IndexUpdater updater = this.updaterMap.getUpdater(this.schemaIndexDescriptor1, CursorContext.NULL);
        org.junit.jupiter.api.Assertions.assertEquals((Object)this.indexUpdater1, (Object)updater);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)this.updaterMap.size());
    }

    @Test
    void shouldRetrieveUpdateUsingLabelAndProperty() {
        this.indexMap.putIndexProxy(this.indexProxy1);
        IndexUpdater updater = this.updaterMap.getUpdater(this.schemaIndexDescriptor1, CursorContext.NULL);
        Assertions.assertThat((Object)updater).isEqualTo((Object)this.indexUpdater1);
    }

    @Test
    void shouldRetrieveSameUpdaterFromIndexMapForExistingIndexWhenCalledTwice() {
        this.indexMap.putIndexProxy(this.indexProxy1);
        IndexUpdater updater1 = this.updaterMap.getUpdater(this.schemaIndexDescriptor1, CursorContext.NULL);
        IndexUpdater updater2 = this.updaterMap.getUpdater(this.schemaIndexDescriptor1, CursorContext.NULL);
        org.junit.jupiter.api.Assertions.assertEquals((Object)updater1, (Object)updater2);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)this.updaterMap.size());
    }

    @Test
    void shouldRetrieveNoUpdaterForNonExistingIndex() {
        IndexUpdater updater = this.updaterMap.getUpdater(this.schemaIndexDescriptor1, CursorContext.NULL);
        org.junit.jupiter.api.Assertions.assertNull((Object)updater);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.updaterMap.isEmpty(), (String)"updater map must be empty");
    }

    @Test
    void shouldCloseAllUpdaters() throws Exception {
        this.indexMap.putIndexProxy(this.indexProxy1);
        this.indexMap.putIndexProxy(this.indexProxy2);
        IndexUpdater updater1 = this.updaterMap.getUpdater(this.schemaIndexDescriptor1, CursorContext.NULL);
        IndexUpdater updater2 = this.updaterMap.getUpdater(this.schemaIndexDescriptor, CursorContext.NULL);
        this.updaterMap.close();
        ((IndexUpdater)Mockito.verify((Object)updater1)).close();
        ((IndexUpdater)Mockito.verify((Object)updater2)).close();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.updaterMap.isEmpty(), (String)"updater map must be empty");
    }
}

