/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.Arrays;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mockito;
import org.neo4j.configuration.Config;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.kernel.api.schema.SchemaTestUtil;
import org.neo4j.kernel.impl.index.schema.CompositeGenericKey;
import org.neo4j.kernel.impl.index.schema.GenericIndexKeyValidator;
import org.neo4j.kernel.impl.index.schema.GenericKey;
import org.neo4j.kernel.impl.index.schema.GenericLayout;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.config.IndexSpecificSpaceFillingCurveSettings;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@ExtendWith(value={RandomExtension.class})
class GenericIndexKeyValidatorTest {
    private final IndexDescriptor descriptor = IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)1, (int[])new int[]{1})).withName("test").materialise(1L);
    @Inject
    private RandomRule random;

    GenericIndexKeyValidatorTest() {
    }

    @Test
    void shouldNotBotherSerializingToRealBytesIfFarFromThreshold() {
        Layout layout = (Layout)Mockito.mock(Layout.class);
        ((Layout)Mockito.doThrow(RuntimeException.class).when((Object)layout)).newKey();
        GenericIndexKeyValidator validator = new GenericIndexKeyValidator(120, this.descriptor, layout, SchemaTestUtil.SIMPLE_NAME_LOOKUP);
        validator.validate(42L, new Value[]{Values.intValue((int)10), DateValue.epochDate((long)100L), Values.stringValue((String)"abc")});
    }

    @Test
    void shouldInvolveSerializingToRealBytesIfMayCrossThreshold() {
        Layout layout = (Layout)Mockito.mock(Layout.class);
        Mockito.when((Object)((GenericKey)layout.newKey())).thenReturn((Object)new CompositeGenericKey(3, GenericIndexKeyValidatorTest.spatialSettings()));
        GenericIndexKeyValidator validator = new GenericIndexKeyValidator(48, this.descriptor, layout, SchemaTestUtil.SIMPLE_NAME_LOOKUP);
        IllegalArgumentException e = (IllegalArgumentException)org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> validator.validate(42L, new Value[]{Values.intValue((int)10), DateValue.epochDate((long)100L), Values.stringValue((String)"abcdefghijklmnopqrstuvw")}));
        Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"abcdefghijklmnopqrstuvw"});
        ((Layout)Mockito.verify((Object)layout)).newKey();
    }

    @Test
    void shouldReportCorrectValidationErrorsOnRandomlyGeneratedValues() {
        int slots = this.random.nextInt(1, 6);
        int maxLength = this.random.nextInt(15, 30) * slots;
        GenericLayout layout = new GenericLayout(slots, GenericIndexKeyValidatorTest.spatialSettings());
        GenericIndexKeyValidator validator = new GenericIndexKeyValidator(maxLength, this.descriptor, (Layout)layout, SchemaTestUtil.SIMPLE_NAME_LOOKUP);
        GenericKey key = layout.newKey();
        for (int i = 0; i < 100; ++i) {
            boolean manualIsOk;
            boolean isOk;
            Object[] tuple = this.generateValueTuple(slots);
            try {
                validator.validate(42L, (Value[])tuple);
                isOk = true;
            }
            catch (IllegalArgumentException e) {
                isOk = false;
            }
            int actualSize = GenericIndexKeyValidatorTest.actualSize((Value[])tuple, key);
            boolean bl = manualIsOk = actualSize <= maxLength;
            if (manualIsOk == isOk) continue;
            org.junit.jupiter.api.Assertions.fail((String)String.format("Validator not validating %s correctly. Manual validation on actual key resulted in %b whereas validator said %b", Arrays.toString(tuple), manualIsOk, isOk));
        }
    }

    private static IndexSpecificSpaceFillingCurveSettings spatialSettings() {
        return IndexSpecificSpaceFillingCurveSettings.fromConfig((Config)Config.defaults());
    }

    private static int actualSize(Value[] tuple, GenericKey key) {
        key.initialize(0L);
        for (int i = 0; i < tuple.length; ++i) {
            key.initFromValue(i, tuple[i], NativeIndexKey.Inclusion.NEUTRAL);
        }
        return key.size();
    }

    private Value[] generateValueTuple(int slots) {
        Value[] tuple = new Value[slots];
        for (int j = 0; j < slots; ++j) {
            tuple[j] = this.random.nextValue();
        }
        return tuple;
    }
}

