/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.helpers.DatabaseReadOnlyChecker;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.memory.ByteBufferFactory;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.LoggingMonitor;
import org.neo4j.kernel.api.schema.SchemaTestUtil;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogAssertions;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.monitoring.Monitors;
import org.neo4j.test.extension.EphemeralNeo4jLayoutExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.pagecache.EphemeralPageCacheExtension;
import org.neo4j.test.rule.TestDirectory;

@EphemeralPageCacheExtension
@EphemeralNeo4jLayoutExtension
abstract class IndexProviderTests {
    static final int indexId = 1;
    static final int labelId = 1;
    static final int propId = 1;
    @Inject
    private PageCache pageCache;
    @Inject
    private TestDirectory testDirectory;
    @Inject
    private FileSystemAbstraction fs;
    @Inject
    private DatabaseLayout databaseLayout;
    private final AssertableLogProvider logging;
    private final Monitors monitors;
    private final ProviderFactory factory;
    final TokenNameLookup tokenNameLookup = SchemaTestUtil.SIMPLE_NAME_LOOKUP;
    IndexProvider provider;

    IndexProviderTests(ProviderFactory factory) {
        this.factory = factory;
        this.logging = new AssertableLogProvider();
        this.monitors = new Monitors();
        this.monitors.addMonitorListener((Object)new LoggingMonitor(this.logging.getLog("test")), new String[0]);
    }

    @BeforeEach
    void setup() throws IOException {
        this.setupIndexFolders(this.fs);
    }

    abstract void setupIndexFolders(FileSystemAbstraction var1) throws IOException;

    abstract IndexDescriptor descriptor();

    abstract IndexDescriptor otherDescriptor();

    abstract IndexPrototype validPrototype();

    abstract List<IndexPrototype> invalidPrototypes();

    @Test
    void validatePrototypeMustAcceptValidPrototype() {
        this.provider = this.newProvider();
        IndexPrototype validPrototype = this.validPrototype();
        Assertions.assertDoesNotThrow(() -> this.provider.validatePrototype(validPrototype));
    }

    @Test
    void validatePrototypeMustThrowOnInvalidPrototype() {
        this.provider = this.newProvider();
        List<IndexPrototype> invalidPrototypes = this.invalidPrototypes();
        for (IndexPrototype invalidPrototype : invalidPrototypes) {
            Assertions.assertThrows(IllegalArgumentException.class, () -> this.provider.validatePrototype(invalidPrototype));
        }
    }

    @Test
    void getPopulatorMustThrowIfInReadOnlyMode() {
        this.provider = this.newReadOnlyProvider();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.provider.getPopulator(this.descriptor(), IndexProviderTests.samplingConfig(), ByteBufferFactory.heapBufferFactory((int)1024), (MemoryTracker)EmptyMemoryTracker.INSTANCE, this.tokenNameLookup));
    }

    @Test
    void getPopulationFailureReturnEmptyStringIfNoFailure() throws IOException {
        this.provider = this.newProvider();
        IndexPopulator populator = this.provider.getPopulator(this.descriptor(), IndexProviderTests.samplingConfig(), ByteBufferFactory.heapBufferFactory((int)1024), (MemoryTracker)EmptyMemoryTracker.INSTANCE, this.tokenNameLookup);
        populator.create();
        populator.close(true, CursorContext.NULL);
        Assertions.assertEquals((Object)"", (Object)this.provider.getPopulationFailure(this.descriptor(), CursorContext.NULL));
    }

    @Test
    void getPopulationFailureReturnEmptyStringIfFailureOnOtherIndex() throws IOException {
        this.provider = this.newProvider();
        IndexPopulator nonFailedPopulator = this.provider.getPopulator(this.descriptor(), IndexProviderTests.samplingConfig(), ByteBufferFactory.heapBufferFactory((int)1024), (MemoryTracker)EmptyMemoryTracker.INSTANCE, this.tokenNameLookup);
        nonFailedPopulator.create();
        nonFailedPopulator.close(true, CursorContext.NULL);
        IndexPopulator failedPopulator = this.provider.getPopulator(this.otherDescriptor(), IndexProviderTests.samplingConfig(), ByteBufferFactory.heapBufferFactory((int)1024), (MemoryTracker)EmptyMemoryTracker.INSTANCE, this.tokenNameLookup);
        failedPopulator.create();
        failedPopulator.markAsFailed("failure");
        failedPopulator.close(false, CursorContext.NULL);
        String populationFailure = this.provider.getPopulationFailure(this.descriptor(), CursorContext.NULL);
        Assertions.assertEquals((Object)"", (Object)populationFailure);
    }

    @Test
    void getPopulationFailureMustReturnReportedFailure() throws IOException {
        this.provider = this.newProvider();
        IndexPopulator populator = this.provider.getPopulator(this.descriptor(), IndexProviderTests.samplingConfig(), ByteBufferFactory.heapBufferFactory((int)1024), (MemoryTracker)EmptyMemoryTracker.INSTANCE, this.tokenNameLookup);
        populator.create();
        String failureMessage = "fail";
        populator.markAsFailed(failureMessage);
        populator.close(false, CursorContext.NULL);
        String populationFailure = this.provider.getPopulationFailure(this.descriptor(), CursorContext.NULL);
        LogAssertions.assertThat((String)populationFailure).isEqualTo(failureMessage);
    }

    @Test
    void getPopulationFailureMustReturnReportedFailuresForDifferentIndexIds() throws IOException {
        this.provider = this.newProvider();
        IndexPopulator firstPopulator = this.provider.getPopulator(this.descriptor(), IndexProviderTests.samplingConfig(), ByteBufferFactory.heapBufferFactory((int)1024), (MemoryTracker)EmptyMemoryTracker.INSTANCE, this.tokenNameLookup);
        firstPopulator.create();
        IndexPopulator secondPopulator = this.provider.getPopulator(this.otherDescriptor(), IndexProviderTests.samplingConfig(), ByteBufferFactory.heapBufferFactory((int)1024), (MemoryTracker)EmptyMemoryTracker.INSTANCE, this.tokenNameLookup);
        secondPopulator.create();
        String firstFailure = "first failure";
        firstPopulator.markAsFailed(firstFailure);
        firstPopulator.close(false, CursorContext.NULL);
        String secondFailure = "second failure";
        secondPopulator.markAsFailed(secondFailure);
        secondPopulator.close(false, CursorContext.NULL);
        LogAssertions.assertThat((String)this.provider.getPopulationFailure(this.descriptor(), CursorContext.NULL)).isEqualTo(firstFailure);
        LogAssertions.assertThat((String)this.provider.getPopulationFailure(this.otherDescriptor(), CursorContext.NULL)).isEqualTo(secondFailure);
    }

    @Test
    void getPopulationFailureMustPersistReportedFailure() throws IOException {
        this.provider = this.newProvider();
        IndexPopulator populator = this.provider.getPopulator(this.descriptor(), IndexProviderTests.samplingConfig(), ByteBufferFactory.heapBufferFactory((int)1024), (MemoryTracker)EmptyMemoryTracker.INSTANCE, this.tokenNameLookup);
        populator.create();
        String failureMessage = "fail";
        populator.markAsFailed(failureMessage);
        populator.close(false, CursorContext.NULL);
        this.provider = this.newProvider();
        String populationFailure = this.provider.getPopulationFailure(this.descriptor(), CursorContext.NULL);
        LogAssertions.assertThat((String)populationFailure).isEqualTo(failureMessage);
    }

    @Test
    void shouldReportCorrectInitialStateIfIndexDoesntExist() {
        this.provider = this.newProvider();
        InternalIndexState state = this.provider.getInitialState(this.descriptor(), CursorContext.NULL);
        Assertions.assertEquals((Object)InternalIndexState.POPULATING, (Object)state);
        LogAssertions.assertThat((AssertableLogProvider)this.logging).containsMessages(new String[]{"Failed to open index"});
    }

    @Test
    void shouldReportInitialStateAsPopulatingIfPopulationStartedButIncomplete() throws IOException {
        this.provider = this.newProvider();
        IndexPopulator populator = this.provider.getPopulator(this.descriptor(), IndexProviderTests.samplingConfig(), ByteBufferFactory.heapBufferFactory((int)1024), (MemoryTracker)EmptyMemoryTracker.INSTANCE, this.tokenNameLookup);
        populator.create();
        InternalIndexState state = this.provider.getInitialState(this.descriptor(), CursorContext.NULL);
        Assertions.assertEquals((Object)InternalIndexState.POPULATING, (Object)state);
        populator.close(true, CursorContext.NULL);
    }

    @Test
    void shouldReportInitialStateAsFailedIfMarkedAsFailed() throws IOException {
        this.provider = this.newProvider();
        IndexPopulator populator = this.provider.getPopulator(this.descriptor(), IndexProviderTests.samplingConfig(), ByteBufferFactory.heapBufferFactory((int)1024), (MemoryTracker)EmptyMemoryTracker.INSTANCE, this.tokenNameLookup);
        populator.create();
        populator.markAsFailed("Just some failure");
        populator.close(false, CursorContext.NULL);
        InternalIndexState state = this.provider.getInitialState(this.descriptor(), CursorContext.NULL);
        Assertions.assertEquals((Object)InternalIndexState.FAILED, (Object)state);
    }

    @Test
    void shouldReportInitialStateAsOnlineIfPopulationCompletedSuccessfully() throws IOException {
        this.provider = this.newProvider();
        IndexPopulator populator = this.provider.getPopulator(this.descriptor(), IndexProviderTests.samplingConfig(), ByteBufferFactory.heapBufferFactory((int)1024), (MemoryTracker)EmptyMemoryTracker.INSTANCE, this.tokenNameLookup);
        populator.create();
        populator.close(true, CursorContext.NULL);
        InternalIndexState state = this.provider.getInitialState(this.descriptor(), CursorContext.NULL);
        Assertions.assertEquals((Object)InternalIndexState.ONLINE, (Object)state);
    }

    private IndexProvider newProvider(DatabaseReadOnlyChecker readOnlyChecker) {
        return this.factory.create(this.pageCache, this.fs, IndexDirectoryStructure.directoriesByProvider((Path)this.testDirectory.absolutePath()), this.monitors, RecoveryCleanupWorkCollector.immediate(), readOnlyChecker, this.databaseLayout);
    }

    IndexProvider newProvider() {
        return this.newProvider(DatabaseReadOnlyChecker.writable());
    }

    private IndexProvider newReadOnlyProvider() {
        return this.newProvider(DatabaseReadOnlyChecker.readOnly());
    }

    static IndexSamplingConfig samplingConfig() {
        return new IndexSamplingConfig(Config.defaults());
    }

    IndexDescriptor completeConfiguration(IndexDescriptor indexDescriptor) {
        return this.provider.completeConfiguration(indexDescriptor);
    }

    @FunctionalInterface
    static interface ProviderFactory {
        public IndexProvider create(PageCache var1, FileSystemAbstraction var2, IndexDirectoryStructure.Factory var3, Monitors var4, RecoveryCleanupWorkCollector var5, DatabaseReadOnlyChecker var6, DatabaseLayout var7);
    }
}

