/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.config;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.Config;
import org.neo4j.kernel.impl.index.schema.config.CrsConfig;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.values.storable.CoordinateReferenceSystem;

@TestDirectoryExtension
class CrsConfigTest {
    @Inject
    private TestDirectory testDirectory;

    CrsConfigTest() {
    }

    @Test
    void testCrsConfigMigration() throws IOException {
        Path confFile = this.testDirectory.createFile("test.conf");
        Files.write(confFile, Arrays.asList("unsupported.dbms.db.spatial.crs.cartesian-3d.min.x=1", "unsupported.dbms.db.spatial.crs.cartesian-3d.min.y=2", "unsupported.dbms.db.spatial.crs.cartesian-3d.min.z=3", "unsupported.dbms.db.spatial.crs.cartesian.min.x=3", "unsupported.dbms.db.spatial.crs.cartesian.max.x=4"), new OpenOption[0]);
        Config config = Config.newBuilder().fromFile(confFile).build();
        double DELTA = 1.0E-8;
        List cartesian3Dmin = (List)config.get(CrsConfig.group((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian_3D).min);
        Assertions.assertArrayEquals((double[])new double[]{1.0, 2.0, 3.0}, (double[])ArrayUtils.toPrimitive((Double[])cartesian3Dmin.toArray(new Double[0])), (double)1.0E-8);
        Assertions.assertEquals((double)3.0, (double)((Double)((List)config.get(CrsConfig.group((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian).min)).get(0)), (double)1.0E-8);
        Assertions.assertEquals((double)4.0, (double)((Double)((List)config.get(CrsConfig.group((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian).max)).get(0)), (double)1.0E-8);
    }
}

