/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.collections.api.tuple.Pair;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.schema.IndexConfig;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.memory.ByteBuffers;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.storemigration.IndexMigration;
import org.neo4j.kernel.impl.storemigration.SpatialConfigExtractor;
import org.neo4j.kernel.impl.storemigration.SpatialFile;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogAssertions;
import org.neo4j.logging.NullLog;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.test.Unzip;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.pagecache.PageCacheExtension;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@PageCacheExtension
class SpatialConfigExtractorTest {
    private static final String ZIP_HEALTHY_SPATIAL_35_DIR = "healthy-spatial-35-dir.zip";
    private static final String HEALTHY_SPATIAL_35_DIR = "healthy-spatial-35-dir";
    private static final String ZIP_FAILED_SPATIAL_35_DIR = "failed-spatial-35-dir.zip";
    private static final String FAILED_SPATIAL_35_DIR = "failed-spatial-35-dir";
    private static final Map<String, Value> staticExpectedIndexConfig = new HashMap<String, Value>();
    @Inject
    FileSystemAbstraction fs;
    @Inject
    PageCache pageCache;
    @Inject
    TestDirectory directory;

    SpatialConfigExtractorTest() {
    }

    @Test
    void shouldLogFailureToExtractIndexConfigFromGenericBecauseOfIndexInFailedState() throws IOException {
        Unzip.unzip(this.getClass(), (String)ZIP_FAILED_SPATIAL_35_DIR, (Path)this.directory.homePath());
        AssertableLogProvider logProvider = new AssertableLogProvider();
        Log myLog = logProvider.getLog(this.getClass());
        Path spatialDirectory = this.directory.homePath().resolve(FAILED_SPATIAL_35_DIR);
        Assertions.assertTrue((boolean)this.fs.fileExists(spatialDirectory));
        Assertions.assertTrue((boolean)this.fs.isDirectory(spatialDirectory));
        List spatialFiles = IndexMigration.getSpatialFiles((FileSystemAbstraction)this.fs, (Path)spatialDirectory);
        SpatialConfigExtractor.indexConfigFromSpatialFile((PageCache)this.pageCache, (List)spatialFiles, (CursorContext)CursorContext.NULL, (Log)myLog, (String)"neo4j");
        String reason = "Index is in FAILED state.";
        this.assertContainsLogEntry(logProvider, ((SpatialFile)spatialFiles.get(0)).getIndexFile(), reason);
    }

    @Test
    void shouldLogFailureToExtractIndexConfigFromGenericBecauseOfIndexInCorruptState() throws IOException {
        AssertableLogProvider logProvider = new AssertableLogProvider();
        Log myLog = logProvider.getLog(this.getClass());
        SpatialFile spatialFile = new SpatialFile(CoordinateReferenceSystem.WGS84, this.directory.file("spatialFile"));
        SpatialConfigExtractorTest.corruptFile(this.fs, spatialFile.getIndexFile());
        SpatialConfigExtractor.indexConfigFromSpatialFile((PageCache)this.pageCache, Collections.singletonList(spatialFile), (CursorContext)CursorContext.NULL, (Log)myLog, (String)"neo4j");
        String reason = "Index meta data is corrupt and can not be parsed.";
        this.assertContainsLogEntry(logProvider, spatialFile.getIndexFile(), reason);
    }

    @Test
    void shouldBeAbleToExtractConfigFromHealthy35File() throws IOException {
        Unzip.unzip(this.getClass(), (String)ZIP_HEALTHY_SPATIAL_35_DIR, (Path)this.directory.homePath());
        Path spatialDir = this.directory.file(HEALTHY_SPATIAL_35_DIR);
        Assertions.assertTrue((boolean)this.fs.fileExists(spatialDir));
        List spatialFiles = IndexMigration.getSpatialFiles((FileSystemAbstraction)this.fs, (Path)spatialDir);
        IndexConfig indexConfig = SpatialConfigExtractor.indexConfigFromSpatialFile((PageCache)this.pageCache, (List)spatialFiles, (CursorContext)CursorContext.NULL, (Log)NullLog.getInstance(), (String)"neo4j");
        SpatialConfigExtractorTest.assertExpectedIndexConfig(indexConfig);
    }

    private void assertContainsLogEntry(AssertableLogProvider logProvider, Path genericFile, String reason) {
        LogAssertions.assertThat((AssertableLogProvider)logProvider).forClass(this.getClass()).forLevel(AssertableLogProvider.Level.WARN).containsMessages(new String[]{"Could not extract index configuration from migrating index file. " + reason + " Index will be recreated with currently configured settings instead, indexFile=" + genericFile.toAbsolutePath()});
    }

    private static void corruptFile(FileSystemAbstraction fs, Path spatialFile) throws IOException {
        try (StoreChannel write = fs.write(spatialFile);){
            int size = 100;
            byte[] bytes = new byte[size];
            Arrays.fill(bytes, (byte)9);
            ByteBuffer byteBuffer = ByteBuffers.allocate((int)size, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            byteBuffer.put(bytes);
            write.writeAll(byteBuffer);
        }
        Assertions.assertTrue((boolean)fs.fileExists(spatialFile));
    }

    private static void assertExpectedIndexConfig(IndexConfig indexConfig) {
        HashMap<String, Value> expectedIndexConfig = new HashMap<String, Value>(staticExpectedIndexConfig);
        for (Pair entry : indexConfig.entries()) {
            String actualKey = (String)entry.getOne();
            Value actualValue = (Value)entry.getTwo();
            Value expectedValue = (Value)expectedIndexConfig.remove(actualKey);
            Assertions.assertNotNull((Object)expectedValue, (String)("Actual index config had map entry that was not among expected " + entry));
            Assertions.assertEquals((int)0, (int)Values.COMPARATOR.compare(expectedValue, actualValue), (String)String.format("Expected and actual index config value differed for %s, expected %s but was %s.", actualKey, expectedValue, actualValue));
        }
        Assertions.assertTrue((boolean)expectedIndexConfig.isEmpty(), (String)("Actual index config was missing some values: " + expectedIndexConfig));
    }

    static {
        staticExpectedIndexConfig.put("spatial.wgs-84.min", (Value)Values.doubleArray((double[])new double[]{-1.0, -2.0}));
        staticExpectedIndexConfig.put("spatial.wgs-84.max", (Value)Values.doubleArray((double[])new double[]{3.0, 4.0}));
        staticExpectedIndexConfig.put("spatial.wgs-84-3d.min", (Value)Values.doubleArray((double[])new double[]{-5.0, -6.0, -7.0}));
        staticExpectedIndexConfig.put("spatial.wgs-84-3d.max", (Value)Values.doubleArray((double[])new double[]{8.0, 9.0, 10.0}));
        staticExpectedIndexConfig.put("spatial.cartesian.min", (Value)Values.doubleArray((double[])new double[]{-11.0, -12.0}));
        staticExpectedIndexConfig.put("spatial.cartesian.max", (Value)Values.doubleArray((double[])new double[]{13.0, 14.0}));
        staticExpectedIndexConfig.put("spatial.cartesian-3d.min", (Value)Values.doubleArray((double[])new double[]{-15.0, -16.0, -17.0}));
        staticExpectedIndexConfig.put("spatial.cartesian-3d.max", (Value)Values.doubleArray((double[])new double[]{18.0, 19.0, 20.0}));
    }
}

